package com.elitesland.yst.production.inv.application.facade.vo;

import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author lu.wang
 * @date 2020-08-12 08:16
 * Desc: 库内组装单及明细VO
 */
@Data
@ApiModel(value = "INV_ASM_ASMD", description = "库内组装单及明细VO")
public class InvAsmAndAsmRespDVO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = 2917363253371374900L;

    // 主表信息
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long ouId;
    String ouName;

    @ApiModelProperty("单据编号")
    String docNo;

    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long buId;

    @ApiModelProperty("转移类型 [UDC]INV:TRN_TYPE")
    @SysCode(sys = "yst-inv", mod = "TRN_TYPE")
    String docType;
    String docTypeName;

    @ApiModelProperty("转移单状态 [UDC]INV:TRN_STATUS")
    @SysCode(sys = "yst-inv", mod = "TRN_STATUS")
    String docStatus;
    String docStatusName;

    @ApiModelProperty("审批状态 [UDC]COM:APPR_STATUS")
    @SysCode(sys = "COM", mod = "APPR_STATUS")
    String apprStatus;
    String apprStatusName;

    @ApiModelProperty("原因码 [UDC]COM:REASON_CODE")
    @SysCode(sys = "COM", mod = "REASON_CODE")
    String reasonCode;
    String reasonCodeName;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long whId;
    String whCode;
    String whName;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    @SysCode(sys = "yst-inv", mod = "TEMP_TYPE")
    String deter1;
    String deter1Name;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    @SysCode(sys = "yst-inv", mod = "FUNC_TYPE")
    String deter2;
    String deter2Name;

    @ApiModelProperty("客户标识")
    String deter3;

    @ApiModelProperty("申请日期")
    LocalDateTime applyDate;

    @ApiModelProperty("交易日期 实际出入库日期")
    LocalDateTime ioDate;

    @ApiModelProperty("流程实例ID")
    String apprProcInstId;

    // 明细表信息
    @ApiModelProperty("主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long masId;

    @ApiModelProperty("行号")
    Float lineNo;

    @ApiModelProperty("行状态")
    String lineStatus;

    @ApiModelProperty("行类型 [UDC]COM:IO")
    @SysCode(sys = "COM", mod = "IO")
    String lineType;
    String lineTypeName;

    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long itemId;
    String itemCode;
    String itemName;

    @ApiModelProperty("规格")
    String packageSpec;

    @ApiModelProperty("品牌编码")
//    @SysCode(sys = "ITM", mod = "ITEM_GROUP")
    String brand;
    String brandName;

    @ApiModelProperty("异构ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long variId;

    @ApiModelProperty("批次")
    String lotNo;

    @ApiModelProperty("序列号")
    String snNo;

    @ApiModelProperty("数量")
    BigDecimal qty;

    @ApiModelProperty("单位")
    @SysCode(sys = "COM", mod = "UOM")
    String uom;
    String uomName;

    @ApiModelProperty("数量2")
    BigDecimal qty2;

    @ApiModelProperty("单位2")
    String uom2;

    @ApiModelProperty("单位转换率")
    Float uomRatio;

    @ApiModelProperty("单位转换率2")
    Float uomRatio2;

    @ApiModelProperty("生产日期")
    LocalDateTime manuDate;

    @ApiModelProperty("生产批次")
    String manuLotNo;

    @ApiModelProperty("失效日期")
    LocalDateTime expireDate;

    @ApiModelProperty("税额")
    BigDecimal taxAmt;

    @ApiModelProperty("含税金额")
    BigDecimal amt;

    @ApiModelProperty("不含税金额")
    BigDecimal netAmt;

    @ApiModelProperty("记账币种")
    String homeCurr;

    @ApiModelProperty("交易币种")
    String currCode;

    @ApiModelProperty("汇率")
    Float currRate;

    @ApiModelProperty("外币不含税金额")
    BigDecimal currNetAmt;

    @ApiModelProperty("外币含税金额")
    BigDecimal currAmt;

    @ApiModelProperty("单位成本")
    BigDecimal costPrice;

    @ApiModelProperty("成本金额")
    BigDecimal costAmt;

    @ApiModelProperty("库存可用量")
    Double avalQty;

    @ApiModelProperty("外部单据编号")
    String outerNo;

    @ApiModelProperty("外部单据行号")
    String outerLineno;

    @ApiModelProperty("外部单据公司")
    String outerOu;

    @ApiModelProperty("外部单据类型")
    String outerType;
}
