package com.elitesland.yst.production.inv.application.facade.vo;

import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author lu.wang
 * @date 2020-08-11 16:04
 * Desc:
 */
@Data
@ApiModel(value = "INV_ASM_D", description = "库内组装明细")
public class InvAsmDRespVO extends BaseModelVO implements Serializable
{
    private static final long serialVersionUID = 5804989339298662169L;
    @ApiModelProperty("主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long masId;

    @ApiModelProperty("行号")
    Double lineNo;

    @ApiModelProperty("行状态")
    String lineStatus;

    @ApiModelProperty("行类型 [UDC]COM:IO")
    @SysCode(sys = "COM", mod = "IO")
    String lineType;
    String lineTypeName;

    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long itemId;

    @ApiModelProperty("异构ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long variId;

    @ApiModelProperty("批次")
    String lotNo;

    @ApiModelProperty("序列号")
    String snNo;

    @ApiModelProperty("数量")
    BigDecimal qty;

    @ApiModelProperty("单位")
    String uom;

    @ApiModelProperty("数量2")
    BigDecimal qty2;

    @ApiModelProperty("单位2")
    String uom2;

    @ApiModelProperty("单位转换率")
    Float uomRatio;

    @ApiModelProperty("单位转换率2")
    Float uomRatio2;

    @ApiModelProperty("生产日期")
    LocalDateTime manuDate;

    @ApiModelProperty("生产批号")
    String manuLotNo;

    @ApiModelProperty("失效日期")
    LocalDateTime expireDate;

    @ApiModelProperty("税额")
    BigDecimal taxAmt;

    @ApiModelProperty("含税金额")
    BigDecimal amt;

    @ApiModelProperty("不含税金额")
    BigDecimal netAmt;

    @ApiModelProperty("记账币种")
    String homeCurr;

    @ApiModelProperty("交易币种")
    String currCode;

    @ApiModelProperty("交易币种名")
    String currCodeName;

    @ApiModelProperty("汇率")
    Float currRate;

    @ApiModelProperty("外币不含税金额")
    BigDecimal currNetAmt;

    @ApiModelProperty("外币含税金额")
    BigDecimal currAmt;

    @ApiModelProperty("单位成本")
    BigDecimal costPrice;

    @ApiModelProperty("成本金额")
    BigDecimal costAmt;

    @ApiModelProperty("外部单据号")
    String outerNo;

    @ApiModelProperty("外部单据行号")
    String outerLineno;
}
