package com.elitesland.yst.production.inv.application.facade.vo;

import com.elitesland.yst.production.inv.utils.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 设置项(SysSetting)实体类
 *
 * @author ssy
 * @since 2020-08-19 14:51:53
 */

@Data
@ApiModel(value = "inv_setting", description = "设置项")
public class InvSettingRespVO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = -58765996123335054L;
    /**
     * 唯一编号ID
     */
    @ApiModelProperty("唯一编号ID")
    private Long id;
    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;
    /**
     * 记录创建者ID
     */
    @ApiModelProperty("记录创建者ID")
    private Long createUserId;
    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;
    /**
     * 记录最后更新者ID
     */
    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId;
    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;
    /**
     * 逻辑删除，0：未删除，1：已删除
     */
    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;
    /**
     * 版本信息，前端不用传
     */
    @ApiModelProperty("版本信息，前端不用传")
    private Integer auditDataVersion;
    /**
     * 设置编号
     */
    @ApiModelProperty("设置编号")
    private String settingNo;
    /**
     * 设置名
     */
    @ApiModelProperty("设置名")
    private String settingName;
    /**
     * 设置类型
     */
    @ApiModelProperty("设置类型")
    private String settingType;
    /**
     * 设置类型2
     */
    @ApiModelProperty("设置类型2")
    private String settingType2;
    /**
     * 设置类型3
     */
    @ApiModelProperty("设置类型3")
    private String settingType3;
    /**
     * 设置状态
     */
    @ApiModelProperty("设置状态")
    private String settingStatus;
    /**
     * 设置描述
     */
    @ApiModelProperty("设置描述")
    private String settingDesc;
    /**
     * 设置值
     */
    @ApiModelProperty("设置值")
    private String settingVal;
    /**
     * 默认值
     */
    @ApiModelProperty("默认值")
    private String defVal;
    /**
     * 排序号
     */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    /**
     * 租户ID
     */
    @ApiModelProperty("租户ID")
    private Long tenantId;


}