package com.elitesland.yst.production.inv.application.facade.vo.ck;


import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * @author lvqf
 * @Date 2021/2/20
 * @Description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class InvCkCreateParamVO extends BaseModelVO implements Serializable {


    private static final long serialVersionUID = 191762037208851241L;
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private  Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("盘点类型 [UDC]INV:CK_TYPE")
    private String docType;

    @ApiModelProperty("盘点模式 [UDC]INV:CK_MODE")
    private String docMode;

    @ApiModelProperty("盘点方式 [UDC]INV:CK_METHOD")
    private String docMethod;

    @ApiModelProperty("仓库ID集合")
    private List<Long> whIdList;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private List<String> deter2List;

    @ApiModelProperty("商品ID集合")
    private List<Long> itemIdList;


}
