package com.elitesland.yst.production.inv.application.facade.vo.invstk;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.util.List;

/**
 * 库存结存明细库存结存报表查询
 *
 * @author jeese.jiang
 * @since 2021-5-17
 */
@Data
@ApiModel(description = "库存结存报表查询")
public class InvStkQueryGroupParamVO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = -64623649498862804L;

    @ApiModelProperty("品牌")
    private List<String> brands;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID集合")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> ouIds;


    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;
    /**
     * 品项ID
     */
    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;
    /**
     * 异构ID
     */
    @ApiModelProperty("异构ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long variId;

    /**
     * 异构ID
     */
    @ApiModelProperty("异构ID集合")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> variIds;

    /**
     * 品项编号
     */
    @ApiModelProperty("品项编号")
    private String itemCode;

    /**
     * 品项编号
     */
    @ApiModelProperty("品项编号集合")
    private List<String> itemCodes;

    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID集合")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> whIds;

    @ApiModelProperty("仓库类型")
    private String whType;

    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;

    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String uom;


    @ApiModelProperty("功能区ID集合")
    private List<String> deter2s;

    @ApiModelProperty("商品ID集合")
    private List<Long> itemIds;

    /**
     * 商品类型
     */
    @ApiModelProperty("商品类型")
    private String itemType;

    @ApiModelProperty("物料类型")
    private String itemType2;

    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;

    @ApiModelProperty("创建人id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;

    @ApiModelProperty("合作伙伴类型")
    private String pType;

    @ApiModelProperty("合作伙伴code")
    private String pCode;

    @ApiModelProperty("limit1")
    private String limit1;

    @ApiModelProperty("limit2")
    private String limit2;

    @ApiModelProperty("limit3")
    private String limit3;

    @ApiModelProperty("批次号")
    private String lotNo;

    @ApiModelProperty("功能区关键字")
    private String deter2KeyWord;

}
