package com.elitesland.yst.production.inv.application.facade.vo.invwh;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.alibaba.excel.annotation.write.style.HeadRowHeight;
import com.alibaba.excel.annotation.write.style.HeadStyle;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.poi.ss.usermodel.FillPatternType;

import java.io.Serializable;

@Data
@HeadStyle(fillPatternType = FillPatternType.SOLID_FOREGROUND, fillForegroundColor = 55)
@HeadFontStyle(fontHeightInPoints = 11)
@HeadRowHeight(40)
public class InvExportWhRespVO implements Serializable {
    private static final long serialVersionUID = 8971323967196225557L;

    @ExcelIgnore
    @JsonSerialize(using = ToStringSerializer.class)
    Long id;

    //仓库编码
    @ApiModelProperty("仓库编码")
    @ExcelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库名称")
    @ExcelProperty("仓库名称")
    private String whName;

    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */
    @ExcelIgnore
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    @SysCode(sys = "yst-inv", mod = "FUNC_TYPE")
    private String deter2;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    @ExcelProperty("功能库区")
    private String deter2Name;

    /**
     * 仓库类型 [UDC]INV:WH_TYPE
     */
    @ApiModelProperty("仓库类型 [UDC]INV:WH_TYPE")
    @SysCode(sys = "yst-inv", mod = "WH_TYPE")
    @ExcelIgnore
    private String whType;

    @ApiModelProperty("仓库类型 [UDC]INV:WH_TYPE")
    @ExcelProperty("仓库类型")
    private String whTypeName;


    @ApiModelProperty("公司编码")
    @ExcelProperty("公司编码")
    private String ouCode;
    // private String ouCurr;

    @ApiModelProperty("公司名稱")
    @ExcelProperty("公司名称")
    private String ouName;

    /**
     * 仓库状态
     */
    @ApiModelProperty("仓库状态")
    @SysCode(sys = "COM", mod = "STATUS_ACTIVEORNO")
    @ExcelIgnore
    private String whStatus;

    @ApiModelProperty("仓库状态")
    @ExcelProperty("仓库状态")
    private String whStatusName;
    /**
     * 合作伙伴类型
     */
    @ApiModelProperty("库存合作伙伴类型")
    @ExcelProperty("库存合作伙伴类型")
    private String pType;

    /**
     * 库存合作伙伴编码
     */
    @ApiModelProperty("库存合作伙伴编号")
    @ExcelProperty("库存合作伙伴编号")
    private String pCode;

    /**
     * 库存合作伙伴名称
     */
    @ApiModelProperty("库存合作伙伴名称")
    @ExcelProperty("库存合作伙伴名称")
    private String pName;

    @ApiModelProperty("联系人")
    @ExcelProperty("联系人")
    private String contPerson;

    @ColumnWidth(22)
    @ApiModelProperty("联系电话")
    @ExcelProperty("联系电话")
    private String tel;





}
