package com.elitesland.yst.production.inv.application.facade.vo.invwh;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author jeesie.jiang
 * @since 2021-07-16 14:07:34
 */
@Data
@ApiModel(value = "invWhAreaRpcDtoParam", description = "库区")
public class InvWhAreaRpcDtoParam extends AbstractOrderQueryParam {

    //↓ 前端查询需要
    @ApiModelProperty("仓库编号")
    private String whCode;
    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("仓库Ids")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> whIds;

    @ApiModelProperty("公司Id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    /**
     * 仓库状态
     */
    @ApiModelProperty("仓库状态")
    private String whStatus;

    /**
     * 唯一编号ID
     */
    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;

    @ApiModelProperty("功能区类型")
    private String deter2Type;

    @ApiModelProperty("功能区类型集合")
    private List<String> deter2Types;


    @ApiModelProperty("仓库类型")
    private String whType;

    @ApiModelProperty("仓库类型")
    private String whType2;

    @ApiModelProperty("库存合作伙伴编码")
    private String pCode;

    @ApiModelProperty("库存合作伙伴类型")
    private String pType;

    @ApiModelProperty("库存合作伙伴类型")
    private String pptype;

    @ApiModelProperty("库存合作伙伴名称")
    private String pName;

    /**
     * E1BP编号
     */
    @ApiModelProperty("ERP编号")
    private String outerCode;

    /**
     * lu.wang 2020-11-07 13:24:28
     * 前端可输可选组件多字段查询关键字
     */
    @ApiModelProperty("多字段查询关键字")
    String multiKeywords;

    @ApiModelProperty("功能库区关键词")
    String deterType;

    /**
     * 用于收集模糊查询出的功能区
     */
    @ApiModelProperty("功能区")
    private List<String> deter2s;

    /**
     * 用于收集模糊查询出的仓库类型
     */
    @ApiModelProperty("仓库类型")
    private List<String> whTypes;

    /**
     * 记录创建者ID
     */
    @ApiModelProperty("记录创建者ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;
    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;
    /**
     * 记录最后更新者ID
     */
    @ApiModelProperty("记录最后更新者ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long modifyUserId;
    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;
    /**
     * 逻辑删除，0：未删除，1：已删除
     */
    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;
    /**
     * 版本信息，前端不用传
     */
    @ApiModelProperty("版本信息，前端不用传")
    private Integer auditDataVersion;



}