package com.elitesland.yst.production.inv.application.facade.vo.invwh;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;


/**
 * <p>
 * 仓库下拉 返回id、code、name
 * </p>
 *
 * @author zhao_qiaogong
 * @since 2020-08-1 14:00:46
 */
@Data
@ApiModel(value = "inv_wh", description = "仓库下拉 返回id、code、name,physicalWhCode")
public class InvWhListRespVO implements Serializable {

    private static final long serialVersionUID = -84413014701396628L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("仓库id")
    private Long id;
    /**
     * 仓库编号
     */
    @ApiModelProperty("仓库编号")
    private String whCode;

    /**
     * 仓库名称
     */
    @ApiModelProperty("仓库名称")
    private String whName;

    // 2020.08.11 roamn.zhang add
    @ApiModelProperty("实体仓库")
    private String physicalWhCode;

    // 2020.08.18 roamn.zhang add
    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    @SysCode(sys = "yst-inv", mod = "TEMP_TYPE")
    private String deter1;
    private String deter1Name;

    // 2020.08.31 roamn.zhang add
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    @SysCode(sys = "yst-inv", mod = "FUNC_TYPE")
    private String deter2;
    private String deter2Name;

    // 2020.08.31 roamn.zhang add
    @ApiModelProperty("客户标识")
    private String deter3;

    // 2020.08.24 roamn.zhang add
    @ApiModelProperty("发货地址")
    private String fromLoc;

    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrNo;

    //2020.8.25 liuqi add
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;
    //2020.9.28 liuqi add
    @ApiModelProperty("简称")
    private String whAbbr;

    @ApiModelProperty("仓库类型 [UDC]INV:WH_TYPE")
    String whType;

    /**
     * 仓库面积
     */
    @ApiModelProperty("仓库面积")
    private Double area;

    /**
     * 仓库结构
     */
    @ApiModelProperty("仓库结构")
    private String structure;

    /**
     * 是否装卸平台
     */
    @ApiModelProperty("是否装卸平台")
    private Integer plateformFlag;

    /**
     * 仓库固定资产
     */
    @ApiModelProperty("仓库固定资产")
    private String fixedAssets;
}
