package com.elitesland.yst.production.inv.application.facade.vo.ioc;

import com.elitesland.yst.production.inv.utils.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2022/04/19
 * @Version 1.0
 * @Content:
 */

@Data
@ApiModel(value = "InvIocSaveVO", description = "库存操作码")
@EqualsAndHashCode(callSuper = true)
public class InvIocSaveVO  extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = -6084527411643768273L;

    @ApiModelProperty("操作码")
    private String ioCode;

    @ApiModelProperty("操作码名称")
    private String ioName;

    @ApiModelProperty("操作类型 [UDC]INV:IO_TYPE")
    private String ioType;

    @ApiModelProperty("是否启用，默认为启用 [UDC]INV:ACTIVE_STATUS")
    private String status;

}
