package com.elitesland.yst.production.inv.application.out;


import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvUomQueryParamVO;
import com.elitesland.yst.production.support.provider.item.dto.*;
import com.elitesland.yst.production.support.provider.item.param.*;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;


/**
 * 商品域
 *
 * @Description: TODO
 * @Auther: menghua
 * @Date: 2021/3/10
 */
public interface ItmOutService {

    /**
     * 采购基础数据、采购价格、采购付款、供应商获取品牌全部信息接口查询
     *
     * @param param
     * @return
     */
    List<ItmItemRpcDTO> findItemRpcDtoByParam(ItmItemRpcDtoParam param);
    List<Long> findItemIdByParam(ItmItemRpcDtoParam param);

    /**
     * 商品单位转换率查询（新）
     */
    List<ItmItemUomConvRpcDTO> findItemUomConvDtoByParam(ItmItemUomConvRpcDtoParam param);

    List<ItmBrandRpcDTO> findItmBrandDtoByParam(ItmBrandRpcDtoParam param);

    List<ItmItemBusinessRpcDTO> findItmItemBusinessByParam(ItmItemBusinessRpcDtoParam param);

    Map<String, ItmCateCodeAndNameRpcDTO> findCateCodeReItemCateCode(ItmItemCateCodeParam param);

    BigDecimal getUomRatio(List<ItmItemUomConvRpcDTO> uomConvRpcDTOS, InvUomQueryParamVO paramVO);


}
