package com.elitesland.yst.production.inv.application.service.impl;

import com.alibaba.excel.util.CollectionUtils;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitesland.yst.production.inv.application.facade.vo.*;
import com.elitesland.yst.production.inv.application.facade.vo.base.InvBaseModel;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkRespVO;
import com.elitesland.yst.production.inv.application.out.ItmOutService;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.*;
import com.elitesland.yst.production.inv.application.service.stk.InvStkOptBizService;
import com.elitesland.yst.production.inv.domain.convert.InvAsmAndAsmDConvert;
import com.elitesland.yst.production.inv.domain.convert.InvAsmDConvert;
import com.elitesland.yst.production.inv.domain.convert.invstk.InvCommonConvert;
import com.elitesland.yst.production.inv.domain.entity.InvAsmDDO;
import com.elitesland.yst.production.inv.domain.entity.InvAsmDO;
import com.elitesland.yst.production.inv.domain.service.InvAsmDDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhAreaDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhDomainService;
import com.elitesland.yst.production.inv.enums.InvStkSceneCodeEnum;
import com.elitesland.yst.production.inv.infr.dto.InvAsmAndAsmDDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateBodyDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateDTO;
import com.elitesland.yst.production.inv.infr.repo.InvAsmDRepo;
import com.elitesland.yst.production.inv.infr.repo.InvAsmDRepoProc;
import com.elitesland.yst.production.inv.infr.repo.InvAsmRepo;
import com.elitesland.yst.production.inv.utils.InvStk28Enum;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.dto.OrgEmpRpcDTO;
import lombok.AllArgsConstructor;
import lombok.val;
import org.apache.commons.collections4.MapUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import javax.transaction.Transactional;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author jeesie.jiang
 * @date 2022-03-31 08:27
 * Desc:
 */
@Service
@AllArgsConstructor
public class InvAsmDServiceImpl implements InvAsmDService {

    private final InvAsmRepo invAsmRepo;
    private final InvAsmDRepo invAsmDRepo;
    private final InvAsmDRepoProc invAsmDRepoProc;
    private final InvStkCommonService invStkCommonService;
    private final InvStkService invStkService;
    private final InvAsmService invAsmService;
    private final InvWhDomainService invWhService;
    private final SystemService systemService;
    private final ItmOutService itmOutService;
    private final OrgOutService outouService;
    private final InvAsmDDomainService invAsmDDomainService;
    private final InvStkOptBizService invStkOptBizService;
    private final InvWhAreaDomainService invWhAreaDomainService;


    @Override
    @SysCodeProc
    public PagingVO<InvAsmAndAsmDRespVO> search(InvAsmAllQueryParam param) {
        PagingVO<InvAsmAndAsmDDTO> pagingVO = invAsmDDomainService.search(param);
        List<InvAsmAndAsmDDTO> invAsmAndAsmDDTOS = pagingVO.getRecords();
        List<InvAsmAndAsmDRespVO> asmDRespVOS = invAsmAndAsmDDTOS.stream()
                .map(InvAsmDConvert.INSTANCE::dtoToVo)
                .collect(Collectors.toList());
        //外部接口调用
        fillupNameList(asmDRespVOS);
        //UDC转换
        List<InvAsmAndAsmDRespVO> invAsmAndAsmDRespVOS = udcChange(asmDRespVOS);
        return PagingVO.<InvAsmAndAsmDRespVO>builder()
                .total(pagingVO.getTotal())
                .records(invAsmAndAsmDRespVOS)
                .build();
    }

    @Override
    @SysCodeProc
    public PagingVO<InvAsmAndAsmDRespVO> searchD(InvAsmAllQueryParam param) {
        PagingVO<InvAsmAndAsmDDTO> pagingVO = invAsmDDomainService.search(param);
        List<InvAsmAndAsmDDTO> asmAndAsmDDTOS = pagingVO.getRecords();
        List<InvAsmAndAsmDRespVO> asmDRespVOS = asmAndAsmDDTOS.stream().map(InvAsmDConvert.INSTANCE::dtoToVo).collect(Collectors.toList());
        //调用外部接口
        fillupNameList(asmDRespVOS);
        //UDC转换
        List<InvAsmAndAsmDRespVO> invAsmAndAsmDRespVOS = udcChange(asmDRespVOS);
        return PagingVO.<InvAsmAndAsmDRespVO>builder()
                .total(pagingVO.getTotal())
                .records(invAsmAndAsmDRespVOS)
                .build();
    }
    @Override
    @SysCodeProc
    public List<InvAsmDRespVO> listByCostCal(InvCalCostQueryParam param, int current, int PAGE_SIZE){
        Pageable pageable = PageRequest.of(current-1, PAGE_SIZE);
        val invAsms = invAsmDRepoProc.listByCostCal(param,pageable);
        return  invAsms.stream().map(InvAsmDConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    @Override
    @SysCodeProc
    public List<InvAsmAndAsmDRespVO> findAll(InvAsmAllQueryParam param) {
        List<InvAsmAndAsmDDTO> asmAndAsmDDTOS = invAsmDDomainService.findAll(param);
        List<InvAsmAndAsmDRespVO> asmDRespVOS = asmAndAsmDDTOS.stream()
                .map(InvAsmDConvert.INSTANCE::dtoToVo)
                .collect(Collectors.toList());
        fillupNameList(asmDRespVOS);
        //UDC转换
        List<InvAsmAndAsmDRespVO> invAsmAndAsmDRespVOS = udcChange(asmDRespVOS);
        return invAsmAndAsmDRespVOS;
    }

    /**
     * UDC手动转换
     *
     * @param asms
     * @return
     */
    public List<InvAsmAndAsmDRespVO> udcChange(List<InvAsmAndAsmDRespVO> asms) {
        //进行UDC转换(udcEnum只使用model，code)
        Map<String, String> udcDocType = systemService.sysUdcGetCodeMap(UdcEnum.INV_ASM_TYPE_DEF.getModel(), UdcEnum.INV_ASM_TYPE_DEF.getCode()); //转移类型
        Map<String, String> udcDocStatus = systemService.sysUdcGetCodeMap(UdcEnum.INV_ASM_STATUS_DR.getModel(), UdcEnum.INV_ASM_STATUS_DR.getCode());//转移单状态
        Map<String, String> udcApprStatus = systemService.sysUdcGetCodeMap(UdcEnum.COM_APPR_STATUS_APPROVING.getModel(), UdcEnum.COM_APPR_STATUS_APPROVING.getCode());//审批状态
        Map<String, String> udcIO = systemService.sysUdcGetCodeMap(UdcEnum.COM_IO_I.getModel(), UdcEnum.COM_IO_I.getCode());//出入行
        Map<String, String> udcDeter1 = systemService.sysUdcGetCodeMap(UdcEnum.INV_TEMP_TYPE_RT.getModel(), UdcEnum.INV_TEMP_TYPE_RT.getCode());//温层
        Map<String, String> udcReasonCode = systemService.sysUdcGetCodeMap(UdcEnum.COM_REASON_CODE_183.getModel(), UdcEnum.COM_REASON_CODE_183.getCode());//原因码
        Map<String, String> udcUom = systemService.sysUdcGetCodeMap(UdcEnum.COM_UOM_BG.getModel(), UdcEnum.COM_UOM_BG.getCode());//单位
        asms.stream().forEach(Asm -> {
            if (org.apache.commons.lang3.StringUtils.isNotBlank(Asm.getDocType()) && !MapUtils.isEmpty(udcDocType)) {
                Asm.setDocTypeName(udcDocType.get(Asm.getDocType()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank(Asm.getDocStatus()) && !MapUtils.isEmpty(udcDocStatus)) {
                Asm.setDocStatusName(udcDocStatus.get(Asm.getDocStatus()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank(Asm.getApprStatus()) && !MapUtils.isEmpty(udcApprStatus)) {
                Asm.setApprStatusName(udcApprStatus.get(Asm.getApprStatus()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank(Asm.getDeter1()) && !MapUtils.isEmpty(udcDeter1)) {
                Asm.setDeter1Name(udcDeter1.get(Asm.getDeter1()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank(Asm.getReasonCode()) && !MapUtils.isEmpty(udcReasonCode)) {
                Asm.setReasonCodeName(udcReasonCode.get(Asm.getReasonCode()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank(Asm.getUom()) && !MapUtils.isEmpty(udcUom)) {
                Asm.setUomName(udcUom.get(Asm.getUom()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank(Asm.getLineType()) && !MapUtils.isEmpty(udcIO)) {
                Asm.setLineTypeName(udcIO.get(Asm.getLineType()));
            }
        });
        return asms;
    }

    @Override
    @Transactional
    public int removeInBatch(List<Long> ids) {
        ids.forEach(id -> invAsmDRepo.deleteById(id));
        return ids.size();
    }

    /**
     * 提取出【提交确认(confirm)】中调用共通方法37--库存锁定
     *
     * @param invAsmDDOS
     * @param invAsmDO
     */
    public void useInvStkCommon37InVOS(List<InvAsmDDO> invAsmDDOS, InvAsmDO invAsmDO) {
        List<InvStkCommon37InSaveVO> invStkCommon37InSaveVOS = new ArrayList<>();
        invAsmDDOS.stream().forEach(v -> {
            if (v.getLineType().equals(UdcEnum.COM_IO_O.getValueCode())) {
                InvStkCommon37InSaveVO tmp = InvCommonConvert.INSTANCE.invAsmDDOToInvStkCommon37InVO(v);
                tmp.setInvStk28Enum1(InvStk28Enum.T_TYPE_27);
                tmp.setDeter1(invAsmDO.getDeter1());
                tmp.setDeter2(invAsmDO.getDeter2());
                tmp.setDeter3(invAsmDO.getDeter3());
                tmp.setWhId(invAsmDO.getWhId());
                tmp.setDocNo(invAsmDO.getDocNo());
                tmp.setSrcDocCls(UdcEnum.COM_DOC_CLS_ASM.getValueCode());
                tmp.setSrcDocId(v.getMasId());
                tmp.setSrcDocDid(v.getId());
                tmp.setOpDate(LocalDateTime.now());
                invStkCommon37InSaveVOS.add(tmp);
            }
        });
        if (!CollectionUtils.isEmpty(invStkCommon37InSaveVOS)) {
            invStkCommonService.invStkCommon37(invStkCommon37InSaveVOS);
        }
    }

    /**
     * 提取出【提交确认(confirm)】中调用共通方法22--新增批次主信息
     *
     * @param invAsmDDOS
     */
//    public void useCreateInvLotInfo(List<InvAsmDDO> invAsmDDOS) {
//        ArrayList<InvAsmDDO> asmDDOS = new ArrayList<>();
//        invAsmDDOS.stream().forEach(invAsmDDO -> {
//            if(invAsmDDO.getManuDate() != null && invAsmDDO.getExpireDate() != null && ! StringUtils.isEmpty(invAsmDDO.getLotNo())){
//                asmDDOS.add(invAsmDDO);
//            }
//        });
//        if(!CollectionUtils.isEmpty(asmDDOS)) {
//            //批次去重
//            ArrayList<InvAsmDDO> asmDDOS1 = asmDDOS.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(
//                    () -> new TreeSet<>(Comparator.comparing(o -> o.getItemId() + "_" + o.getLotNo() + "_" + o.getVariId()))),
//                    ArrayList::new));
//            if (invLotService.findByAndItemIdAndLotNo(asmDDOS1.stream().filter(v -> v.getLineType().equals(UdcEnum.COM_IO_I.getValueCode())).map(v ->
//                    v.getItemId() + "_" + v.getLotNo()).collect(Collectors.toList())).isEmpty()) {
//
//                // lineType='I'需要生成批次主信息 调用共通方法22
//                List<InvLotDO> invLotDOS = new ArrayList<>();
//                asmDDOS1.stream().filter(v -> v.getLineType().equals((UdcEnum.COM_IO_I.getValueCode()))).findAny().ifPresent(m -> {
//                    InvLotDO tmp = InvCommonConvert.INSTANCE.invAsmDDOTOInvLotDO(m);
//                    InvAsmDDO tmpAsm =  asmDDOS1.stream().filter(j -> j.getLineType().equals(UdcEnum.COM_IO_O.getValueCode()))
//                            .min(Comparator.comparing(InvAsmDDO::getExpireDate)).orElse(new InvAsmDDO());
//                    tmp.setExpireDays((int) ChronoUnit.DAYS.between(
//                            tmpAsm.getManuDate().toLocalDate(),
//                            tmpAsm.getExpireDate().toLocalDate()
//                    ));
//                    Optional<InvAsmDO> invAsmDOOptional1 = invAsmRepo.findById(tmpAsm.getMasId());
//                    if (invAsmDOOptional1.isPresent()) {
//                        tmp.setSrcDocNo(invAsmDOOptional1.get().getDocNo());
//                        tmp.setSrcDocCls(UdcEnum.COM_DOC_CLS_ASM.getValueCode());
//                        tmp.setOuId(invAsmDOOptional1.get().getOuId());
//                        //tmp.setBuId(invAsmDOOptional1.get().getBuId());
//                    }
//                    invLotDOS.add(tmp);
//                });
//                //将invLotDOS类型转换为invLotVOS
//                List<InvLotSaveVO> invLotDOS1 = new ArrayList<>();
//                invLotDOS.stream().forEach(invLotVOS -> {
//                    InvLotSaveVO invLotSaveVO = InvLotCovert.INSTANCE.doToSaveVO(invLotVOS);
//                    invLotDOS1.add(invLotSaveVO);
//                });
//                invLotCommonService.createInvLotInfo(invLotDOS1);
//            }
//        }
//    }

    /**
     * 提取出【提交确认(confirm)】中调用共通方法28--更新库存
     *
     * @param masId
     */
    public void useInvStkCommon28(Long masId) {
        val param = new InvAsmAllQueryParam();
        param.setMasId(masId);

        invStkCommonService.invStkCommon28(
                findAll(param).stream().map(v -> {
                    InvStkCommon28InSaveVO tmp = InvCommonConvert.INSTANCE.invAsmDVOAndInvAsmVOToInvStkCommon28InRespVO(v);
                    tmp.setSrcDocCls(UdcEnum.COM_DOC_CLS_ASM.getValueCode());
                    if (v.getLineType().equals(UdcEnum.COM_IO_I.getValueCode())) {
                        tmp.setInvStk28Enum1(InvStk28Enum.I_TYPE_18);
                    } else if (v.getLineType().equals(UdcEnum.COM_IO_O.getValueCode())) {
                        tmp.setInvStk28Enum1(InvStk28Enum.O_TYPE_19);
                    }
                    tmp.setOpDate(LocalDateTime.now());
                    return tmp;
                }).collect(Collectors.toList()));
    }

    @Override
    @Transactional
    public void confirm(Long masId) {
        InvAsmDO invAsmDO = invAsmRepo.findById(masId).orElseThrow(new BusinessException("数据错误"));
        //根据masId查询库存组装明细
        List<InvAsmDDO> invAsmDDOS = invAsmDRepo.findByMasId(masId);
        invAsmService.updateStatusInBatch(List.of(masId), UdcEnum.INV_ASM_STATUS_CF.getValueCode());
        List<InvAsmDDO> invAsmDDOOList = invAsmDDOS.stream()
                .filter(v -> v.getLineType().equals(UdcEnum.COM_IO_O.getValueCode()))
                .collect(Collectors.toList());
        List<InvAsmDDO> invAsmDDOIList = invAsmDDOS.stream()
                .filter(v -> v.getLineType().equals(UdcEnum.COM_IO_I.getValueCode()))
                .collect(Collectors.toList());
        InvStkCommonOperateDTO operateDTO = new InvStkCommonOperateDTO();
        operateDTO.setRequestId(UUID.randomUUID().toString().trim().replaceAll("-",""));
        operateDTO.setSceneCode(InvStkSceneCodeEnum.INV_ASM_ASM002.getType());
        operateDTO.setSource("YST-INV");
        if(!CollectionUtils.isEmpty(invAsmDDOOList)){
            List<InvStkCommonOperateBodyDTO> operateBodyList1 = getOperateBodyList(invAsmDDOOList, invAsmDO);
            operateDTO.setSourceBodyList(operateBodyList1);

        }
        if(!CollectionUtils.isEmpty(invAsmDDOIList)){
            List<InvStkCommonOperateBodyDTO> operateBodyList2 = getOperateBodyList(invAsmDDOIList, invAsmDO);
            operateDTO.setTargetBodyList(operateBodyList2);
        }
        invStkOptBizService.invStkCommonOperate(operateDTO);
    }


    private List<InvStkCommonOperateBodyDTO> getOperateBodyList(List<InvAsmDDO> invAsmDDOS,InvAsmDO invAsmDO){
        ArrayList<InvStkCommonOperateBodyDTO> operateBodyDTOS = new ArrayList<>();
        invAsmDDOS.stream().forEach(invAsmDDO -> {
            InvStkCommonOperateBodyDTO operateBodyDTO = new InvStkCommonOperateBodyDTO();
            operateBodyDTO.setWhId(invAsmDO.getWhId());
            operateBodyDTO.setItemId(invAsmDDO.getItemId());
            operateBodyDTO.setDeter2(invAsmDO.getDeter2());
            operateBodyDTO.setSrcDocId(invAsmDO.getId());
            operateBodyDTO.setDocNo(invAsmDO.getDocNo());
            operateBodyDTO.setSrcDocDid(invAsmDDO.getId());
            operateBodyDTO.setSrcDocCls(UdcEnum.COM_DOC_CLS_ASM.getValueCode());
            operateBodyDTO.setLineNo(invAsmDDO.getLineNo());
            operateBodyDTO.setCreateUserId(invAsmDO.getCreateUserId());
            operateBodyDTO.setOpDate(LocalDateTime.now());
            operateBodyDTO.setUom(invAsmDDO.getUom());
            operateBodyDTO.setQty(invAsmDDO.getQty());
            operateBodyDTO.setLotNo(invAsmDDO.getLotNo());
            operateBodyDTO.setOuId(invAsmDO.getOuId());
            operateBodyDTO.setVariId(invAsmDDO.getVariId());
            operateBodyDTOS.add(operateBodyDTO);
        });
        return operateBodyDTOS;
    }


    @Override
    @Transactional
    public void check(Long masId) {
        Optional<InvAsmDO> invAsmDOOptional = invAsmRepo.findById(masId);
        if (invAsmDOOptional.isPresent()) {
            if(invAsmDOOptional.get().getProcInstId() != null ){
                throw new BusinessException(ApiCode.FAIL,"该单据已开启工作流审批");
            }
            //状态改为已审批
            invAsmDOOptional.get().setDocStatus(UdcEnum.INV_ASM_STATUS_APPED.getValueCode());
            invAsmRepo.save(invAsmDOOptional.get());
        } else {
            throw new BusinessException(ApiCode.FAIL, "修改失败，数据不存在" + masId);
        }
    }

    @Override
    @Transactional
    public void refuse(Long masId) {
        Optional<InvAsmDO> invAsmDOOptional = invAsmRepo.findById(masId);
        if (invAsmDOOptional.isPresent()) {
            if(invAsmDOOptional.get().getProcInstId() != null ){
                throw new BusinessException(ApiCode.FAIL,"该单据已开启工作流审批");
            }
            ////状态改为已拒绝
            invAsmDOOptional.get().setDocStatus(UdcEnum.INV_ASM_STATUS_RJ.getValueCode());
            invAsmRepo.save(invAsmDOOptional.get());
            // 拒绝之后需要释放库存
            releasLockQty(masId);
        } else {
            throw new BusinessException(ApiCode.FAIL, "修改失败，数据不存在" + masId);
        }

    }

    /**
     * 外部单据类型与外部单据编号处理
     *
     * @param list
     * @return
     */
    @Override
    public List<InvAsmAndAsmDDownloadRespVO> outerNoAndOuterType(List<InvAsmAndAsmDRespVO> list) {
        //将controller层处理的逻辑搬迁到service层
        List<InvAsmAndAsmDDownloadRespVO> collect = list.stream().map(i -> {
            InvAsmAndAsmDDownloadRespVO downloadVO = InvAsmAndAsmDConvert.INSTANCE.respVOTODownloadRespVO(i);
            return downloadVO;
        }).collect(Collectors.toList());
        return collect;
    }


    public void releasLockQty(Long masId) {
        Optional<InvAsmDO> invAsmDOOptional = invAsmRepo.findById(masId);
        List<InvStkCommon37InSaveVO> invStkCommon37InSaveVOS = new ArrayList<>();
        List<InvAsmDDO> invAsmDDOS = invAsmDRepo.findByMasId(masId);
        invAsmDDOS.stream().forEach(v -> {
            //检查行类型“出入”
            if (v.getLineType().equals(UdcEnum.COM_IO_O.getValueCode())) {
                InvStkCommon37InSaveVO tmp = InvCommonConvert.INSTANCE.invAsmDDOToInvStkCommon37InVO(v);
                tmp.setInvStk28Enum1(InvStk28Enum.T_TYPE_27);
                if (invAsmDOOptional.isPresent()) {
                    tmp.setDeter1(invAsmDOOptional.get().getDeter1());
                    tmp.setDeter2(invAsmDOOptional.get().getDeter2());
                    tmp.setDeter3(invAsmDOOptional.get().getDeter3());
                    tmp.setWhId(invAsmDOOptional.get().getWhId());
                    tmp.setDocNo(invAsmDOOptional.get().getDocNo());
                    tmp.setSrcDocCls(UdcEnum.COM_DOC_CLS_ASM.getValueCode());
                    tmp.setSrcDocId(v.getMasId());
                    tmp.setSrcDocDid(v.getId());
                    tmp.setOpDate(LocalDateTime.now());
                }
                invStkCommon37InSaveVOS.add(tmp);
            }
        });
        //释放锁定量 共通37
        invStkCommonService.invStkCommon37(invStkCommon37InSaveVOS);
    }

    /**
     * 需要引用品相，公司，仓库等其他模块的service接口,暂时不是本控制类调用，先注释
     */
    public List<InvAsmAndAsmDRespVO> fillupNameList(List<InvAsmAndAsmDRespVO> items) {
        List<Long> empIds = items.stream().map(InvAsmAndAsmDRespVO::getApplyEmpId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<SysUserVO> sysUserDOS = systemService.findAllEmpsByIdIn(empIds);
        List<String> deter2s = items.stream().map(InvAsmAndAsmDRespVO::getDeter2)
                .filter(Objects::nonNull)
                .distinct().collect(Collectors.toList());
        List<Long> whIds = items.stream().map(InvAsmAndAsmDRespVO::getWhId).filter(Objects::nonNull)
                .distinct().collect(Collectors.toList());
        List<Long> itemIds = items.stream().map(InvAsmAndAsmDRespVO::getItemId).collect(Collectors.toList());
        ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
        itmItemPartParam.setItemIds(itemIds);
        List<ItmItemRpcDTO> itmItemPartDTOS = itmOutService.findItemRpcDtoByParam(itmItemPartParam);
        items.forEach(a -> {
            if(!CollectionUtils.isEmpty(sysUserDOS)){
                sysUserDOS.stream().filter(emp -> emp.getId().equals(a.getApplyEmpId()))
                        .findAny().ifPresent(m -> a.setApplyEmpIdName(m.getUsername()));
            }
            if (!StringUtils.isEmpty(a.getItemId()) && !CollectionUtils.isEmpty(itmItemPartDTOS)) {
                itmItemPartDTOS.stream().filter(v -> v.getId().equals(a.getItemId())).findFirst().ifPresent(m -> {
                    a.setItemCode(m.getItemCode());
                    a.setItemName(m.getItemName());
                    a.setPackageSpec(m.getPackageSpec());
                    a.setItemSpec(m.getSpec());
                    a.setBrand(m.getBrand());
                    a.setLotFlag(m.getLotFlag());
                    a.setBrandName(m.getBrandName());
                    a.setStoreExpireDays(m.getGuaranteeDays());
                });
            }

            // 公司
            val orgOu =outouService.findOuById(a.getOuId() == null ? 0L : a.getOuId());
            if (!StringUtils.isEmpty(orgOu)) {
                a.setOuName(orgOu.getOuName());
                a.setOuCode(orgOu.getOuCode());
                a.setCurrCode(orgOu.getOuCurr());
            }
            // 仓库
            val orgWh = invWhService.findById(a.getWhId() == null ? 0L : a.getWhId());
            if (orgWh.isPresent()) {
                a.setWhCode(orgWh.get().getWhCode());
                a.setWhName(orgWh.get().getWhName());
            }
            val invStkParam = new InvBaseModel();
            invStkParam.setItemId(a.getItemId());
            invStkParam.setWhId(a.getWhId());
            invStkParam.setVariId(a.getVariId());
            invStkParam.setLotNo(a.getLotNo());
            invStkParam.setDeter1(a.getDeter1());
            invStkParam.setDeter2(a.getDeter2());
            InvStkRespVO invStk = invStkService.getInvStk(invStkParam);
            if (invStk != null) {
                a.setAvalQty(invStk.getAvalQty());
            }
            if (!StringUtils.isEmpty(a.getApplyEmpId())) {
                OrgEmpRpcDTO empRpcDTO = outouService.findEmpById(a.getApplyEmpId());
                if (empRpcDTO != null) {
                    a.setApplyEmpIdName(empRpcDTO.getEmpName());
                }
            }
        });
        //渲染公司币种
        List<String> ouCurrList = items.stream().map(InvAsmAndAsmDRespVO::getCurrCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if(!CollectionUtils.isEmpty(ouCurrList)) {
            List<SysCurrencyRespDTO> comCurrRpcDTOS = outouService.findRpcDtoByParam(ouCurrList);
            Map<String, String> stringMap = comCurrRpcDTOS.stream().collect(Collectors.toMap(SysCurrencyRespDTO::getCurrCode, SysCurrencyRespDTO::getCurrName));
            if(!CollectionUtils.isEmpty(comCurrRpcDTOS)){
                items.stream().forEach(v ->{
                    if(v.getCurrCode() != null) {
                        v.setCurrCodeName(stringMap.get(v.getCurrCode()));
                    }
                });
            }
        }
        return items;
    }
}
