package com.elitesland.yst.production.inv.application.service.impl;


import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.pur.dto.ss.PurSsDTO;
import com.elitesland.yst.production.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitesland.yst.production.pur.file.vo.ComFileUploadRespVO;
import com.elitesland.tms.api.vo.TmsOuQueryParamVO;
import com.elitesland.tms.api.vo.TmsOuRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.carr.*;
import com.elitesland.yst.production.inv.application.out.*;
import com.elitesland.yst.production.inv.application.service.InvCarrService;
import com.elitesland.yst.production.inv.domain.convert.carr.InvCarrConvert;
import com.elitesland.yst.production.inv.domain.convert.carr.InvCarrDConvert;
import com.elitesland.yst.production.inv.domain.convert.carr.InvCarrFileConvert;
import com.elitesland.yst.production.inv.domain.entity.carr.*;
import com.elitesland.yst.production.inv.infr.repo.carr.*;
import com.elitesland.yst.production.inv.utils.InvUdcEnum;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.querydsl.jpa.impl.JPAQuery;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @author feng
 * @program: yst-inv
 * @description: 承运商配送单
 * @date 2021-09-19 12:02:52
 */
@Service
@RequiredArgsConstructor
public class InvCarrServiceImpl implements InvCarrService {
    private final InvCarrRepo invCarrRepo;
    private final InvCarrDRepo invCarrDRepo;
    private final InvCarrRepoProc invCarrRepoProc;
    private final InvCarrDRepoProc invCarrDRepoProc;
    private final SystemService systemService;
    private final PurDubbleService purDubbleService;
    private final OrgOutService orgOutService;
    private final TmsOutService tmsOutService;
    private final ItmOutService itmOutService;

    private final InvCarrFileRepo invCarrFileRepo;
    private final ComFileOutService comFileOutService;
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long saveInvCarr(InvCarrSaveVO invCarrSaveVO, boolean isSubmit) {
        Long id = 0L;
        // 发货单id
        Long relateDocId = invCarrSaveVO.getRelateDocId();
        InvCarrParamVO invCarrParamVO = new InvCarrParamVO();
        invCarrParamVO.setRelateDocId(relateDocId);
        List<InvCarrRespVO> invCarrRespVOS = invCarrRepoProc.select(invCarrParamVO).fetch();
        // 判断发货单是否创建过配送单
        invCarrRespVOS = invCarrRespVOS.stream().filter(f -> !f.getId().equals(invCarrSaveVO.getId())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(invCarrRespVOS)){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION,"此发货单已创建过配送单，不能重复创建！");
        }
        InvCarrDO invCarrDO = InvCarrConvert.INSTANCE.saveVOToDO(invCarrSaveVO);
        if (StringUtils.isEmpty(invCarrSaveVO.getDocNo())){
            String docNo = systemService.sysNumberRuleGenerateCode("CARR", Collections.EMPTY_LIST);
            invCarrDO.setDocNo(docNo);
        }
        invCarrDO.setDocStatus(InvUdcEnum.INV_CARR_STATUS_DR.getValueCode());
        // 提交
        if (isSubmit){
            invCarrDO.setDocStatus(InvUdcEnum.INV_CARR_STATUS_SUBMIT.getValueCode());
        }
        id = invCarrRepo.save(invCarrDO).getId();
        // 更新发货单的承运商信息
        PurSsDTO purSsDTO=new PurSsDTO();
        purSsDTO.setCarrierContactName(invCarrDO.getCarrierContactName());
        purSsDTO.setCarrierContactTel(invCarrDO.getCarrierContactTel());
        purSsDTO.setCarrierSuppId(invCarrDO.getCarrierSuppId());
        purSsDTO.setId(relateDocId);

        purDubbleService.updateCarrierInfo(purSsDTO);
        Long finalId = id;

        List<InvCarrDSaveVO> invCarrDSaveVOS = invCarrSaveVO.getInvCarrDSaveVOS();
        if (CollectionUtils.isEmpty(invCarrDSaveVOS)){
            return id;
        }

        // 明细
        invCarrDRepo.deleteByMasId(id);
        List<InvCarrDDO> invCarrDDOS = invCarrDSaveVOS.stream().map(e -> {
            InvCarrDDO invCarrDDO = InvCarrDConvert.INSTANCE.saveVOToDO(e);
            invCarrDDO.setMasId(finalId);
            return invCarrDDO;
        }).collect(Collectors.toList());
        invCarrDRepo.saveAll(invCarrDDOS);

        // 附件
        invCarrFileRepo.deleteByMasId(id);
        List<InvCarrFileSaveVO> invCarrFileSaveVOS = invCarrSaveVO.getInvCarrFileSaveVOS();
        if (!CollectionUtils.isEmpty(invCarrFileSaveVOS)){
            List<InvCarrFileDO> invCarrFileDOS = invCarrFileSaveVOS.stream().map(file -> {
                InvCarrFileDO invCarrFileDO = InvCarrFileConvert.INSTANCE.saveVOToDO(file);
                invCarrFileDO.setMasId(finalId);
                return invCarrFileDO;
            }).collect(Collectors.toList());
            invCarrFileRepo.saveAll(invCarrFileDOS);
        }
        if (invCarrDO.getRelateDocId() != null){
            purSsDTO=new PurSsDTO();
            purSsDTO.setId(invCarrDO.getRelateDocId());
            purSsDTO.setCarriageFlag(true);

            purDubbleService.updateIsCarrige(purSsDTO);
        }

        return id;
    }

    @Override
    @SysCodeProc
    public InvCarrRespVO detail(Long id) {
        if (id == null){
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION,"id不能为空！");
        }
        Optional<InvCarrDO> carrDOOptional = invCarrRepo.findById(id);
        if (carrDOOptional.isEmpty()){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION,"单据不存在！");
        }
        InvCarrDO invCarrDO = carrDOOptional.get();
        InvCarrRespVO invCarrRespVO = InvCarrConvert.INSTANCE.doToRespVO(invCarrDO);
        convertCarrInfo(Arrays.asList(invCarrRespVO));
        JPAQuery<InvCarrDRespVO> jpaQuery = invCarrDRepoProc.select(null).where(QInvCarrDDO.invCarrDDO.masId.eq(id));
        List<InvCarrDRespVO> invCarrDRespVOS = jpaQuery.fetch();
        convertCarrDInfo(invCarrDRespVOS);
        invCarrRespVO.setInvCarrDRespVOS(invCarrDRespVOS);
        // 附件
        List<InvCarrFileDO> invCarrFileDOS = invCarrFileRepo.findByMasId(invCarrDO.getId());
        if (CollectionUtils.isEmpty(invCarrFileDOS)){
            return invCarrRespVO;
        }
        List<InvCarrFileRespVO> invCarrFileRespVOS = invCarrFileDOS.stream().map(file -> {
            InvCarrFileRespVO respVO = InvCarrFileConvert.INSTANCE.doToRespVO(file);
            if (!StringUtils.isEmpty(respVO.getFileCode())){
                List<String> fileCodeList = Arrays.asList(respVO.getFileCode().split(","));
                List<ComFileUploadRespVO> fileUploadRespVOS = comFileOutService.findByFileCodeIn(fileCodeList).stream()
                        .map(t -> {
                            ComFileUploadRespVO respVO1 = new ComFileUploadRespVO();
                            respVO1.setId(t.getId());
                            respVO1.setFileCode(t.getFileCode());
                            respVO1.setModifyTime(t.getModifyTime());
                            respVO1.setOriginalName(t.getOriginalName());
                            respVO1.setUploadName(t.getUploadName());

                            return respVO1;
                        })
                        .collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(fileUploadRespVOS)){
                    respVO.setFileUploadRespVOS(fileUploadRespVOS);
                }
            }
            return  respVO;
        }).collect(Collectors.toList());


        invCarrRespVO.setInvCarrFileRespVOS(invCarrFileRespVOS);
        return invCarrRespVO;
    }

    private void convertCarrDInfo(List<InvCarrDRespVO> invCarrDRespVOS) {
        List<Long> itemIdList = invCarrDRespVOS.stream().filter(f -> f.getItemId() != null).map(InvCarrDRespVO::getItemId).collect(Collectors.toList());
        ItmItemRpcDtoParam itmItemRpcDtoParam = new ItmItemRpcDtoParam();
        itmItemRpcDtoParam.setItemIds(itemIdList);
        List<ItmItemRpcDTO> itmItemRpcDTOS = itmOutService.findItemRpcDtoByParam(itmItemRpcDtoParam);
        for (InvCarrDRespVO respVO : invCarrDRespVOS) {
            if (!CollectionUtils.isEmpty(itmItemRpcDTOS)){
                itmItemRpcDTOS.stream().filter(f -> f.getId().equals(respVO.getItemId())).findFirst().ifPresent(itm -> {
                    respVO.setItemCode(itm.getItemCode());
                    respVO.setItemName(itm.getItemName());
                    respVO.setItemSpec(itm.getSpec());
                });
            }
        }



    }

    @Override
    @SysCodeProc
    public PagingVO<InvCarrRespVO> list(InvCarrParamVO invCarrParamVO) {
        PagingVO<InvCarrRespVO> pagingVO = new PagingVO<>();
        JPAQuery<InvCarrRespVO> jpaQuery = invCarrRepoProc.select(invCarrParamVO);
        long count = jpaQuery.fetchCount();
        invCarrRepoProc.openOrderAndLimit(jpaQuery,invCarrParamVO, QInvCarrDO.invCarrDO);
        List<InvCarrRespVO> invCarrRespVOS = jpaQuery.fetch();
        convertCarrInfo(invCarrRespVOS);
        pagingVO.setTotal(count);
        pagingVO.setRecords(invCarrRespVOS);
        return pagingVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteInvCarr(Long id) {

        Optional<InvCarrDO> invCarrDOOptional = invCarrRepo.findById(id);
        if (invCarrDOOptional.isEmpty()){
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION,"单据不存在！");
        }
        InvCarrDO invCarrDO = invCarrDOOptional.get();
        if (invCarrDO.getRelateDocId() != null){
            // 配送单删除后 是否创建配送单标记改为否
            PurSsDTO purSsDTO=new PurSsDTO();
            purSsDTO.setId(invCarrDO.getRelateDocId());
            purSsDTO.setCarriageFlag(false);
            purDubbleService.updateIsCarrige(purSsDTO);
        }
        invCarrRepo.deleteById(id);
        invCarrDRepo.deleteByMasId(id);

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void commitInvCarr(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)){
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION,"参数不能为空！");
        }
        invCarrRepoProc.updateInvCarrStatus(ids,InvUdcEnum.INV_CARR_STATUS_SUBMIT.getValueCode());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateInvCarrStatus(List<Long> ids, String docStatus) {
        invCarrRepoProc.updateInvCarrStatus(ids,docStatus);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateInvCarrStatusByRelateDocId(Long relateDocId, String docStatus) {
        invCarrRepoProc.updateInvCarrStatusByRelateDocId(relateDocId,docStatus);
    }

    private void convertCarrInfo(List<InvCarrRespVO> invCarrRespVOS) {
        List<TmsOuRespVO> tmsOuDTOS = null;
        List<Long> carrierSuppIdList = invCarrRespVOS.stream().filter(f -> f.getCarrierSuppId() != null).map(InvCarrRespVO::getCarrierSuppId).collect(Collectors.toList());
        List<Long> suppIdList = invCarrRespVOS.stream().filter(f -> f.getSuppId() != null).map(InvCarrRespVO::getSuppId).distinct().collect(Collectors.toList());
        List<Long> ouIdList = invCarrRespVOS.stream().filter(f -> f.getOuId() != null).map(InvCarrRespVO::getOuId).distinct().collect(Collectors.toList());
        List<String> logisticsOuCodeList = invCarrRespVOS.stream().filter(f -> !StringUtils.isEmpty(f.getLogisticsOuCode())).map(InvCarrRespVO::getLogisticsOuCode).collect(Collectors.toList());

        // 供应商（发货单位）
        List<PurSuppBaseRpcDTO> suppBaseList = purDubbleService.findSuppByIdBatch(suppIdList);
        // 公司（收货单位）
        List<OrgOuRpcDTO> orgOuRpcDTOS = orgOutService.findOuByIds(ouIdList);
        // 承运商(供应商类型为物流供应商)

        List<PurSuppBaseRpcDTO> carrierSuppList = purDubbleService.findSuppByIdBatch(carrierSuppIdList);
        // 物流公司
        if (!CollectionUtils.isEmpty(logisticsOuCodeList)){
            TmsOuQueryParamVO tmsOuQueryParamVO=new TmsOuQueryParamVO();
            tmsOuQueryParamVO.setLogisticsOuCodes(logisticsOuCodeList);
            tmsOuDTOS = tmsOutService.findTmsOuList(tmsOuQueryParamVO);
        }

        for (InvCarrRespVO respVO : invCarrRespVOS) {
            if (!CollectionUtils.isEmpty(suppBaseList)){
                suppBaseList.stream().filter(f -> f.getId().equals(respVO.getSuppId())).findFirst().ifPresent(supp ->{
                    respVO.setSuppCode(supp.getSuppCode());
                    respVO.setSuppName(supp.getSuppName());
                });
            }
            if (!CollectionUtils.isEmpty(orgOuRpcDTOS)){
                orgOuRpcDTOS.stream().filter(f -> f.getId().equals(respVO.getOuId())).findFirst().ifPresent(ou ->{
                    respVO.setOuCode(ou.getOuCode());
                    respVO.setOuName(ou.getOuName());
                });
            }
            if (!CollectionUtils.isEmpty(carrierSuppList)){
                carrierSuppList.stream().filter(f -> f.getId().equals(respVO.getCarrierSuppId())).findFirst().ifPresent(carr -> {
                    respVO.setCarrierSuppCode(carr.getSuppCode());
                    respVO.setCarrierSuppName(carr.getSuppName());
                });
            }
            if (!CollectionUtils.isEmpty(tmsOuDTOS)){
                tmsOuDTOS.stream().filter(f -> !StringUtils.isEmpty(f.getLogisticsOuCode()) && f.getLogisticsOuCode().equals(respVO.getLogisticsOuCode())).findFirst().ifPresent(tms -> {
                    respVO.setLogisticsOuName(tms.getLogisticsOuName());
                });
            }

        }

    }


}
