package com.elitesland.yst.production.inv.application.web.controller;

import com.elitesland.yst.production.inv.application.facade.vo.InvAjAndInvAjDDownloadRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvAjDQueryAllParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvAjDSaveVO;
import com.elitesland.yst.production.inv.application.service.InvAjDService;
import com.elitesland.yst.production.inv.utils.ExcelWriteUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * @author lvqf
 * @date 2021-02-1 11:36
 * Desc:
 */
@RestController
@RequestMapping("/invajd")
@Api(value = "库存调整明细", tags = {"库存调整明细"})
@AllArgsConstructor
public class InvAjDController {

    public final InvAjDService invAjDService;

    /**
     * 分页查询
     *
     * @param param 查询调整单页面list
     * @return 多条数据
     */
    @PostMapping("/searchwithajid")
    @ApiOperation("库存调整单+明细分页查询")
    public ApiResult<?> searchWithAj(@RequestBody InvAjDQueryAllParamVO param) {
        val ret = invAjDService.searchAll(param);
        return ApiResult.ok(ret);
    }

    /**
     * 分页查询
     *
     * @param param 查询调整单页面list
     * @return 多条数据
     */
    @PostMapping("/downloadWithAj")
    @ApiOperation("库存调整单+明细分页查询导出")
    public void downloadWithAj(HttpServletResponse response, @RequestBody InvAjDQueryAllParamVO param) throws IOException {
        List<InvAjAndInvAjDDownloadRespVO> invAjAndInvAjDDownloadRespVOS = invAjDService.findInvAjAndInvAjDDownloadVOs(param);
        ExcelWriteUtil.excelWrite(response, invAjAndInvAjDDownloadRespVOS, InvAjAndInvAjDDownloadRespVO.class, "库存调整单", "库存调整单");
    }

    /**
     * 批量更新数据
     *
     * @param list 对象集合
     * @return
     */
    @PutMapping("/updateInBatch")
    @ApiOperation("库存调整单明细批量更新(实物销毁登记保存)")
    public ApiResult<Object> updateInBatch(@RequestBody List<InvAjDSaveVO> list) {
        return ApiResult.ok(invAjDService.updateInvAjDList(list));
    }

//    /**
//     * 功能描述 库存调整导入
//     *
//     * @param paramVO
//     * @return com.elitesland.yst.common.base.ApiResult<java.util.List < com.elitesland.yst.inv.vo.resp.InvAjDRespVO>>
//     * @author Brian.lai
//     * @date 2021/8/9
//     */
//    @PostMapping("/import")
//    @ApiOperation("导入库存调整信息")
//    public ApiResult<List<InvAjDRespVO>> importAjD(InvAjImportParamVO paramVO) {
//        DchExcelEntityDataListener<InvAjDExcelImport> dchExcelEntityDataListener = new DchExcelEntityDataListener<>();
//        try {
//            read(paramVO.getFile().getInputStream(), InvAjDExcelImport.class, dchExcelEntityDataListener).doReadAll();
//        } catch (Exception e) {
//            throw new BusinessException(ApiCode.FAIL, "导入数据如时间，数字格式异常,请检查");
//        }
//        List<InvAjDExcelImport> importParams = dchExcelEntityDataListener.getDataList();
//        List<InvAjDExcelImport> ajDExcelImports = importParams.stream().peek(v -> v.setPCode(v.getPartCode())).peek(v2 -> v2.setPType(v2.getPartType())).collect(Collectors.toList());
//        return ApiResult.ok(invAjDService.importAjD(ajDExcelImports, paramVO.getWhId(), paramVO.getDeter2(), paramVO.getDocType()));
//    }


}
