package com.elitesland.yst.production.inv.application.web.controller;

import com.elitesland.yst.production.inv.application.facade.vo.InvAsmAllQueryParam;
import com.elitesland.yst.production.inv.application.facade.vo.InvAsmAndAsmDDownloadRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvAsmAndAsmDRespVO;
import com.elitesland.yst.production.inv.application.service.InvAsmDService;
import com.elitesland.yst.production.inv.utils.ExcelWriteUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * @author lu.wang
 * @date 2020-08-12 08:49
 * Desc: 库内组装单
 */
@RestController
@RequestMapping("/inv/invasmd")
@Api(value = "库内组装单明细", tags = {"库内组装单明细"})
@AllArgsConstructor
public class InvAsmDController {
    private final InvAsmDService invAsmDService;

    /**
     * 分页查询-组装单信息
     *
     * @param param 分类查询、分页和排序对象
     * @return 多条数据
     */
    @PostMapping("/search")
    @ApiOperation("分页查询-组装单信息")
    public ApiResult<?> search(@RequestBody InvAsmAllQueryParam param) {
        val ret = invAsmDService.search(param);
        return ApiResult.ok(ret);
    }

    /**
     * 导出
     *
     * @param param 分类查询、分页和排序对象
     * @return 多条数据
     */
    @PostMapping("/downloadAsmAll")
    @ApiOperation("库存组装")
    public void downloadAsmAll(HttpServletResponse response, @RequestBody InvAsmAllQueryParam param) throws IOException {
        param.setSize(20000);
        //数据查询
        List<InvAsmAndAsmDRespVO> list = invAsmDService.search(param).getRecords();
        //外部单据类型与外部单据编号处理
        List<InvAsmAndAsmDDownloadRespVO> collect = invAsmDService.outerNoAndOuterType(list);
        ExcelWriteUtil.excelWrite(response,collect, InvAsmAndAsmDDownloadRespVO.class,"库存组装单","库存组装单");
    }

    /**
     * 组装单明细
     *
     * @param param 查询条件
     * @param id    masId
     * @return 多条数据
     */
    @PostMapping("/all/{id}")
    @ApiOperation("组装单全部明细")
    public ApiResult<?> findAll(@PathVariable Long id, @RequestBody InvAsmAllQueryParam param) {
        param.setMasId(id);
        val ret = invAsmDService.findAll(param);
        return ApiResult.ok(ret);
    }

    /**
     * 分页查询-组装单明细信息
     * 20200911 前端可编辑表格使用
     *
     * @param param 查询条件
     * @param id    masId
     */
    @PostMapping("/search/{id}")
    @ApiOperation("组装单明细查询-分页")
    public ApiResult<?> searchD(@PathVariable Long id, @RequestBody InvAsmAllQueryParam param) {
        param.setMasId(id);
        val ret = invAsmDService.search(param);
        return ApiResult.ok(ret);
    }

    /**
     * 批量删除明细行
     *
     * @param ids 明细行id
     * @return 记录数量
     */
    @DeleteMapping("/remove")
    @ApiOperation("批量删除明细行")
    public ApiResult<?> removeInBatch(@RequestBody List<Long> ids) {
        val ret = invAsmDService.removeInBatch(ids);
        return ApiResult.ok(ret);
    }

    @PostMapping("/confirm/{id}")
    @ApiOperation("提交确认")
    public ApiResult<?> confirm(@PathVariable Long id) {
        invAsmDService.confirm(id);
        return ApiResult.ok();
    }

    @PostMapping("/check/{id}")
    @ApiOperation("审核通过")
    public ApiResult<?> check(@PathVariable Long id) {
        invAsmDService.check(id);
        return ApiResult.ok();
    }

    @PostMapping("/refuse/{id}")
    @ApiOperation("审核拒绝")
    public ApiResult<?> refuse(@PathVariable Long id) {
        invAsmDService.refuse(id);
        return ApiResult.ok();
    }
}
