package com.elitesland.yst.production.inv.application.web.controller.workflow;


import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.service.*;
import com.elitesland.yst.production.inv.enums.ProcDefKey;
import com.elitesland.yst.production.inv.domain.service.InvAsmDomainService;
import com.elitesland.yst.production.inv.domain.service.InvTrnDomainService;
import com.elitesland.yst.production.inv.infr.dto.InvAsmDTO;
import com.elitesland.yst.production.inv.infr.dto.InvTrnDTO;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

/**
 * 工作流回调
 *
 * @author tina.he
 * @date 2021/08/02
 */
@Slf4j
@AllArgsConstructor
public class InvWorkflowCallBack {
    private final InvAjProcessService invAjProcessService;
    private final InvAjService invAjService;
    private final InvTrnProcessService invTrnProcessService;
    private final InvTrnDomainService invTrnService;
    private final InvAsmProcessService invAsmProcessService;
    //    private final InvAsmService invAsmService;
    private final OrgOutService orgOutService;
    private final InvCkProcessService invCkProcessService;
    private final InvAsmDomainService invAsmDomainService;

    /**
     * 动态指定任务负责人
     *
     * @param procDefKey  流程定义KEY
     * @param taskKey     任务KEY
     * @param businessKey 业务ID（一般是id，也可以是自定义的，只要能根据businessKey找到你的业务对象,如id+code）
     * @return 任务处理人USER_ID集合
     */

    public ArrayList<String> taskAssignee(String tenantId,String procDefKey, String taskKey, String businessKey, String customParams) {
        log.info("动态指定任务负责人: 流程定义KEY:{},任务key:{},业务key:{},自定义参数:{}", procDefKey, taskKey, businessKey, customParams);
        if (Objects.equals(procDefKey, ProcDefKey.INV_TRN.name())) {
            //库存转移工作流回调
            Long trnOuId = this.getTrnOuId(businessKey, customParams);
            ArrayList<String> userIds = invTrnProcessService.taskAssignee(trnOuId, customParams);
            return userIds;
        } else if (Objects.equals(procDefKey, ProcDefKey.INV_ADJST.name())) {
            //库存调整动态指定任务人
            ArrayList<String> userIds = invAjProcessService.taskAssignee(null, customParams);
            return userIds;
        }
        if (Objects.equals(procDefKey, ProcDefKey.INV_ASM.name())) {
            //库存组装工作流回调
            Long asmOuId = this.getAsmOuId(businessKey, customParams);
            ArrayList<String> userIds = invAsmProcessService.taskAssignee(asmOuId, customParams);
            return userIds;
        } else if (Objects.equals(procDefKey, ProcDefKey.INV_STOCK_CHECK.name())) {
            ArrayList<String> userIds = invCkProcessService.taskAssignee(null, customParams);
            return userIds;
        }
        return null;
    }

    /**
     * 任务创建后回调
     *
     * @param procDefKey    流程定义KEY
     * @param taskKey       任务KEY
     * @param businessKey   业务ID（一般是id，也可以是自定义的，只要能根据businessKey找到你的业务对象,如id+code）
     * @param taskAssignees 任务处理人
     */
    public void taskCreated(String tenantId,String procDefKey, String taskKey, String businessKey, Set<String> taskAssignees) {
        log.info("任务创建后回调: 流程定义KEY:{},任务key:{},业务key:{},处理人:{}", procDefKey, taskKey, businessKey, taskAssignees);

    }

    /**
     * 任务完成后回调
     *
     * @param procDefKey  流程定义KEY
     * @param taskKey     任务KEY
     * @param businessKey 业务ID（一般是id，也可以是自定义的，只要能根据businessKey找到你的业务对象,如id+code）
     * @param taskHandler 处理人userId
     */

    public void taskCompleted(String tenantId,String procDefKey, String taskKey, String businessKey, String taskHandler) {
        log.info("任务完成后回调: 流程定义KEY:{},任务key:{},业务key:{}，任务处理人{}", procDefKey, taskKey, businessKey, taskHandler);

    }

    /**
     * 流程状态变化回调
     *
     * @param procDefKey     流程定义KEY
     * @param procInstStatus 状态
     * @param businessKey    业务ID（一般是id，也可以是自定义的，只要能根据businessKey找到你的业务对象,如id+code）
     *                       //     * @param commentInfo    审批信息
     */

    public void processStatusChange(String tenantId,String procDefKey, ProcInstStatus procInstStatus, String businessKey, CommentInfo commentInfo) {
        log.info("流程回调 procDefKey:" + procDefKey + " ,procInstStatus:" + procInstStatus + ",businessKey:" + businessKey);

        if (procDefKey.equals(ProcDefKey.INV_ADJST.name())) {
            //总部公司盘点差异调整
            invAjProcessService.processStatusChange(getId(businessKey), procInstStatus);
        } else if (procDefKey.equals(ProcDefKey.INV_TRN.name())) {
            //总部公司仓内库存转移
            invTrnProcessService.processStatusChange(getId(businessKey), procInstStatus);
        } else if (procDefKey.equals(ProcDefKey.INV_ASM.name())) {
            //库存组装申请流程,产品化时新增最简工作流
            invAsmProcessService.processStatusChange(getId(businessKey), procInstStatus);
        } else if (procDefKey.equals(ProcDefKey.INV_STOCK_CHECK.name())) {
            //产品化时新增最简工作流
            invCkProcessService.processStatusChange(getId(businessKey), procInstStatus);
        }
    }


    //从businessKey中提取id
    private Long getId(String businessKey) {
        return Long.valueOf(businessKey);
    }


    private Long getTrnOuId(String businessKey, String customParams) {
        Optional<InvTrnDTO> invTrnDTO = invTrnService.findIdOne(getId(businessKey));
        Long ouId = null;
        if (invTrnDTO.isPresent()) {
            InvTrnDTO invTrnRespVO = invTrnDTO.get();
            ouId = invTrnRespVO.getOuId();
        }
        return ouId;
    }


    private Long getAsmOuId(String businessKey, String customParams) {
        Optional<InvAsmDTO> invAsmDTOOptional = invAsmDomainService.findIdOne(getId(businessKey));
        Long ouId = null;
        if (invAsmDTOOptional.isPresent()) {
            InvAsmDTO invAsmDTO = invAsmDTOOptional.get();
            ouId = invAsmDTO.getOuId();
        }
        return ouId;
    }

    private Long getAjOuId(String businessKey, String customParams) {
//        Optional<InvAjRespVO> invAjRespVO = invAjService.findIdOne(getId(businessKey));
        Long ouId = null;
//        if (!invAjRespVO.isEmpty()) {
//            InvAjRespVO invAjRespVO1 = invAjRespVO.get();
//            ouId = invAjRespVO1.getOuId();
//        }
        return ouId;
    }

    private Long getIoOuId(String businessKey, String customParams) {
//        Optional<InvAjRespVO> invAjRespVO = invAjService.findIdOne(getId(businessKey));
        Long ouId = null;
//        if (!invAjRespVO.isEmpty()) {
//            InvAjRespVO invAjRespVO1 = invAjRespVO.get();
//            ouId = invAjRespVO1.getOuId();
//        }
        return ouId;
    }
}
