package com.elitesland.yst.production.inv.domain.entity;

/**
 * INV_AJ
 * InvAjDO
 * 库存调整
 * @author lich.chen
 * @date   2020/07/29 13:41:44


 */


import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 库存调整
 */

@Data
@ApiModel(value = "INV_AJ", description = "库存调整")
public class InvAj extends BaseModel implements Serializable {
    private static final long serialVersionUID = 8230656183776345012L;
    @ApiModelProperty("公司ID")
    Long ouId;

    @ApiModelProperty("公司编码")
    String ouCode;

    @ApiModelProperty("BUID")
    Long buId;

    @ApiModelProperty("单据编号")
    String docNo;

    @ApiModelProperty("调整类型 [UDC]INV:AJ_TYPE")
    String docType;

    @ApiModelProperty("调整单状态 [UDC]INV:AJ_STATUS")
    String docStatus;

    @ApiModelProperty("原因码 [UDC]COM:REASON_CODE")
    String reasonCode;

    @ApiModelProperty("流程实例ID")
    String apprProcInstId;

    @ApiModelProperty("提审人ID")
    Long apprCreateUserId;

    @ApiModelProperty("审批状态 [UDC]COM:APPR_STATUS")
    String apprStatus;

    @ApiModelProperty("审批时间")
    @Column()
    @Comment("审批时间")
    LocalDateTime apprTime;

    @ApiModelProperty("审批人ID")
    Long apprUserId;

    @ApiModelProperty("审批意见")
    String apprComment;

    @ApiModelProperty("申请人员工ID")
    Long applyEmpId;

    @ApiModelProperty("申请日期")
    @Column()
    @Comment("申请日期")
    LocalDateTime applyDate;

    @ApiModelProperty("申请描述")
    String applyDesc;

    @ApiModelProperty("交易日期 实际出入库日期")
    LocalDateTime ioDate;

    @ApiModelProperty("仓库ID")
    Long whId;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    String deter1;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    String deter2;

    @ApiModelProperty("客户标识")
    String deter3;

    @ApiModelProperty("限定4")
    String deter4;

    @ApiModelProperty("限定5")
    String deter5;

    @ApiModelProperty("限定6")
    String deter6;

    @ApiModelProperty("限定7")
    String deter7;

    @ApiModelProperty("限定8")
    String deter8;

    @ApiModelProperty("总数量")
    BigDecimal qty;

    @ApiModelProperty("数量单位")
    String qtyUom;

    @ApiModelProperty("税额")
    BigDecimal taxAmt;

    @ApiModelProperty("含税金额")
    BigDecimal amt;

    @ApiModelProperty("不含税金额")
    BigDecimal netAmt;

    @ApiModelProperty("记账币种")
    String homeCurr;

    @ApiModelProperty("交易币种")
    String currCode;

    @ApiModelProperty("汇率")
    Double currRate;

    @ApiModelProperty("外币不含税金额")
    BigDecimal currNetAmt;

    @ApiModelProperty("外币含税金额")
    BigDecimal currAmt;

    @ApiModelProperty("成本金额")
    BigDecimal costAmt;

    @ApiModelProperty("关联单据类别 [UDC]如RMA单，盘点单。COM:DOC_CLS")
    String relateDocCls;

    @ApiModelProperty("关联单据类型")
    String relateDocType;

    @ApiModelProperty("关联单据ID")
    Long relateDocId;

    @ApiModelProperty("关联单据编号")
    String relateDocNo;

    @ApiModelProperty("关联ID")
    Long relateId;

    @ApiModelProperty("关联编号 外部单据号")
    String relateNo;

    @ApiModelProperty("关联2ID")
    Long relate2Id;

    @ApiModelProperty("关联2编号")
    String relate2No;

    @ApiModelProperty("是否走接口")
    Integer intfFlag;

    @ApiModelProperty("是否外部单据同步")
    Integer sourceFlag;

    @ApiModelProperty("ES1")
    String es1;

    @ApiModelProperty("ES2")
    String es2;

    @ApiModelProperty("ES3")
    String es3;

    @ApiModelProperty("ES4")
    String es4;

    @ApiModelProperty("ES5")
    String es5;

    @ApiModelProperty("文件服务器编码")
    String fileCode;

    /**
     * 工作流字段
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty(value = "提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty(value = "审批通过时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("领域编码")
    String region;

    @ApiModelProperty("单据类别")
    private String docCls;

    @ApiModelProperty("客户编号")
    private String limit1;

    @ApiModelProperty("库存类型")
    private String limit2;

    @ApiModelProperty("limit3")
    private String limit3;


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvAj)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InvAj entity = (InvAj) o;
        return getId().equals(entity.getId());
    }
    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}


