package com.elitesland.yst.production.inv.domain.entity.lot;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;


/**
 * <p>
 * 功能说明:批次主档
 * </p >
 *
 * @author yangzhibin
 * @date 2020/7/27
 */
@Entity
@Table(name = "inv_lot")
@org.hibernate.annotations.Table(appliesTo = "inv_lot", comment = "批次主档")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "inv_lot", description = "批次主档")
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class InvLotDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 5254895084837352635L;

    @ApiModelProperty("公司ID")
    @Column(name = "ou_id", columnDefinition = "bigint(20)  comment '公司ID'")
    Long ouId;

    @ApiModelProperty("BUID")
    @Column(name = "bu_id", columnDefinition = "bigint(20)  comment 'BUID'")
    Long buId;

    @ApiModelProperty("品项ID")
    @Column(name = "item_id", columnDefinition = "bigint(20)  comment '品项ID'")
    Long itemId;

    @ApiModelProperty("异构ID")
    @Column(name = "vari_id", columnDefinition = "bigint default 0  comment '异构ID'")
    Long variId;

    @ApiModelProperty("品项编号")
    @Column(name = "item_code", columnDefinition = "varchar(40)  comment '品项编号'")
    String itemCode;

    @ApiModelProperty("批次号")
    @Column(name = "lot_no", columnDefinition = "varchar(40)  comment '批次号'")
    String lotNo;

    @ApiModelProperty("批次说明")
    @Column(name = "lot_desc", columnDefinition = "varchar(40)  comment '批次说明'")
    String lotDesc;

    @ApiModelProperty("批次状态 允许的出入库类型,0,可以出，1不可以出")
    @Column(name = "lot_status", columnDefinition = "varchar(40)  comment '批次状态 允许的出入库类型，0,可以出，1不可以出'")
    String lotStatus;

    @ApiModelProperty("批次状态2 备用")
    @Column(name = "lot_status2", columnDefinition = "varchar(40)  comment '批次状态2 备用'")
    String lotStatus2;

    @ApiModelProperty("批次状态3 备用")
    @Column(name = "lot_status3", columnDefinition = "varchar(40)  comment '批次状态3 备用'")
    String lotStatus3;

    @ApiModelProperty("质量状态")
    @Column(name = "qc_status", columnDefinition = "varchar(40)  comment '质量状态'")
    String qcStatus;

    @ApiModelProperty("卫检状态")
    @Column(name = "sin_status", columnDefinition = "varchar(40)  comment '卫检状态'")
    String sinStatus;

    @ApiModelProperty("锁定原因")
    @Column(name = "lock_reason", columnDefinition = "varchar(40)  comment '锁定原因'")
    String lockReason;

    @ApiModelProperty("已卫检数量")
    @Column(name = "sin_qty", columnDefinition = "NUMERIC(20,8)   comment '已卫检数量'")
    BigDecimal sinQty;

    @ApiModelProperty("保质期天数")
    @Column(name = "expire_days", columnDefinition = "int(18)  comment '保质期天数'")
    Integer expireDays;

    @ApiModelProperty("生产日期")
    @Column()
    @Comment("生产日期")
    LocalDateTime manuDate;

    @ApiModelProperty("生产批次")
    @Column(name = "menu_lot_no", columnDefinition = "varchar(40)  comment '生产批次'")
    String menuLotNo;

    @ApiModelProperty("整批号")
    @Column(name = "batch_no", columnDefinition = "varchar(40)  comment '整批号'")
    String batchNo;

    @ApiModelProperty("失效日期")
    @Column()
    @Comment("失效日期")
    LocalDateTime expireDate;

    @ApiModelProperty("剩余效期天数 每天自动计算")
    @Column(name = "until_expire_days", columnDefinition = "int(18)  comment '剩余效期天数 每天自动计算'")
    Integer untilExpireDays;

    @ApiModelProperty("新鲜度 每天自动计算。[UDC]COM:FRESS_TYPE")
    @Column(name = "fress_type", columnDefinition = "varchar(40)  comment '新鲜度 每天自动计算。[UDC]COM:FRESS_TYPE'")
    String fressType;

    @ApiModelProperty("首次入库日期")
    @Column()
    @Comment("首次入库日期")
    LocalDateTime firstInDate;

    @ApiModelProperty("最后出库日期")
    @Column()
    @Comment("最后出库日期")
    LocalDateTime lastOutDate;

    @ApiModelProperty("销售截止日期")
    @Column()
    @Comment("销售截止日期")
    LocalDateTime maxSaleDate;

    @ApiModelProperty("原产国")
    @Column(name = "menu_country", columnDefinition = "varchar(40)  comment '原产国'")
    String menuCountry;

    @ApiModelProperty("产地描述")
    @Column(name = "menu_desc", columnDefinition = "varchar(40)  comment '产地描述'")
    String menuDesc;

    @ApiModelProperty("产地证明编号")
    @Column(name = "menu_doc_no", columnDefinition = "varchar(40)  comment '产地证明编号'")
    String menuDocNo;

    @ApiModelProperty("制造商ID")
    @Column(name = "manuer_id", columnDefinition = "bigint(20)  comment '制造商ID'")
    Long manuerId;

    @ApiModelProperty("制造商编号")
    @Column(name = "manuer_code", columnDefinition = "varchar(40)  comment '制造商编号'")
    String manuerCode;

    @ApiModelProperty("制造商名称")
    @Column(name = "manuer_name", columnDefinition = "varchar(40)  comment '制造商名称'")
    String manuerName;

    @ApiModelProperty("供应商ID")
    @Column(name = "supp_id", columnDefinition = "bigint(20)  comment '供应商ID'")
    Long suppId;

    @ApiModelProperty("默认卫检单ID")
    @Column(name = "sin_id", columnDefinition = "bigint(20)  comment '默认卫检单ID'")
    Long sinId;

    @ApiModelProperty("默认卫检单编号")
    @Column(name = "sin_no", columnDefinition = "varchar(40)  comment '默认卫检单编号'")
    String sinNo;

    @ApiModelProperty("卫检日期")
    @Column()
    @Comment("卫检日期")
    LocalDateTime sinDate;

    @ApiModelProperty("货主类型 供应商/客户，DCH不用")
    @Column(name = "owner_type", columnDefinition = "varchar(40)  comment '货主类型 供应商/客户，DCH不用'")
    String ownerType;

    @ApiModelProperty("货主ID DCH不用")
    @Column(name = "owner_id", columnDefinition = "bigint(20)  comment '货主ID DCH不用'")
    Long ownerId;

    @ApiModelProperty("货主编码 DCH不用")
    @Column(name = "owner_code", columnDefinition = "varchar(40)  comment '货主编码 DCH不用'")
    String ownerCode;

    @ApiModelProperty("来源单据类别")
    @Column(name = "src_doc_cls", columnDefinition = "varchar(40)  comment '来源单据类别'")
    String srcDocCls;

    @ApiModelProperty("来源单据ID")
    @Column(name = "src_doc_id", columnDefinition = "bigint(20)  comment '来源单据ID'")
    Long srcDocId;

    @ApiModelProperty("来源单据编号")
    @Column(name = "src_doc_no", columnDefinition = "varchar(40)  comment '来源单据编号'")
    String srcDocNo;

    @ApiModelProperty("来源单据明细ID")
    @Column(name = "src_doc_did", columnDefinition = "bigint(20)  comment '来源单据明细ID'")
    Long srcDocDid;

    @ApiModelProperty("采购单ID")
    @Column(name = "po_id", columnDefinition = "bigint(20)  comment '采购单ID'")
    Long poId;

    @ApiModelProperty("采购单号")
    @Column(name = "po_no", columnDefinition = "varchar(40)  comment '采购单号'")
    String poNo;

    @ApiModelProperty("采购单类型")
    @Column(name = "po_type", columnDefinition = "varchar(40)  comment '采购单类型'")
    String poType;

    @ApiModelProperty("采购单明细ID")
    @Column(name = "po_did", columnDefinition = "bigint(20)  comment '采购单明细ID'")
    Long poDId;

    @ApiModelProperty("ES1")
    @Column(name = "es1", columnDefinition = "varchar(40)  comment 'ES1'")
    String es1;

    @ApiModelProperty("ES2")
    @Column(name = "es2", columnDefinition = "varchar(40)  comment 'ES2'")
    String es2;

    @ApiModelProperty("ES3")
    @Column(name = "es3", columnDefinition = "varchar(40)  comment 'ES3'")
    String es3;

    @ApiModelProperty("ES4")
    @Column(name = "es4", columnDefinition = "varchar(40)  comment 'ES4'")
    String es4;

    @ApiModelProperty("ES5")
    @Column(name = "es5", columnDefinition = "varchar(40)  comment 'ES5'")
    String es5;

    @ApiModelProperty("DATE1")
    @Column(name = "date1", columnDefinition = "datetime   comment 'DATE1'")
    LocalDateTime date1;

    @ApiModelProperty("DATE2")
    @Column(name = "date2", columnDefinition = "datetime   comment 'DATE2'")
    LocalDateTime date2;

    @ApiModelProperty("DATE3")
    @Column(name = "date3", columnDefinition = "datetime   comment 'DATE3'")
    LocalDateTime date3;

    @ApiModelProperty("DATE4")
    @Column(name = "date4", columnDefinition = "datetime   comment 'DATE4'")
    LocalDateTime date4;

    @ApiModelProperty("DATE5")
    @Column(name = "date5", columnDefinition = "datetime   comment 'DATE5'")
    LocalDateTime date5;


/*
    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvLotDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InvLotDO entity = (InvLotDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }*/
}
