package com.elitesland.yst.production.inv.domain.entity.whAreaSetting;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @ClassName invWhAreaSettingDO
 * @Description 功能区配置
 * @Auther Brian.lai
 * @Date 2021/7/6 13:09
 * @Version 1.0
 **/
@Entity
@Table(name = "inv_wh_area_setting")
@org.hibernate.annotations.Table(appliesTo = "inv_wh_area_setting", comment = "功能区配置")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "INV_WH_AREA_SETTING", description = "功能区配置")
public class InvWhAreaSettingDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -2642948606777259112L;

    @ApiModelProperty("功能区编码")
    @Column(name = "deter2", columnDefinition = "varchar(40)  comment '功能区编码'")
    String deter2;

    @ApiModelProperty("功能区名称")
    @Column(name = "deter2Name", columnDefinition = "varchar(40)  comment '功能区名称'")
    String deter2Name;

    @ApiModelProperty("功能区类型编号")
    @Column(name = "deter2_type", columnDefinition = "varchar(40)  comment '功能区类型编号'")
    String deter2Type;

    @ApiModelProperty("功能区类型名")
    @Column(name = "deter2_type_name", columnDefinition = "varchar(40)  comment '功能区类型名'")
    String deter2TypeName;

    @ApiModelProperty("合作伙伴类型  [UDC]INV:PARTNER_TYPE")
    @Column(name = "p_type", columnDefinition = "varchar(40)  comment '合作伙伴类型 [UDC]INV:PARTNER_TYPE'")
    String pType;

    @ApiModelProperty("可使用仓库类型编码、可多选、逗号分隔存储")
    @Column(name = "wh_type", columnDefinition = "varchar(255) comment '可使用仓库类型编码、可多选、逗号分隔存储'")
    String whType;

    @ApiModelProperty("建仓前端是否可选，默认为：是 [UDC]INV:BUSINESS_CHOOSE")
    @Column(name = "business_choose", columnDefinition = "int(1)  default 1 comment '建仓前端是否可选，默认为：是 [UDC]INV:BUSINESS_CHOOSE'")
    Boolean businessChoose;

    @ApiModelProperty("是否零价库, 默认为：否 [UDC]INV:ZERO_WH")
    @Column(name = "is_zero_wh", columnDefinition = " int(1) default 0 comment '是否零价库, 默认为：否 [UDC]INV:ZERO_WH'")
    Boolean isZeroWh;

    @ApiModelProperty("是否启用，默认为启用 [UDC]INV:ACTIVE_STATUS")
    @Column(name = "status", columnDefinition = "varchar(40) default 'ACTIVE'  comment '是否启用，默认为启用 [UDC]INV:ACTIVE_STATUS'")
    String status;


}
