package com.elitesland.yst.production.inv.infr.repo;

import com.elitesland.yst.production.inv.domain.entity.invwh.QInvWhAreaDO;
import com.elitesland.yst.production.inv.domain.entity.invwh.QInvWhDO;
import com.elitesland.yst.production.inv.utils.BeanCopyUtil;
import com.elitesland.yst.production.inv.application.facade.vo.base.InvBaseModel;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.*;
import com.elitesland.yst.production.inv.dto.invstk.InvStkAllRpcDtoParam;
import com.elitesland.yst.production.inv.dto.invstk.InvStkItemUomRpcDtoParam;
import com.elitesland.yst.production.inv.dto.invstk.InvStkRpcDTO;
import com.elitesland.yst.production.inv.dto.invstk.InvStkRpcDtoParam;
import com.elitesland.yst.production.inv.domain.entity.invstk.InvStkDO;
import com.elitesland.yst.production.inv.domain.entity.invstk.QInvIoDO;
import com.elitesland.yst.production.inv.domain.entity.invstk.QInvItemPropDO;
import com.elitesland.yst.production.inv.domain.entity.invstk.QInvStkDO;
import com.elitesland.yst.production.inv.domain.entity.lot.QInvLotDO;
import com.elitesland.yst.production.inv.dto.invstk.InvStkGroupRpcDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkFullDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkGroupDTO;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;


/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author ssy
 * @since 2020-08-04 10:58:07
 */
@Component
@AllArgsConstructor
public class InvStkRepoProc implements JpaQueryProcInterface {

    private final JPAQueryFactory jpaQueryFactory;

    private final QInvStkDO jpaQDo = QInvStkDO.invStkDO;

    private final QInvLotDO invLotDO = QInvLotDO.invLotDO;


    /**
     * 封装select方法select层不返回jpaQurey
     * @param param
     * @return
     */
    public PagingVO useSelect(InvStkQueryParamVO param){
        JPAQuery<InvStkDTO> jpaQuery = select(param);
        long dataCount = jpaQuery.fetchCount();
        openOrderAndLimit(jpaQuery, param, QInvStkDO.invStkDO);
        List<InvStkDTO> lists = jpaQuery.fetch();
        List<InvStkRespVO> collect = lists.stream().map(v -> {
            InvStkRespVO invStkRespVO = new InvStkRespVO();
            BeanCopyUtil.beanCopy(v, invStkRespVO);
            return invStkRespVO;
        }).collect(Collectors.toList());
        PagingVO paging = new PagingVO();
        paging.setRecords(collect);
        paging.setTotal(dataCount);
        return paging;
    }

    /**
     * @param
     * @return
     * 库存同步分页查询
     */
    public PagingVO queryAll(InvStkQueryParamVO param){
        JPAQuery<InvStkDTO> jpaQuery = select(param);
        long dataCount = jpaQuery.fetchCount();
        openOrderAndLimit(jpaQuery, param, QInvStkDO.invStkDO);
        List<InvStkDTO> lists = jpaQuery.fetch();
        PagingVO paging = new PagingVO();
        paging.setRecords(lists);
        paging.setTotal(dataCount);
        return paging;
    }

    /**
     * 查询字段
     */
    public JPAQuery<InvStkDTO> select(InvStkQueryParamVO param) {
        Predicate predicate = jpaQDo.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvStkDTO.class,
                jpaQDo.id,
                jpaQDo.ouId,
                jpaQDo.buId,
                jpaQDo.itemId,
                jpaQDo.variId,
                jpaQDo.itemCode,
                jpaQDo.itemName,
                jpaQDo.itemCateCode,
                jpaQDo.brand,
                jpaQDo.whId,
                jpaQDo.deter1,
                jpaQDo.deter2,
                jpaQDo.deter3,
                jpaQDo.pType.as("PType"),
                jpaQDo.pCode.as("PCode"),
                jpaQDo.whLoc,
                jpaQDo.lotNo,
                jpaQDo.snNo,
                jpaQDo.inDate,
                jpaQDo.untilExpireDays,
                jpaQDo.fressType,
                jpaQDo.uom,
                jpaQDo.uom2,
                jpaQDo.uomRatio,
                jpaQDo.uomRatio2,
                jpaQDo.ohQty,
                jpaQDo.ohQty2,
                jpaQDo.rsvQty,
                jpaQDo.rsvQty2,
                jpaQDo.rsvQty3,
                jpaQDo.rsvQty4,
                jpaQDo.lockQty,
                jpaQDo.lockQty2,
                jpaQDo.lockQty3,
                jpaQDo.lockQty4,
                jpaQDo.owQty,
                jpaQDo.owQty2,
                jpaQDo.owQty3,
                jpaQDo.owQty4,
                jpaQDo.avalQty,
                jpaQDo.avalQty2,
                jpaQDo.volume,
                jpaQDo.netWeight,
                jpaQDo.grossWeight,
                jpaQDo.weight,
                jpaQDo.weightUomCode,
                jpaQDo.weightRatio,
                jpaQDo.amt,
                jpaQDo.stkDesc,
                jpaQDo.es1,
                jpaQDo.goodShelve,
                jpaQDo.tenantId,
                jpaQDo.remark,
                jpaQDo.createUserId,
                jpaQDo.createTime,
                jpaQDo.modifyUserId,
                jpaQDo.modifyTime,
                jpaQDo.deleteFlag,
                jpaQDo.secOuId,
                jpaQDo.secBuId,
                jpaQDo.secUserId,
                jpaQDo.limit1,
                jpaQDo.limit2,
                jpaQDo.limit3,
                jpaQDo.auditDataVersion
        )).from(jpaQDo);
        if (param != null) {
            jpaQuery.where(where(param));
        }
        jpaQuery.where(predicate, jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return jpaQuery;
    }
    /**
     * 查询字段
     */
    public JPAQuery<InvStkDO> selectDO(InvStkQueryParamVO param) {
        Predicate predicate = jpaQDo.isNotNull();
        val jpaQuery = jpaQueryFactory.select(jpaQDo).from(jpaQDo);
        if (param != null) {
            jpaQuery.where(where(param));
        }
        jpaQuery.where(predicate, jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return jpaQuery;
    }
    /**
     * 查询字段
     */
    public List<InvStkRpcDTO> findStkRpcDTOByParam(InvStkRpcDtoParam param) {
        QInvWhDO invWhDO = QInvWhDO.invWhDO;
        QInvWhAreaDO invWhAreaDO = QInvWhAreaDO.invWhAreaDO;
        Predicate predicate = jpaQDo.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvStkRpcDTO.class,
                jpaQDo.id,
                jpaQDo.ouId,
                jpaQDo.buId,
                jpaQDo.itemId,
                jpaQDo.variId,
                jpaQDo.itemCode,
                jpaQDo.itemCateCode,
                jpaQDo.whId,
                invWhDO.whCode,
                invWhDO.whName,
                jpaQDo.deter2,
                invWhAreaDO.deter2Type,
                invWhAreaDO.deter2Name,
                jpaQDo.deter3,
                jpaQDo.deter1,
                jpaQDo.pType.as("PType"),
                jpaQDo.pCode.as("PCode"),
                jpaQDo.lotNo,
                jpaQDo.snNo,
                jpaQDo.inDate,
                jpaQDo.uom,
                jpaQDo.uomRatio,
                jpaQDo.avalQty,
                jpaQDo.limit1,
                jpaQDo.limit2,
                jpaQDo.limit3
        )).from(jpaQDo).leftJoin(invWhDO).on(jpaQDo.whId.eq(invWhDO.id))
                .leftJoin(invWhAreaDO).on(jpaQDo.deter2.eq(invWhAreaDO.deter2)
                        .and(jpaQDo.whId.eq(invWhAreaDO.whId)));
        if (param != null) {
            jpaQuery.where(getPredicate(jpaQDo,param));
        }
        return jpaQuery.where(predicate, jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()))
                .fetch();

    }

    /**
     * 查询字段
     */
    public List<InvStkRpcDTO> findStkAllDTOByParam(InvStkAllRpcDtoParam param) {
        QInvWhDO invWhDO = QInvWhDO.invWhDO;
        QInvWhAreaDO invWhAreaDO = QInvWhAreaDO.invWhAreaDO;
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvStkRpcDTO.class,
                jpaQDo.id,
                jpaQDo.ouId,
                jpaQDo.buId,
                jpaQDo.itemId,
                jpaQDo.variId,
                jpaQDo.itemCode,
                jpaQDo.itemCateCode,
                jpaQDo.whId,
                invWhDO.whName,
                invWhDO.whCode,
                jpaQDo.deter2,
                invWhAreaDO.deter2Name,
                invWhAreaDO.deter2Type,
                jpaQDo.deter3,
                jpaQDo.deter1,
                jpaQDo.pType.as("PType"),
                jpaQDo.pCode.as("PCode"),
                jpaQDo.lotNo,
                jpaQDo.snNo,
                jpaQDo.inDate,
                jpaQDo.uom,
                jpaQDo.uomRatio,
                jpaQDo.avalQty,
                jpaQDo.limit1,
                jpaQDo.limit2,
                jpaQDo.limit3
        )).from(jpaQDo).leftJoin(invWhDO).on(jpaQDo.whId.eq(invWhDO.id))
                .leftJoin(invWhAreaDO).on(jpaQDo.deter2.eq(invWhAreaDO.deter2)
                        .and(jpaQDo.whId.eq(invWhAreaDO.whId)));
        if (param != null) {
            jpaQuery.where(findByAllRpcDtoParam(param));
        }
        return jpaQuery.where(jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()))
                .fetch();

    }


    /**
     * 查询在库商品字段
     */
    public List<ItmInvStkItemRespVO> selectInvStkItem(InvStkItemQueryParam param) {
        QInvWhDO invWhDO = QInvWhDO.invWhDO;
        QInvWhAreaDO invWhAreaDO = QInvWhAreaDO.invWhAreaDO;
        val jpaQuery = jpaQueryFactory.select(Projections.bean(ItmInvStkItemRespVO.class,
                jpaQDo.ouId,
                jpaQDo.itemId.as("id"),
                jpaQDo.variId,
                jpaQDo.itemCode,
                jpaQDo.itemName,
                jpaQDo.whId,
                invWhDO.whName,
                invWhDO.whCode,
                invWhAreaDO.deter2Name,
                invWhAreaDO.deter2Type,
                jpaQDo.deter2,
                jpaQDo.uom,
                jpaQDo.avalQty.coalesce(BigDecimal.ZERO).sum().as("avalQty")
        )).from(jpaQDo).leftJoin(invWhDO).on(jpaQDo.whId.eq(invWhDO.id))
                .leftJoin(invWhAreaDO).on(jpaQDo.deter2.eq(invWhAreaDO.deter2).and(jpaQDo.whId.eq(invWhAreaDO.whId)));
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        if(param != null) {
            whreInvStkItem(param, predicates);
        }
        jpaQuery.where(ExpressionUtils.allOf(predicates))
                .groupBy(jpaQDo.whId,jpaQDo.deter2,jpaQDo.itemId,jpaQDo.uom,jpaQDo.variId,jpaQDo.ouId);
        return jpaQuery.fetch();

    }

    public List<ItmInvStkItemRespVO> selectInvStkItemByDesIds(List<Long> desIds){
        QInvWhDO invWhDO = QInvWhDO.invWhDO;
        JPAQuery<ItmInvStkItemRespVO> jpaQuery = jpaQueryFactory.select(Projections.bean(ItmInvStkItemRespVO.class,
                jpaQDo.itemId,
                jpaQDo.itemCode
        )).from(jpaQDo).leftJoin(invWhDO)
                .on(jpaQDo.whId.eq(invWhDO.id));
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        predicates.add(invWhDO.desId.in(desIds));
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        jpaQuery.groupBy(jpaQDo.itemId);
        return jpaQuery.fetch();

    }

    private List<Predicate> whreInvStkItem(InvStkItemQueryParam param,List<Predicate> predicates){
        if (Objects.nonNull(param.getItemId())) {
            predicates.add(jpaQDo.itemId.eq(param.getItemId()));
        }
        if (Objects.nonNull(param.getItemCode())) {
            predicates.add(jpaQDo.itemCode.eq(param.getItemCode()));
        }
        if (Objects.nonNull(param.getDeter2())) {
            predicates.add(jpaQDo.deter2.eq(param.getDeter2()));
        }
        if (Objects.nonNull(param.getWhId())) {
            predicates.add(jpaQDo.whId.eq(param.getWhId()));
        }
        if (!CollectionUtils.isEmpty(param.getWhIds())) {
            predicates.add(jpaQDo.whId.in(param.getWhIds()));
        }
        if (!CollectionUtils.isEmpty(param.getItemIds())) {
            predicates.add(jpaQDo.itemId.in(param.getItemIds()));
        }
        if (Objects.nonNull(param.getItemCodeName())) {
            predicates.add(jpaQDo.itemCode.like('%' + param.getItemCodeName() + '%').or(jpaQDo.itemName.like('%' + param.getItemCodeName() + '%')));
        }
        if (Objects.nonNull(param.getOuId())) {
            predicates.add(jpaQDo.ouId.eq(param.getOuId()));
        }
        if (!CollectionUtils.isEmpty(param.getOuIds())) {
            predicates.add(jpaQDo.ouId.in(param.getOuIds()));
        }
        return predicates;
    }


    /**
     * 封装 查询条件
     *
     * @param jpaQDo
     * @param queryParam
     * @return
     */
    private Predicate getPredicate(QInvStkDO jpaQDo, InvStkRpcDtoParam queryParam) {
        QInvWhDO invWhDO = QInvWhDO.invWhDO;
        QInvWhAreaDO invWhAreaDO = QInvWhAreaDO.invWhAreaDO;
        Predicate predicate1 = queryParam.getItemId() != null ? jpaQDo.itemId.eq(queryParam.getItemId()) : null;
        Predicate predicate2 = queryParam.getVariId() != null && queryParam.getVariId() != 0 ? jpaQDo.variId.eq(queryParam.getVariId()) : null;
        Predicate predicate3 = StringUtils.hasLength(queryParam.getLotNo()) ? jpaQDo.lotNo.eq(queryParam.getLotNo()) : null;
        Predicate predicate4 = queryParam.getWhId() != null ? jpaQDo.whId.eq(queryParam.getWhId()) : null;
        Predicate predicate5 = StringUtils.hasLength(queryParam.getDeter2()) ? jpaQDo.deter2.eq(queryParam.getDeter2()) : null;
        Predicate predicate6 = StringUtils.hasLength(queryParam.getSnNo()) ? jpaQDo.snNo.eq(queryParam.getSnNo()) : null;
        Predicate predicate7 = StringUtils.hasLength(queryParam.getPType()) ? jpaQDo.pType.eq(queryParam.getPType()) : null;
        Predicate predicate8 = StringUtils.hasLength(queryParam.getPCode()) ? jpaQDo.pCode.eq(queryParam.getPCode()) : null;
        Predicate predicate9 = StringUtils.hasLength(queryParam.getDeter1()) ? jpaQDo.deter1.eq(queryParam.getDeter1()) : null;
        Predicate predicate10 = StringUtils.hasLength(queryParam.getLimit1()) ? jpaQDo.limit1.eq(queryParam.getLimit1()) : null;
        Predicate predicate11 = StringUtils.hasLength(queryParam.getDeter2Type()) ? invWhAreaDO.deter2Type.eq(queryParam.getDeter2Type()) : null;
        return ExpressionUtils.allOf(predicate1, predicate2, predicate3, predicate4, predicate5,predicate6,predicate7,predicate8,predicate9,predicate10,predicate11);
    }

    /**
     * 查询库存余额，按照仓库/功能区/商品分组查询统计
     */
    public JPAQuery<InvStkGroupDTO> selectInvStkGroupByParam(InvStkQueryGroupParamVO param) {
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvStkGroupDTO.class,
                jpaQDo.id,
                jpaQDo.ouId,
                jpaQDo.itemId,
                jpaQDo.variId,
                jpaQDo.itemCode,
                jpaQDo.itemCateCode,
                jpaQDo.brand,
                jpaQDo.whId,
                jpaQDo.deter2,
                jpaQDo.deter3,
                jpaQDo.goodShelve,
                jpaQDo.pType.as("PType"),
                jpaQDo.pCode.as("PCode"),
                jpaQDo.ohQty.coalesce(BigDecimal.ZERO).sum().as("ohQty"),
                jpaQDo.avalQty.coalesce(BigDecimal.ZERO).sum().as("avalQty"),
                jpaQDo.lockQty.coalesce(BigDecimal.ZERO).sum().as("lockQty"),
                jpaQDo.lockQty2.coalesce(BigDecimal.ZERO).sum().as("lockQty2"),
                jpaQDo.lockQty3.coalesce(BigDecimal.ZERO).sum().as("lockQty3"),
                jpaQDo.owQty.coalesce(BigDecimal.ZERO).sum().as("owQty"),
                jpaQDo.owQty2.coalesce(BigDecimal.ZERO).sum().as("owQty2"),
                jpaQDo.owQty3.coalesce(BigDecimal.ZERO).sum().as("owQty3"),
                jpaQDo.rsvQty.coalesce(BigDecimal.ZERO).sum().as("rsvQty"),
                jpaQDo.rsvQty2.coalesce(BigDecimal.ZERO).sum().as("rsvQty2"),
                jpaQDo.rsvQty3.coalesce(BigDecimal.ZERO).sum().as("rsvQty3"),
                jpaQDo.amt.coalesce(BigDecimal.valueOf(0)).sum().as("amt"),
                jpaQDo.uom,
                jpaQDo.uom2,
                jpaQDo.uomRatio,
                jpaQDo.uomRatio2,
                jpaQDo.creator,
                jpaQDo.createUserId,
                jpaQDo.createTime,
                jpaQDo.secOuId,
                jpaQDo.secBuId,
                jpaQDo.secUserId,
                jpaQDo.limit1,
                jpaQDo.limit2,
                jpaQDo.limit3
        )).from(jpaQDo);
        if(param != null){
            jpaQuery.where(whereGroup(param));
        }
        jpaQuery.where(jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()))
                .groupBy(jpaQDo.whId,jpaQDo.deter2,jpaQDo.itemId,jpaQDo.pCode,jpaQDo.pType)
                .orderBy(new OrderSpecifier(Order.DESC,jpaQDo.createTime));
        return jpaQuery;
    }

    public PagingVO<InvStkGroupDTO> invStkGroupSearch(InvStkQueryGroupParamVO param) {
        QInvWhDO invWhDO = QInvWhDO.invWhDO;
        QInvWhAreaDO invWhAreaDO = QInvWhAreaDO.invWhAreaDO;
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvStkGroupDTO.class,
                jpaQDo.id,
                jpaQDo.ouId,
                jpaQDo.itemId,
                jpaQDo.itemCode,
                jpaQDo.itemCateCode,
                jpaQDo.brand,
                jpaQDo.whId,
                invWhDO.whCode,
                invWhDO.whType,
                invWhDO.whName,
                jpaQDo.deter2,
                invWhAreaDO.deter2Name,
                invWhAreaDO.deter2Type,
                jpaQDo.deter3,
                jpaQDo.goodShelve,
                jpaQDo.pType.as("PType"),
                jpaQDo.pCode.as("PCode"),
                jpaQDo.ohQty.coalesce(BigDecimal.ZERO).sum().as("ohQty"),
                jpaQDo.avalQty.coalesce(BigDecimal.ZERO).sum().as("avalQty"),
                jpaQDo.lockQty.coalesce(BigDecimal.ZERO).sum().as("lockQty"),
                jpaQDo.lockQty2.coalesce(BigDecimal.ZERO).sum().as("lockQty2"),
                jpaQDo.lockQty3.coalesce(BigDecimal.ZERO).sum().as("lockQty3"),
                jpaQDo.owQty.coalesce(BigDecimal.ZERO).sum().as("owQty"),
                jpaQDo.owQty2.coalesce(BigDecimal.ZERO).sum().as("owQty2"),
                jpaQDo.owQty3.coalesce(BigDecimal.ZERO).sum().as("owQty3"),
                jpaQDo.rsvQty.coalesce(BigDecimal.ZERO).sum().as("rsvQty"),
                jpaQDo.rsvQty2.coalesce(BigDecimal.ZERO).sum().as("rsvQty2"),
                jpaQDo.rsvQty3.coalesce(BigDecimal.ZERO).sum().as("rsvQty3"),
                jpaQDo.amt.coalesce(BigDecimal.valueOf(0)).sum().as("amt"),
                jpaQDo.uom,
                jpaQDo.limit1,
                jpaQDo.limit2,
                jpaQDo.limit3
        )).from(jpaQDo).leftJoin(invWhDO).on(jpaQDo.whId.eq(invWhDO.id))
                .leftJoin(invWhAreaDO).on(jpaQDo.deter2.eq(invWhAreaDO.deter2)
                        .and(jpaQDo.whId.eq(invWhAreaDO.whId)));
        if (param != null) {
            jpaQuery.where(whereGroup(param));
        }
        jpaQuery.where(jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        jpaQuery.groupBy(jpaQDo.whId,jpaQDo.deter2,jpaQDo.itemId,jpaQDo.pCode,jpaQDo.pType);
        param.fillOrders(jpaQuery, jpaQDo);
        param.setPaging(jpaQuery);
        return PagingVO.<InvStkGroupDTO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }

    public JPAQuery<InvStkFullDTO> fullSearch(InvStkFullParamVO param) {
        QInvWhDO invWhDO = QInvWhDO.invWhDO;
        QInvWhAreaDO invWhAreaDO = QInvWhAreaDO.invWhAreaDO;
        val jpaQuery = jpaQueryFactory.select(
                Projections.bean(
                        InvStkFullDTO.class,
                        jpaQDo.id,
                        jpaQDo.ouId,
                        jpaQDo.itemId,
                        jpaQDo.variId,
                        jpaQDo.itemCode,
                        jpaQDo.itemCateCode,
                        jpaQDo.brand,
                        jpaQDo.whId,
                        invWhDO.whName,
                        invWhDO.whCode,
                        invWhDO.whType,
                        jpaQDo.deter2,
                        invWhAreaDO.deter2Name,
                        invWhAreaDO.deter2Type,
                        jpaQDo.deter3,
                        jpaQDo.goodShelve,
                        jpaQDo.pType.as("PType"),
                        jpaQDo.pCode.as("PCode"),
                        jpaQDo.ohQty.as("ohQty"),
                        jpaQDo.avalQty.as("avalQty"),
                        jpaQDo.lockQty.as("lockQty"),
                        jpaQDo.lockQty2.as("lockQty2"),
                        jpaQDo.lockQty3.as("lockQty3"),
                        jpaQDo.owQty.as("owQty"),
                        jpaQDo.owQty2.as("owQty2"),
                        jpaQDo.owQty3.as("owQty3"),
                        jpaQDo.rsvQty.as("rsvQty"),
                        jpaQDo.rsvQty2.as("rsvQty2"),
                        jpaQDo.rsvQty3.as("rsvQty3"),
                        jpaQDo.amt.as("amt"),
                        jpaQDo.uom,
                        jpaQDo.uom2,
                        jpaQDo.uomRatio,
                        jpaQDo.uomRatio2,
                        jpaQDo.creator,
                        jpaQDo.createUserId,
                        jpaQDo.createTime,
                        jpaQDo.secOuId,
                        jpaQDo.secBuId,
                        jpaQDo.secUserId,
                        jpaQDo.limit1,
                        jpaQDo.limit2,
                        jpaQDo.limit3,
                        jpaQDo.lotNo,
                        jpaQDo.snNo

                )
        ).from(jpaQDo).leftJoin(invWhDO).on(jpaQDo.whId.eq(invWhDO.id))
                .leftJoin(invWhAreaDO).on(invWhDO.id.eq(invWhAreaDO.whId)
                        .and(jpaQDo.deter2.eq(invWhAreaDO.deter2)));
        if (param != null) {
            jpaQuery.where(fullWhere(param));
        }

        jpaQuery.where(jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return jpaQuery;
    }

    /**
     * 查询库存余额，按照仓库/功能区/商品分组查询统计
     */
    public List<InvStkGroupBatchRespVO> selectInvStkGroupBatchByParam(InvBaseModel param) {
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvStkGroupBatchRespVO.class,
                jpaQDo.id,
                jpaQDo.ouId,
                jpaQDo.itemId,
                jpaQDo.variId,
                jpaQDo.itemCode,
                jpaQDo.whId,
                jpaQDo.deter2,
                jpaQDo.pType.as("PType"),
                jpaQDo.pCode.as("PCode"),
                jpaQDo.ohQty.coalesce(BigDecimal.ZERO).sum().as("ohQty"),
                jpaQDo.avalQty.coalesce(BigDecimal.ZERO).sum().as("avalQty"),
                jpaQDo.lockQty.coalesce(BigDecimal.ZERO).sum().as("lockQty"),
                jpaQDo.rsvQty.coalesce(BigDecimal.ZERO).sum().as("rsvQty"),
                jpaQDo.uom,
                jpaQDo.uom2,
                jpaQDo.lotNo,
                jpaQDo.limit1,
                jpaQDo.limit2,
                jpaQDo.limit3,
                jpaQDo.uomRatio,
                jpaQDo.uomRatio2,
                jpaQDo.goodShelve
        )).from(jpaQDo)
                .orderBy(new OrderSpecifier(Order.DESC,jpaQDo.createTime));

        List<Predicate> predicates = new ArrayList<>();
        predicates.add(jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        if (!StringUtils.isEmpty(param.getItemId())) {
            predicates.add(jpaQDo.itemId.eq(param.getItemId()));
        }
        if (!StringUtils.isEmpty(param.getVariId())) {
            predicates.add(jpaQDo.variId.eq(param.getVariId()));
        }
        if (!StringUtils.isEmpty(param.getWhId())) {
            predicates.add(jpaQDo.whId.eq(param.getWhId()));
        }
        if (!StringUtils.isEmpty(param.getDeter2())) {
            predicates.add(jpaQDo.deter2.eq(param.getDeter2()));
        }
        if (!StringUtils.isEmpty(param.getUom())) {
            predicates.add(jpaQDo.uom.eq(param.getDeter2()));
        }
        /*if (!StringUtils.isEmpty(param.getPCode())) {
            predicates.add(jpaQDo.pCode.eq(param.getPCode()));
        }
        if (!StringUtils.isEmpty(param.getPType())) {
            predicates.add(jpaQDo.pType.eq(param.getPType()));
        }*/
        if(!StringUtils.isEmpty(param.getLotNo())){
            predicates.add(jpaQDo.lotNo.eq(param.getLotNo()));
        }
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return jpaQuery.fetch();
    }

    public JPAQuery<InvStkLikeRespVO> selectLotNo(InvStkLikeParamVO param) {
        val jpaQDo = QInvStkDO.invStkDO;
        val invLotDO = QInvLotDO.invLotDO;
        Predicate predicate = jpaQDo.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvStkLikeRespVO.class,
                jpaQDo.id,
                jpaQDo.lotNo,
                jpaQDo.whId,
                jpaQDo.avalQty
        )).from(jpaQDo);
        jpaQuery.leftJoin(invLotDO).on(jpaQDo.itemCode.eq(invLotDO.itemCode).
                and(jpaQDo.variId.eq(invLotDO.variId).or(jpaQDo.variId.isNull().and(invLotDO.variId.isNull())))
                .and(jpaQDo.lotNo.eq(invLotDO.lotNo))
        );
        jpaQuery.where(predicate, invLotDO.lotStatus.eq("0")).orderBy(invLotDO.manuDate.asc());
        if (param != null) {
            if (!StringUtils.isEmpty(param.getKeyword())) {
                jpaQuery.where(predicate,
                        (jpaQDo.lotNo.like("%" + param.getKeyword() + "%"))
                                .or(jpaQDo.itemCode.like("%" + param.getKeyword() + "%")));
            }
//            jpaQuery.where(predicate, jpaQDo.itemCode.like("%" + param.getKeyword() + "%"));
            if (!StringUtils.isEmpty(param.getItemCode())) {
                jpaQuery.where(jpaQDo.itemCode.eq(param.getItemCode()));
            }
            if (!StringUtils.isEmpty(param.getWhId())) {
                jpaQuery.where(predicate, jpaQDo.whId.eq(param.getWhId()));
            }
            if (!StringUtils.isEmpty(param.getDeter1())) {
                jpaQuery.where(predicate, jpaQDo.deter1.eq(param.getDeter1()));
            }
            if (!StringUtils.isEmpty(param.getDeter2())) {
                jpaQuery.where(predicate, jpaQDo.deter2.eq(param.getDeter2()));
            }
            if (!StringUtils.isEmpty(param.getDeter3())) {
                jpaQuery.where(predicate, jpaQDo.deter3.eq(param.getDeter3()));
            }

        }
        jpaQuery.where(predicate, jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return jpaQuery;
    }


    /**
     * 查询详细参数
     */
    public JPAQuery<InvStkDRespVO> selectD(InvStkDQueryParamVO param) {
        val invStkDO = QInvStkDO.invStkDO;
        val invLotDO = QInvLotDO.invLotDO;
        return jpaQueryFactory.select(
                Projections.bean(
                        InvStkDRespVO.class,
                        invStkDO.id,
                        invStkDO.ouId,
                        invStkDO.buId,
                        invStkDO.itemId,
                        invStkDO.itemCode,
                        invStkDO.variId,
                        invStkDO.whId,
                        invStkDO.deter1,
                        invStkDO.deter2,
                        invStkDO.deter3,
                        invStkDO.inDate,
                        invStkDO.untilExpireDays,
                        invStkDO.fressType,
                        invStkDO.createTime,
                        invStkDO.uom,
                        invStkDO.uom2,
                        invStkDO.uomRatio,
                        invStkDO.uomRatio2,
                        invStkDO.ohQty,
                        invStkDO.pCode.as("PCode"),
                        invStkDO.pType.as("PType"),

                        invStkDO.rsvQty,
                        invStkDO.rsvQty2,

                        invStkDO.lockQty,

                        invStkDO.avalQty,
                        invStkDO.lotNo,
                        invStkDO.amt,
                        invStkDO.stkDesc,
                        invStkDO.stkDesc2,
                        invStkDO.srcDocCls,
                        invStkDO.srcDocId,
                        invStkDO.srcDocDid,
                        invStkDO.srcDocCls2,
                        invStkDO.srcDocId2,
                        invStkDO.srcDocDid2,
                        invLotDO.sinNo,
                        invLotDO.sinQty,
                        invLotDO.manuDate,
                        invLotDO.expireDate,
                        invLotDO.menuLotNo,
                        invLotDO.expireDays,
                        invLotDO.qcStatus,
                        invLotDO.lotStatus
                )
        ).from(invStkDO)
                .leftJoin(invLotDO).on(
                        invStkDO.itemId.eq(invLotDO.itemId),
                        invStkDO.lotNo.eq(invLotDO.lotNo),
                        invStkDO.variId.eq(invLotDO.variId).or(invStkDO.variId.isNull().and(invLotDO.variId.isNull())))
                .where(where(param), invStkDO.deleteFlag.eq(0).or(invStkDO.deleteFlag.isNull()));
    }


    /**
     * 进销存查询
     *
     * @param param
     * @return
     */
    public JPAQuery<InvStkIOxRespVO> searchIO(InvStkIOParamVO param) {
        val invIoDO = QInvIoDO.invIoDO;
        val invStkDO = QInvStkDO.invStkDO;
        return jpaQueryFactory.select(
                Projections.bean(
                        InvStkIOxRespVO.class,
                        invIoDO.qty.coalesce(BigDecimal.ZERO).sum().as("num"),
                        invIoDO.netAmt.coalesce(BigDecimal.valueOf(0)).sum().as("net_amt"),
                        invIoDO.amt.coalesce(BigDecimal.valueOf(0)).sum().as("amt"),
                        invIoDO.lotNo,
                        invIoDO.itemId,
                        invIoDO.whId,
                        invIoDO.deter1,
                        invIoDO.deter2,
                        invIoDO.deter3,
                        invIoDO.ioCode
                )
        ).from(invStkDO).leftJoin(invIoDO).on(invStkDO.whId.eq(invIoDO.whId), invStkDO.lotNo.eq(invIoDO.lotNo), invStkDO.itemId.eq(invIoDO.itemId),
                invStkDO.deter3.isNull().and(invStkDO.deter1.eq(invIoDO.deter1)).and(invStkDO.deter2.eq(invIoDO.deter2)).or(invStkDO.deter3.isNotNull().and(invStkDO.deter3.eq(invIoDO.deter3))))
                .where(where(param), invIoDO.deleteFlag.eq(0).or(invIoDO.deleteFlag.isNull()), invStkDO.deleteFlag.eq(0).or(invStkDO.deleteFlag.isNull()))
                .groupBy(invIoDO.lotNo, invIoDO.whId, invIoDO.itemId, invIoDO.deter1, invIoDO.deter2, invIoDO.deter3, invIoDO.ioCode);
    }


    public List<ItmInvStkShareRespVO> searchInvShareStk(InvStkShareQueryParam param) {
        val invStkDO = QInvStkDO.invStkDO;
        val invItemPropDO = QInvItemPropDO.invItemPropDO;
        val invLotDO = QInvLotDO.invLotDO;
        JPAQuery<ItmInvStkShareRespVO> jpaQuery = jpaQueryFactory.selectDistinct(
                Projections.bean(
                        ItmInvStkShareRespVO.class,
                        invStkDO.id,
                        invStkDO.ouId,
                        invStkDO.buId,
                        invStkDO.itemId,
                        invStkDO.itemCode,
                        invStkDO.itemCateCode,
                        invStkDO.whId,
                        invStkDO.deter2,
                        invStkDO.uom,
                        invStkDO.pCode.as("PCode"),
                        invStkDO.pType.as("PType"),
                        invStkDO.avalQty,
                        invStkDO.lotNo,
                        invItemPropDO.shareType,
                        invItemPropDO.shareSetting,
                        invLotDO.expireDate
                )
        ).from(invStkDO)
                .innerJoin(invItemPropDO).on(
                        invStkDO.itemCateCode.eq(invItemPropDO.itemCateCode))
                .leftJoin(invLotDO).on(
                        invStkDO.itemId.eq(invLotDO.itemId),
                        invStkDO.lotNo.eq(invLotDO.lotNo)
                );

        List<Predicate> predicates = whereShareInvStk(invStkDO, invItemPropDO, param);
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return jpaQuery.fetch();

    }


    public List<Predicate> whereShareInvStk (QInvStkDO invStkDO,QInvItemPropDO invItemPropDO,InvStkShareQueryParam param){
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(invStkDO.deleteFlag.eq(0).or(invStkDO.deleteFlag.isNull()));
        predicates.add(invStkDO.itemCateCode.isNotNull());

        if (!CollectionUtils.isEmpty(param.getDeter2s())) {
            predicates.add(invStkDO.deter2.in(param.getDeter2s()));
        }

        if (!StringUtils.isEmpty(param.getItemId())) {
            predicates.add(invStkDO.itemId.eq(param.getItemId()));
        }
        if (!CollectionUtils.isEmpty(param.getItemIds())) {
            predicates.add(invStkDO.itemId.in(param.getItemIds()));
        }
        if (!StringUtils.isEmpty(param.getWhId())) {
            predicates.add(invStkDO.whId.eq(param.getWhId()));
        }
        if (!StringUtils.isEmpty(param.getDeter2())) {
            predicates.add(invStkDO.deter2.eq(param.getDeter2()));
        }

        if (!StringUtils.isEmpty(param.getOuId())) {
            predicates.add(invStkDO.ouId.eq(param.getOuId()));
        }
        if (!CollectionUtils.isEmpty(param.getOuIds())) {
            predicates.add(invStkDO.ouId.in(param.getOuIds()));
        }
        if (!CollectionUtils.isEmpty(param.getWhIds())) {
            predicates.add(invStkDO.whId.in(param.getWhIds()));
        }

        if (!StringUtils.isEmpty(param.getPCode())) {
            predicates.add(invStkDO.pCode.eq(param.getPCode()));
        }
        if (!StringUtils.isEmpty(param.getPType())) {
            predicates.add(invStkDO.pType.eq(param.getPType()));
        }

        if (!StringUtils.isEmpty(param.getShareType())) {
            predicates.add(invItemPropDO.shareType.eq(param.getShareType()));
        }
        return predicates;

    }


    public Predicate where(InvStkIOParamVO param) {
        val invIoDO = QInvIoDO.invIoDO;
        val invStkDO = QInvStkDO.invStkDO;
        Predicate predicate = invIoDO.isNotNull().or(invIoDO.isNull());
        if (!CollectionUtils.isEmpty(param.getWhIds())) {
            predicate = ExpressionUtils.and(predicate, invIoDO.whId.in(param.getWhIds()));
        }
        if (!StringUtils.isEmpty(param.getDeter1())) {
            predicate = ExpressionUtils.and(predicate, invIoDO.deter1.eq(param.getDeter1()));
        }
        if (!CollectionUtils.isEmpty(param.getDeter2s())) {
            predicate = ExpressionUtils.and(predicate, invIoDO.deter2.in(param.getDeter2s()));
        }
        if(!CollectionUtils.isEmpty(param.getItemIds())){
            predicate = ExpressionUtils.and(predicate, invIoDO.itemId.in(param.getItemIds()));
        }
        if (!CollectionUtils.isEmpty(param.getLotNos())) {
            predicate = ExpressionUtils.and(predicate, invIoDO.lotNo.in(param.getLotNos()));
        }
        if (!StringUtils.isEmpty(param.getLotNo())) {
            predicate = ExpressionUtils.and(predicate, invIoDO.lotNo.like('%' + param.getLotNo() + '%'));
        }
        if (!(StringUtils.isEmpty(param.getTimeSlotStart()) || StringUtils.isEmpty(param.getTimeSlotEnd()))) {
            predicate = ExpressionUtils.and(predicate, invIoDO.ioDate.between(param.getTimeSlotStart(), param.getTimeSlotEnd()));
        }
        if (!StringUtils.isEmpty(param.getNoStk())) {
            if (param.getNoStk().equals(false)) {
                predicate = ExpressionUtils.and(predicate, invStkDO.avalQty.ne(BigDecimal.ZERO));
            }
        }
        return predicate;
    }

    public Predicate where(InvStkAllRpcDtoParam param) {
        val invStkDO = QInvStkDO.invStkDO;
        Predicate predicate = jpaQDo.isNotNull().or(jpaQDo.isNull());
        if (!StringUtils.isEmpty(param.getOuId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ouId.eq(param.getOuId()));
        }
        if (!StringUtils.isEmpty(param.getBuId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.buId.eq(param.getBuId()));
        }
        if (!StringUtils.isEmpty(param.getWhId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whId.eq(param.getWhId()));
        }
        if (!CollectionUtils.isEmpty(param.getWhIds())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whId.in(param.getWhIds()));
        }
        if (!StringUtils.isEmpty(param.getDeter1())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter1.eq(param.getDeter1()));
        }
        if (!StringUtils.isEmpty(param.getDeter2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter2.eq(param.getDeter2()));
        }
        if(!CollectionUtils.isEmpty(param.getDeter2s())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter2.in(param.getDeter2s()));
        }

        if (!StringUtils.isEmpty(param.getLotNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.lotNo.eq(param.getLotNo()));
        }
        if (!StringUtils.isEmpty(param.getSnNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.snNo.eq(param.getSnNo()));
        }
        if(!CollectionUtils.isEmpty(param.getSnNos())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.snNo.in(param.getSnNos()));
        }
        if (!StringUtils.isEmpty(param.getPType())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.pType.eq(param.getPType()));
        }
        if (!StringUtils.isEmpty(param.getPCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.pCode.eq(param.getPCode()));
        }

        return predicate;
    }



    /**
     * 根据主键查询
     *
     * @param id 主键
     */
    public Predicate where(Long id) {
        val jpaQDo = QInvStkDO.invStkDO;
        Predicate predicate = jpaQDo.isNotNull().or(jpaQDo.isNull());
        ExpressionUtils.and(predicate, jpaQDo.id.eq(id));
        return predicate;
    }


    public Predicate whereGroup(InvStkQueryGroupParamVO param) {
        QInvWhDO invWhDO = QInvWhDO.invWhDO;
        QInvWhAreaDO invWhAreaDO = QInvWhAreaDO.invWhAreaDO;
        Predicate predicate = jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull());
        try {
            Predicate predicateAuth = DataAuthJpaUtil.dataAuthJpaPredicate(jpaQDo.getMetadata());
            predicate = ExpressionUtils.and(predicate, predicateAuth);
        } catch (Exception e) {
            throw new BusinessException( ApiCode.FAIL, "数据权限异常");
        }
        if (!(StringUtils.isEmpty(param.getItemIds()) || param.getItemIds().isEmpty())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.itemId.in(param.getItemIds()));
        }
        if (!(StringUtils.isEmpty(param.getVariIds()) || param.getVariIds().isEmpty())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.variId.in(param.getVariIds()));
        }
        if (!(StringUtils.isEmpty(param.getItemCodes()) || param.getItemCodes().isEmpty())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.itemCode.in(param.getItemCodes()));
        }
        if (!(StringUtils.isEmpty(param.getPCode()))) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.pCode.eq(param.getPCode()));
        }
        if (!(StringUtils.isEmpty(param.getPType()))) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.pType.eq(param.getPType()));
        }

        if (!(StringUtils.isEmpty(param.getWhIds()) || param.getWhIds().isEmpty())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whId.in(param.getWhIds()));
        }

        if (StringUtils.hasLength(param.getWhType())) {
            predicate = ExpressionUtils.and(predicate, invWhDO.whType.eq(param.getWhType()));
        }
        if (StringUtils.hasLength(param.getDeter2KeyWord())) {
            predicate = ExpressionUtils.and(predicate, ExpressionUtils.or(
                    invWhAreaDO.deter2.like("%" + param.getDeter2KeyWord() + "%"),
                    invWhAreaDO.deter2Name.like("%" + param.getDeter2KeyWord() + "%")
            ));
        }
        if (!(StringUtils.isEmpty(param.getOuIds()) || param.getOuIds().isEmpty())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ouId.in(param.getOuIds()));
        }
        if (!StringUtils.isEmpty(param.getDeter2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter2.eq(param.getDeter2()));
        }
        if (!(StringUtils.isEmpty(param.getDeter2s()) || param.getDeter2s().isEmpty())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter2.in(param.getDeter2s()));
        }
        if (!StringUtils.isEmpty(param.getDeleteFlag())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deleteFlag.eq(param.getDeleteFlag()));
        }
        if (!StringUtils.isEmpty(param.getLotNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.lotNo.like('%' + param.getLotNo() + '%'));
        }
        if (!StringUtils.isEmpty(param.getLimit1())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.limit1.eq(param.getLimit1()));
        }
        /**数据权限*/
        try {
            Predicate   predicateAuth=   DataAuthJpaUtil.dataAuthJpaPredicate(jpaQDo.getMetadata());
            predicate=  ExpressionUtils.and(predicate,predicateAuth);
        } catch (Exception e) {
            throw new BusinessException(ApiCode.FAIL,"数据权限异常");
        }
        return predicate;
    }

    public Predicate fullWhere(InvStkFullParamVO param){
        Predicate predicate = jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull());
        try {
            Predicate predicateAuth = DataAuthJpaUtil.dataAuthJpaPredicate(jpaQDo.getMetadata());
            predicate = ExpressionUtils.and(predicate, predicateAuth);
        } catch (Exception e) {
            throw new BusinessException( ApiCode.FAIL, "数据权限异常");
        }
        if (!(StringUtils.isEmpty(param.getItemIds()) || param.getItemIds().isEmpty())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.itemId.in(param.getItemIds()));
        }
        if (!(StringUtils.isEmpty(param.getVariIds()) || param.getVariIds().isEmpty())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.variId.in(param.getVariIds()));
        }
        if (!(StringUtils.isEmpty(param.getItemCodes()) || param.getItemCodes().isEmpty())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.itemCode.in(param.getItemCodes()));
        }
        if (!(StringUtils.isEmpty(param.getPCode()))) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.pCode.eq(param.getPCode()));
        }
        if (!(StringUtils.isEmpty(param.getPType()))) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.pType.eq(param.getPType()));
        }

        if (!(StringUtils.isEmpty(param.getWhIds()) || param.getWhIds().isEmpty())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whId.in(param.getWhIds()));
        }
        if (!(StringUtils.isEmpty(param.getOuIds()) || param.getOuIds().isEmpty())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ouId.in(param.getOuIds()));
        }
        if (!StringUtils.isEmpty(param.getDeter2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter2.eq(param.getDeter2()));
        }
        if (!(StringUtils.isEmpty(param.getDeter2s()) || param.getDeter2s().isEmpty())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter2.in(param.getDeter2s()));
        }
        if (!StringUtils.isEmpty(param.getDeleteFlag())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deleteFlag.eq(param.getDeleteFlag()));
        }

        return predicate;
    }

    /**
     * 条件查询
     *
     * @param param 查询条件
     */
    public Predicate where(InvStkQueryParamVO param) {
        val jpaQDo = QInvStkDO.invStkDO;
        Predicate predicate = jpaQDo.isNotNull().or(jpaQDo.isNull());
        if (!StringUtils.isEmpty(param.getId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.id.eq(param.getId()));
        }
        if (!StringUtils.isEmpty(param.getOuId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ouId.eq(param.getOuId()));
        }
        if (!StringUtils.isEmpty(param.getBuId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.buId.eq(param.getBuId()));
        }
        if (!StringUtils.isEmpty(param.getItemId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.itemId.eq(param.getItemId()));
        }
        if (!StringUtils.isEmpty(param.getVariId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.variId.eq(param.getVariId()));
        }
        if (!StringUtils.isEmpty(param.getItemCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.itemCode.eq(param.getItemCode()));
        }
        if (!StringUtils.isEmpty(param.getWhId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whId.eq(param.getWhId()));
        }
        if (!CollectionUtils.isEmpty(param.getWhIds())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whId.in(param.getWhIds()));
        }
        if (!StringUtils.isEmpty(param.getDeter1())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter1.eq(param.getDeter1()));
        }
        if (!StringUtils.isEmpty(param.getDeter2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter2.eq(param.getDeter2()));
        }
        if (!StringUtils.isEmpty(param.getDeter3())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter3.eq(param.getDeter3()));
        }
        if (!StringUtils.isEmpty(param.getWhLoc())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whLoc.eq(param.getWhLoc()));
        }
        if (!StringUtils.isEmpty(param.getWhPosi())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whPosi.eq(param.getWhPosi()));
        }
        if (!StringUtils.isEmpty(param.getLotNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.lotNo.eq(param.getLotNo()));
        }
        if (!StringUtils.isEmpty(param.getSnNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.snNo.eq(param.getSnNo()));
        }
        if (!StringUtils.isEmpty(param.getInDate())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.inDate.eq(param.getInDate()));
        }
        if (!StringUtils.isEmpty(param.getUntilExpireDays())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.untilExpireDays.eq(param.getUntilExpireDays()));
        }
        if (!StringUtils.isEmpty(param.getFressType())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.fressType.eq(param.getFressType()));
        }
        if (!StringUtils.isEmpty(param.getUom())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.uom.eq(param.getUom()));
        }
        if (!StringUtils.isEmpty(param.getUom2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.uom2.eq(param.getUom2()));
        }
        if (!StringUtils.isEmpty(param.getUomRatio())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.uomRatio.eq(param.getUomRatio()));
        }
        if (!StringUtils.isEmpty(param.getUomRatio2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.uomRatio2.eq(param.getUomRatio2()));
        }
        if (!StringUtils.isEmpty(param.getOhQty())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ohQty.eq(param.getOhQty()));
        }
        if (!StringUtils.isEmpty(param.getOhQty2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ohQty2.eq(param.getOhQty2()));
        }
        if (!StringUtils.isEmpty(param.getRsvQty())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.rsvQty.eq(param.getRsvQty()));
        }
        if (!StringUtils.isEmpty(param.getRsvQty2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.rsvQty2.eq(param.getRsvQty2()));
        }
        if (!StringUtils.isEmpty(param.getRsvQty3())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.rsvQty3.eq(param.getRsvQty3()));
        }
        if (!StringUtils.isEmpty(param.getRsvQty4())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.rsvQty4.eq(param.getRsvQty4()));
        }
        if (!StringUtils.isEmpty(param.getLockQty())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.lockQty.eq(param.getLockQty()));
        }
        if (!StringUtils.isEmpty(param.getLockQty2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.lockQty2.eq(param.getLockQty2()));
        }
        if (!StringUtils.isEmpty(param.getLockQty3())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.lockQty3.eq(param.getLockQty3()));
        }
        if (!StringUtils.isEmpty(param.getLockQty4())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.lockQty4.eq(param.getLockQty4()));
        }
        if (!StringUtils.isEmpty(param.getOwQty())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.owQty.eq(param.getOwQty()));
        }
        if (!StringUtils.isEmpty(param.getOwQty2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.owQty2.eq(param.getOwQty2()));
        }
        if (!StringUtils.isEmpty(param.getOwQty3())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.owQty3.eq(param.getOwQty3()));
        }
        if (!StringUtils.isEmpty(param.getOwQty4())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.owQty4.eq(param.getOwQty4()));
        }
        if (!StringUtils.isEmpty(param.getAvalQty())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.avalQty.eq(param.getAvalQty()));
        }
        if (!StringUtils.isEmpty(param.getAvalQty2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.avalQty2.eq(param.getAvalQty2()));
        }
        if (!StringUtils.isEmpty(param.getWeightUomCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.weightUomCode.eq(param.getWeightUomCode()));
        }
        if (!StringUtils.isEmpty(param.getWeightRatio())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.weightRatio.eq(param.getWeightRatio()));
        }
        if (!StringUtils.isEmpty(param.getAmt())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.amt.eq(param.getAmt()));
        }
        if (!StringUtils.isEmpty(param.getStkDesc())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.stkDesc.eq(param.getStkDesc()));
        }
        if (!StringUtils.isEmpty(param.getStkDesc2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.stkDesc2.eq(param.getStkDesc2()));
        }
        if (!StringUtils.isEmpty(param.getSrcDocCls())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.srcDocCls.eq(param.getSrcDocCls()));
        }
        if (!StringUtils.isEmpty(param.getSrcDocId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.srcDocId.eq(param.getSrcDocId()));
        }
        if (!StringUtils.isEmpty(param.getSrcDocDid())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.srcDocDid.eq(param.getSrcDocDid()));
        }
        if (!StringUtils.isEmpty(param.getSrcDocCls2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.srcDocCls2.eq(param.getSrcDocCls2()));
        }
        if (!StringUtils.isEmpty(param.getSrcDocId2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.srcDocId2.eq(param.getSrcDocId2()));
        }
        if (!StringUtils.isEmpty(param.getSrcDocDid2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.srcDocDid2.eq(param.getSrcDocDid2()));
        }
        if (!StringUtils.isEmpty(param.getEs1())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.es1.eq(param.getEs1()));
        }
        if (!StringUtils.isEmpty(param.getEs2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.es2.eq(param.getEs2()));
        }
        if (!StringUtils.isEmpty(param.getEs3())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.es3.eq(param.getEs3()));
        }
        if (!StringUtils.isEmpty(param.getEs4())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.es4.eq(param.getEs4()));
        }
        if (!StringUtils.isEmpty(param.getEs5())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.es5.eq(param.getEs5()));
        }
        if (!StringUtils.isEmpty(param.getTenantId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.tenantId.eq(param.getTenantId()));
        }
        if (!StringUtils.isEmpty(param.getRemark())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.remark.eq(param.getRemark()));
        }
        if (!StringUtils.isEmpty(param.getCreateUserId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.createUserId.eq(param.getCreateUserId()));
        }
        if (!StringUtils.isEmpty(param.getCreateTime())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.createTime.eq(param.getCreateTime()));
        }
        if (!StringUtils.isEmpty(param.getModifyUserId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.modifyUserId.eq(param.getModifyUserId()));
        }
        if (!StringUtils.isEmpty(param.getModifyTime())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.modifyTime.eq(param.getModifyTime()));
        }
        if (!StringUtils.isEmpty(param.getDeleteFlag())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deleteFlag.eq(param.getDeleteFlag()));
        }
        if (!StringUtils.isEmpty(param.getAuditDataVersion())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.auditDataVersion.eq(param.getAuditDataVersion()));
        }
        return predicate;
    }

    public Predicate where(InvStkDQueryParamVO param) {
        val invStkDO = QInvStkDO.invStkDO;
        val invLotDO = QInvLotDO.invLotDO;
        QInvWhDO invWhDO = QInvWhDO.invWhDO;
        QInvWhAreaDO invWhAreaDO = QInvWhAreaDO.invWhAreaDO;

        Predicate predicate = invStkDO.isNotNull();
        if (!StringUtils.isEmpty(param.getId())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.id.eq(param.getId()));
        }
        if (!(StringUtils.isEmpty(param.getOuIds()) || param.getOuIds().isEmpty())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.ouId.in(param.getOuIds()));
        }
        if(StringUtils.hasLength(param.getDeter2KeyWord())){
            predicate = ExpressionUtils.and(predicate, ExpressionUtils.or(
                    invWhAreaDO.deter2.like("%" + param.getDeter2KeyWord() + "%"),
                    invWhAreaDO.deter2Name.like("%" + param.getDeter2KeyWord() + "%")
            ));
        }

        if (param.getSinFlag() != null && param.getSinFlag()) {
            // 当 过滤已释放标志为 true时，过滤的数据集为  非已释放 的数据
            predicate = ExpressionUtils.and(predicate, invLotDO.sinNo.isNotNull());
        }
        if (param.getSinFlag() != null && !param.getSinFlag()) {
            // 当 过滤已释放标志为 true时，过滤的数据集为  非已释放 的数据
            predicate = ExpressionUtils.and(predicate, invLotDO.sinNo.isNull());
        }
        if (!(StringUtils.isEmpty(param.getBuIds()) || param.getBuIds().isEmpty())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.buId.in(param.getBuIds()));
        }
        if (!StringUtils.isEmpty(param.getItemId())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.itemId.eq(param.getItemId()));
        }
        if (!CollectionUtils.isEmpty(param.getItemIds())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.itemId.in(param.getItemIds()));
        }
        if (!(StringUtils.isEmpty(param.getVariIds()) || param.getVariIds().isEmpty())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.variId.in(param.getVariIds()));
        }
        if (!CollectionUtils.isEmpty(param.getItemCodes())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.itemCode.in(param.getItemCodes()));
        }
        if (!CollectionUtils.isEmpty(param.getWhIds())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.whId.in(param.getWhIds()));
        }
        if (!(StringUtils.isEmpty(param.getPCode()))) {
            predicate = ExpressionUtils.and(predicate, invStkDO.pCode.in(param.getPCode()));
        }
        if (!(StringUtils.isEmpty(param.getPType()))) {
            predicate = ExpressionUtils.and(predicate, invStkDO.pType.in(param.getPType()));
        }
        if (!StringUtils.isEmpty(param.getDeter1())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.deter1.eq(param.getDeter1()));
        }
        if (!StringUtils.isEmpty(param.getDeter2())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.deter2.eq(param.getDeter2()));
        }
        if (!CollectionUtils.isEmpty(param.getDeter2s())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.deter2.in(param.getDeter2s()));
        }
        if (!StringUtils.isEmpty(param.getDeter3())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.deter3.eq(param.getDeter3()));
        }

        if (!(StringUtils.isEmpty(param.getLotNos()) || param.getLotNos().isEmpty())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.lotNo.in(param.getLotNos()));
        }
        if (!StringUtils.isEmpty(param.getLotNo())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.lotNo.like("%" + param.getLotNo() + "%"));
        }
        if (!StringUtils.isEmpty(param.getInDate())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.inDate.eq(param.getInDate()));
        }
        if (!StringUtils.isEmpty(param.getUntilExpireDays())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.untilExpireDays.eq(param.getUntilExpireDays()));
        }
        if (!StringUtils.isEmpty(param.getFressType())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.fressType.eq(param.getFressType()));
        }
        if (!StringUtils.isEmpty(param.getUom())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.uom.eq(param.getUom()));
        }
        if (!StringUtils.isEmpty(param.getUom2())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.uom2.eq(param.getUom2()));
        }
        if (!StringUtils.isEmpty(param.getUomRatio())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.uomRatio.eq(param.getUomRatio()));
        }
        if (!StringUtils.isEmpty(param.getUomRatio2())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.uomRatio2.eq(param.getUomRatio2()));
        }
        if (!StringUtils.isEmpty(param.getOhQty())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.ohQty.eq(param.getOhQty()));
        }
        if (!StringUtils.isEmpty(param.getOhQty2())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.ohQty2.eq(param.getOhQty2()));
        }
        if (!StringUtils.isEmpty(param.getRsvQty())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.rsvQty.eq(param.getRsvQty()));
        }
        if (!StringUtils.isEmpty(param.getRsvQty2())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.rsvQty2.eq(param.getRsvQty2()));
        }
        if (!StringUtils.isEmpty(param.getRsvQty3())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.rsvQty3.eq(param.getRsvQty3()));
        }
        if (!StringUtils.isEmpty(param.getRsvQty4())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.rsvQty4.eq(param.getRsvQty4()));
        }
        if (!StringUtils.isEmpty(param.getLockQty())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.lockQty.eq(param.getLockQty()));
        }
        if (!StringUtils.isEmpty(param.getLockQty2())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.lockQty2.eq(param.getLockQty2()));
        }
        if (!StringUtils.isEmpty(param.getLockQty3())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.lockQty3.eq(param.getLockQty3()));
        }
        if (!StringUtils.isEmpty(param.getLockQty4())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.lockQty4.eq(param.getLockQty4()));
        }
        if (!StringUtils.isEmpty(param.getOwQty())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.owQty.eq(param.getOwQty()));
        }
        if (!StringUtils.isEmpty(param.getOwQty2())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.owQty2.eq(param.getOwQty2()));
        }
        if (!StringUtils.isEmpty(param.getOwQty3())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.owQty3.eq(param.getOwQty3()));
        }
        if (!StringUtils.isEmpty(param.getOwQty4())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.owQty4.eq(param.getOwQty4()));
        }
        if (!StringUtils.isEmpty(param.getAvalQty())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.avalQty.eq(param.getAvalQty()));
        }
        if (!StringUtils.isEmpty(param.getPCode())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.pCode.eq(param.getPCode()));
        }
        if (!StringUtils.isEmpty(param.getPType())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.pType.eq(param.getPType()));
        }
        if (!StringUtils.isEmpty(param.getAvalQty2())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.avalQty2.eq(param.getAvalQty2()));
        }
        if (!StringUtils.isEmpty(param.getUntilExpireDays())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.untilExpireDays.goe(param.getUntilExpireDays()));
        }
        if (!StringUtils.isEmpty(param.getNoStk())) {
            predicate = param.getNoStk() ? ExpressionUtils.and(predicate, null) : ExpressionUtils.and(predicate, invStkDO.ohQty.ne(BigDecimal.ZERO));
        }
        if (!StringUtils.isEmpty(param.getQcStatus())) {
            predicate = ExpressionUtils.and(predicate, invLotDO.qcStatus.eq(param.getQcStatus()).or(invLotDO.qcStatus.isNull()));
        }

        if (!StringUtils.isEmpty(param.getMultiKeywords())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.lotNo.like("%" + param.getMultiKeywords() + "%"));
        }

        if (!StringUtils.isEmpty(param.getPType())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.lotNo.like("%" + param.getPType() + "%"));
        }

        if (!StringUtils.isEmpty(param.getWhType())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.lotNo.like("%" + param.getWhType() + "%"));
        }

        if (!StringUtils.isEmpty(param.getItemType2())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.lotNo.like("%" + param.getItemType2() + "%"));
        }

        return predicate;
    }

    public Predicate findInvStkList(InvStkQueryParamVO param){
        val jpado =  QInvStkDO.invStkDO;
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        if (!StringUtils.isEmpty(param.getOuId())){
            predicate = ExpressionUtils.and(predicate,jpado.ouId.eq(param.getOuId()));
        }
        if (!StringUtils.isEmpty(param.getWhId())){
            predicate = ExpressionUtils.and(predicate,jpado.whId.eq(param.getWhId()));
        }
        if (!CollectionUtils.isEmpty(param.getDeter2List())){
            predicate = ExpressionUtils.and(predicate,jpado.deter2.in(param.getDeter2List()));
        }
        if (!CollectionUtils.isEmpty(param.getItemIdList())){
            predicate = ExpressionUtils.and(predicate,jpado.itemId.in(param.getItemIdList()));
        }
//        List<InvStkRespVO> invStkVOList = jpaQueryFactory.select(jpado).where(predicate).fetch()
//                .stream().map(e -> InvStkConvert.INSTANCE.doToRespVO(e)).collect(Collectors.toList());

        return predicate;
    }

    public PagingVO selectLot(InvStkDQueryParamVO param) {
        val invStkDO = QInvStkDO.invStkDO;
        val invLotDO = QInvLotDO.invLotDO;
        QInvWhDO invWhDO = QInvWhDO.invWhDO;
        QInvWhAreaDO invWhAreaDO = QInvWhAreaDO.invWhAreaDO;
        JPAQuery<InvStkDRespVO> where = jpaQueryFactory.selectDistinct(
                Projections.bean(
                        InvStkDRespVO.class,
                        invStkDO.id,
                        invStkDO.ouId,
                        invStkDO.buId,
                        invStkDO.itemId,
                        invStkDO.variId,
                        invStkDO.whId,
                        invWhDO.whCode,
                        invWhDO.whName,
                        invStkDO.deter1,
                        invStkDO.deter2,
                        invWhAreaDO.deter2Name,
                        invStkDO.deter3,
                        invStkDO.lotNo,
                        invStkDO.createUserId,

                        invStkDO.inDate,
                        invStkDO.fressType,
                        invStkDO.uom,
                        invStkDO.uom2,
                        invStkDO.uomRatio,
                        invStkDO.uomRatio2,
                        invStkDO.ohQty,

                        invStkDO.goodShelve,

                        invStkDO.rsvQty,
                        invStkDO.rsvQty2,

                        invStkDO.lockQty,

                        invStkDO.avalQty,
                        invStkDO.pCode,
                        invStkDO.pType,

                        invStkDO.amt,
                        invStkDO.stkDesc,
                        invStkDO.stkDesc2,
                        invStkDO.srcDocCls,
                        invStkDO.srcDocId,
                        invStkDO.srcDocDid,
                        invStkDO.srcDocCls2,
                        invStkDO.srcDocId2,
                        invStkDO.srcDocDid2,
                        invLotDO.sinNo,
                        invLotDO.sinQty,
                        invLotDO.manuDate,
                        invLotDO.expireDate,
                        invLotDO.untilExpireDays,
                        invLotDO.menuLotNo,
                        invLotDO.expireDays,
                        invLotDO.qcStatus,
                        invLotDO.lotStatus,
                        invLotDO.createTime
                )
        ).from(invStkDO)
                .leftJoin(invLotDO).on(
                        invStkDO.itemId.eq(invLotDO.itemId),
                        invStkDO.lotNo.eq(invLotDO.lotNo),
                        invStkDO.variId.eq(invLotDO.variId).or(invStkDO.variId.isNull().and(invLotDO.variId.isNull())))
                .leftJoin(invWhDO).on(invStkDO.whId.eq(invWhDO.id))
                .leftJoin(invWhAreaDO).on(invStkDO.deter2.eq(invWhAreaDO.deter2)
                        .and(invStkDO.whId.eq(invWhAreaDO.whId)))
                .where(where(param), invStkDO.deleteFlag.eq(0).or(invStkDO.deleteFlag.isNull())
                        .and(invStkDO.lotNo.isNotNull()).and(invStkDO.lotNo.ne("")));
        param.fillOrders(where, jpaQDo);
        param.setPaging(where);
        List<InvStkDRespVO> collect = where.fetch();
        return PagingVO.<InvStkDRespVO>builder()
                .total(where.fetchCount())
                .records(collect)
                .build();
    }

    public Predicate findByAllRpcDtoParam(InvStkAllRpcDtoParam param) {
        val invStkDO = QInvStkDO.invStkDO;
        QInvWhDO invWhDO = QInvWhDO.invWhDO;
        QInvWhAreaDO invWhAreaDO = QInvWhAreaDO.invWhAreaDO;
        Predicate predicate = invStkDO.isNotNull();

        predicate = ExpressionUtils.and(predicate, invStkDO.deter2.ne(UdcEnum.INV_FUNC_TYPE_16.getValueCode()));

        if(!CollectionUtils.isEmpty(param.getInvStkItemUomParams())){
            List<Long> itemIds = param.getInvStkItemUomParams().stream().map(InvStkItemUomRpcDtoParam::getItemId).distinct().collect(Collectors.toList());
            predicate = ExpressionUtils.and(predicate, invStkDO.itemId.in(itemIds));

        }
        if (!StringUtils.isEmpty(param.getId())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.id.eq(param.getId()));
        }
        if (!StringUtils.isEmpty(param.getPType())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.pType.eq(param.getPType()));
        }
        if (!StringUtils.isEmpty(param.getPCode())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.pCode.eq(param.getPCode()));
        }
        if(StringUtils.hasLength(param.getDeter2Type())){
            predicate = ExpressionUtils.and(predicate, invWhAreaDO.deter2Type.eq(param.getDeter2Type()));
        }
        if (!StringUtils.isEmpty(param.getOuId())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.ouId.eq(param.getOuId()));
        }
        if (!(CollectionUtils.isEmpty(param.getOuIds()))) {
            predicate = ExpressionUtils.and(predicate, invStkDO.ouId.in(param.getOuIds()));
        }
        if (!StringUtils.isEmpty(param.getBuId())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.buId.eq(param.getBuId()));
        }

        if (!(StringUtils.isEmpty(param.getVariId()))) {
            predicate = ExpressionUtils.and(predicate, invStkDO.variId.eq(param.getVariId()));
        }
        if (!StringUtils.isEmpty(param.getWhId())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.whId.eq(param.getWhId()));
        }
        if (!(CollectionUtils.isEmpty(param.getWhIds()))) {
            predicate = ExpressionUtils.and(predicate, invStkDO.whId.in(param.getWhIds()));
        }

        if (!StringUtils.isEmpty(param.getDeter2())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.deter2.eq(param.getDeter2()));
        }
        if (!(CollectionUtils.isEmpty(param.getDeter2s()))) {
            predicate = ExpressionUtils.and(predicate, invStkDO.deter2.in(param.getDeter2s()));
        }

        if (!StringUtils.isEmpty(param.getLotNo())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.lotNo.eq(param.getLotNo()));
        }

        if (!(CollectionUtils.isEmpty(param.getLotNos()))) {
            predicate = ExpressionUtils.and(predicate, invStkDO.lotNo.in(param.getLotNos()));
        }

        if (!StringUtils.isEmpty(param.getInDate())) {
            predicate = ExpressionUtils.and(predicate, invStkDO.inDate.eq(param.getInDate()));
        }

        if (!(StringUtils.isEmpty(param.getInDate()))) {
            predicate = ExpressionUtils.and(predicate, invStkDO.inDate.eq(param.getInDate()));
        }

        return predicate;
    }




}
