package com.elitesland.yst.production.inv.infr.repo.whAreaSetting;

import com.elitesland.yst.production.inv.application.facade.vo.SelectOptionParam;
import com.elitesland.yst.production.inv.application.facade.vo.SelectOptionVO;
import com.elitesland.yst.production.inv.application.facade.vo.whAreaSetting.InvWhAreaSettingParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.whAreaSetting.InvWhAreaSettingRespVO;
import com.elitesland.yst.production.inv.domain.entity.whAreaSetting.QInvWhAreaSettingDO;
import com.elitesland.yst.production.inv.dto.invwh.InvWhAreaSettingRpcDTO;
import com.elitesland.yst.production.inv.dto.invwhAreaSetting.InvWhAreaSettingParamRpcDTO;
import com.elitesland.yst.production.inv.infr.dto.InvWhAreaSettingDTO;
import com.elitesland.yst.production.inv.infr.repo.JpaQueryProcInterface;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 功能说明:功能区配置
 * </p>
 *
 * @Author Darren
 * @Date 2022/04/19
 * @Version 1.0
 * @Content:
 */
@Component
@AllArgsConstructor
public class InvWhAreaSettingRepoProc implements JpaQueryProcInterface {
    private final JPAQueryFactory jpaQueryFactory;


    public PagingVO<InvWhAreaSettingDTO> search(InvWhAreaSettingParamVO param) {
        val jpaQDo = QInvWhAreaSettingDO.invWhAreaSettingDO;
        val jpaQuery = jpaQueryFactory.select(
                Projections.bean(
                        InvWhAreaSettingDTO.class,
                        jpaQDo.id,
                        jpaQDo.deter2,
                        jpaQDo.deter2Name,
                        jpaQDo.pType.as("PType"),
                        jpaQDo.whType,
                        jpaQDo.businessChoose,
                        jpaQDo.isZeroWh,
                        jpaQDo.status,
                        jpaQDo.remark,
                        jpaQDo.createUserId,
                        jpaQDo.creator,
                        jpaQDo.createTime,
                        jpaQDo.modifyUserId,
                        jpaQDo.updater,
                        jpaQDo.modifyTime,
                        jpaQDo.deter2Type,
                        jpaQDo.deter2TypeName,
                        jpaQDo.deleteFlag,
                        jpaQDo.tenantId,
                        jpaQDo.auditDataVersion
                )
        ).from(jpaQDo);
        if (param != null) {
            jpaQuery.where(where(param));
            param.fillOrders(jpaQuery, jpaQDo);
            param.setPaging(jpaQuery);
        }
        jpaQuery.where(jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return PagingVO.<InvWhAreaSettingDTO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }

    public JPAQuery<InvWhAreaSettingDTO> select(InvWhAreaSettingParamVO param) {
        val jpaQDo = QInvWhAreaSettingDO.invWhAreaSettingDO;
        val jpaQuery = jpaQueryFactory.select(
                Projections.bean(
                        InvWhAreaSettingDTO.class,
                        jpaQDo.id,
                        jpaQDo.deter2,
                        jpaQDo.deter2Name,
                        jpaQDo.pType.as("PType"),
                        jpaQDo.whType,
                        jpaQDo.deter2Type,
                        jpaQDo.deter2TypeName,
                        jpaQDo.businessChoose,
                        jpaQDo.isZeroWh,
                        jpaQDo.status,
                        jpaQDo.remark,
                        jpaQDo.createUserId,
                        jpaQDo.creator,
                        jpaQDo.createTime,
                        jpaQDo.modifyUserId,
                        jpaQDo.updater,
                        jpaQDo.modifyTime,
                        jpaQDo.deleteFlag,
                        jpaQDo.tenantId,
                        jpaQDo.auditDataVersion
                )
        ).from(jpaQDo);
        if (Objects.nonNull(param)) {
            jpaQuery.where(where(param));
        }
        jpaQuery.where(jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return jpaQuery;
    }

    public List<SelectOptionVO> listDeter2Type(SelectOptionParam param){
        val jpaQDo = QInvWhAreaSettingDO.invWhAreaSettingDO;
        JPAQuery<SelectOptionVO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                SelectOptionVO.class,
                jpaQDo.id,
                jpaQDo.deter2Type.as("code"),
                jpaQDo.deter2TypeName.as("value")
                )
        ).from(jpaQDo);
        if(Objects.nonNull(param)){
            jpaQuery.where(whereSelect(param));
        }
        jpaQuery.where(jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull())
        ,jpaQDo.status.eq("ACTIVE"));
        return jpaQuery.fetch();
    }

    public Predicate whereSelect(SelectOptionParam param){
        val jpaQDo = QInvWhAreaSettingDO.invWhAreaSettingDO;
        Predicate predicate = jpaQDo.isNotNull();
        if (StringUtils.hasLength(param.getCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter2Type.eq(param.getCode()));
        }
        if (StringUtils.hasLength(param.getValue())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter2TypeName.eq(param.getValue()));
        }
        if (StringUtils.hasLength(param.getWhType())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whType.like("%" + param.getWhType() + "%"));
        }
        if (StringUtils.hasLength(param.getKeyWords())) {
            predicate = ExpressionUtils.and(
                    predicate, ExpressionUtils.anyOf(
                            jpaQDo.deter2TypeName.like('%' + param.getKeyWords() + '%'),
                            jpaQDo.deter2Type.like('%' + param.getKeyWords() + '%')
                    ));
        }
        return predicate;
    }

    public Predicate whereParamRpcDto(InvWhAreaSettingParamRpcDTO param){
        val jpaQDo = QInvWhAreaSettingDO.invWhAreaSettingDO;
        Predicate predicate = jpaQDo.isNotNull();
        if (! CollectionUtils.isEmpty(param.getDeter2Types())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter2Type.in(param.getDeter2Types()));
        }
        if (! CollectionUtils.isEmpty(param.getIds())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.id.in(param.getIds()));
        }
        if (! CollectionUtils.isEmpty(param.getWhTypes())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whType.in(param.getWhTypes()));
        }
        if (Objects.nonNull(param.getBusinessChoose())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.businessChoose.eq(param.getBusinessChoose()));
        }
        if (Objects.nonNull(param.getIsZeroWh())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.isZeroWh.eq(param.getIsZeroWh()));
        }
        if (StringUtils.hasLength(param.getStatus())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.status.eq(param.getStatus()));
        }
        return predicate;
    }

    public Predicate where(InvWhAreaSettingParamVO param) {
        val jpaQDo = QInvWhAreaSettingDO.invWhAreaSettingDO;
        Predicate predicate = jpaQDo.isNotNull();

        if (StringUtils.hasLength(param.getDeter2Type())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter2Type.eq(param.getDeter2Type()));
        }
        if (StringUtils.hasLength(param.getDeter2TypeName())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter2TypeName.eq(param.getDeter2TypeName()));
        }

        if(StringUtils.hasLength(param.getKeyWords())){
            predicate = ExpressionUtils.and(
                    predicate, ExpressionUtils.anyOf(
                            jpaQDo.deter2Type.like('%' + param.getKeyWords() + '%'),
                            jpaQDo.deter2TypeName.like('%' + param.getKeyWords() + '%')
                    ));
        }

        if (!StringUtils.isEmpty(param.getId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.id.eq(param.getId()));
        }
        if (!CollectionUtils.isEmpty(param.getIdList())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.id.in(param.getIdList()));
        }
        if (!StringUtils.isEmpty(param.getKeyword())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter2.like("%" + param.getKeyword() + "%").or(jpaQDo.deter2Name.like("%" + param.getKeyword() + "%")));
        }

        if (!StringUtils.isEmpty(param.getDeter2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter2.eq(param.getDeter2()));
        }
        if (!CollectionUtils.isEmpty(param.getDeter2List())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter2.in(param.getDeter2List()));
        }
        if (!StringUtils.isEmpty(param.getDeter2Name())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter2Name.eq(param.getDeter2Name()));
        }

        if (!StringUtils.isEmpty(param.getPType())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.pType.eq(param.getPType()));
        }
        if (!StringUtils.isEmpty(param.getWhType())) {
            predicate = StringUtils.isEmpty(param.getWhType()) ? predicate :
                    ExpressionUtils.and(predicate, Expressions.booleanTemplate("FIND_IN_SET({0},{1}) >0", param.getWhType(), jpaQDo.whType));
        }
        if (!CollectionUtils.isEmpty(param.getWhTypes())) {
            for (String whTypeCode : param.getWhTypes()) {
                predicate = StringUtils.isEmpty(whTypeCode) ? predicate :
                        ExpressionUtils.and(predicate, Expressions.booleanTemplate("FIND_IN_SET({0},{1}) >0", whTypeCode, jpaQDo.whType));
            }
        }
        if (!StringUtils.isEmpty(param.getBusinessChoose())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.businessChoose.eq(param.getBusinessChoose()));
        }
        if (!StringUtils.isEmpty(param.getIsZeroWh())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.isZeroWh.eq(param.getIsZeroWh()));
        }
        if (!StringUtils.isEmpty(param.getStatus())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.status.eq(param.getStatus()));
        }

        return predicate;
    }


    public JPAUpdateClause updateDeleteFlagByIds(Integer deleteFlag, List<Long> idList) {
        val jpaQDo = QInvWhAreaSettingDO.invWhAreaSettingDO;
        Predicate predicate = jpaQDo.isNotNull();
        return jpaQueryFactory.update(jpaQDo)
                .set(jpaQDo.deleteFlag, deleteFlag)
                .where(ExpressionUtils.and(predicate, jpaQDo.id.in(idList)));
    }

    public List<InvWhAreaSettingRespVO> findByDeter2Types(List<String> deter2Types){
        val jpaQDo = QInvWhAreaSettingDO.invWhAreaSettingDO;
        val jpaQuery = jpaQueryFactory.select(
                Projections.bean(
                        InvWhAreaSettingRespVO.class,
                        jpaQDo.id,
                        jpaQDo.deter2,
                        jpaQDo.pType.as("PType"),
                        jpaQDo.whType,
                        jpaQDo.deter2Type,
                        jpaQDo.deter2TypeName,
                        jpaQDo.businessChoose,
                        jpaQDo.isZeroWh,
                        jpaQDo.status,
                        jpaQDo.remark,
                        jpaQDo.createUserId,
                        jpaQDo.creator,
                        jpaQDo.createTime,
                        jpaQDo.modifyUserId,
                        jpaQDo.updater,
                        jpaQDo.modifyTime,
                        jpaQDo.deleteFlag,
                        jpaQDo.tenantId,
                        jpaQDo.auditDataVersion
                )
        ).from(jpaQDo);
        Predicate predicate1 = jpaQDo.deter2Type.in(deter2Types);
        Predicate predicate2 = jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull());
        jpaQuery.where(ExpressionUtils.allOf(predicate1,predicate2));
        return jpaQuery.fetch();

    }

    public List<InvWhAreaSettingRpcDTO> findWhAreaSettingRpcDTO(InvWhAreaSettingParamRpcDTO param){
        val jpaQDo = QInvWhAreaSettingDO.invWhAreaSettingDO;
        val jpaQuery = jpaQueryFactory.select(
                Projections.bean(
                        InvWhAreaSettingRpcDTO.class,
                        jpaQDo.id,
                        jpaQDo.whType,
                        jpaQDo.deter2Type,
                        jpaQDo.deter2TypeName,
                        jpaQDo.businessChoose,
                        jpaQDo.isZeroWh,
                        jpaQDo.status
                )
        ).from(jpaQDo);
        if (Objects.nonNull(param)) {
            jpaQuery.where(whereParamRpcDto(param));
        }
        jpaQuery.where(jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return jpaQuery.fetch();
    }

}
