package com.elitesland.yst.production.inv.provider;

import cn.hutool.core.bean.BeanUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitesland.yst.production.inv.Application;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhSaveVO;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.PurDubbleService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvWhAreaService;
import com.elitesland.yst.production.inv.application.service.InvWhService;
import com.elitesland.yst.production.inv.application.service.InvWhTreeService;
import com.elitesland.yst.production.inv.domain.entity.invwh.InvWhDO;
import com.elitesland.yst.production.inv.domain.service.InvWhDomainService;
import com.elitesland.yst.production.inv.dto.invwh.*;
import com.elitesland.yst.production.inv.utils.BeanCopyUtil;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddrAddressRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddrDetailsRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgEmpRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgEmpRpcDtoParam;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author jeesie.jiang
 * @since 2021-01-29 14:00:10
 */
@SuppressWarnings("ALL")
@AllArgsConstructor

@Slf4j
@RestController
@RequestMapping(Application.URI_PREFIX + InvWhProvider.PATH)
public class InvWhProviderImpl implements InvWhProvider {
    private final InvWhDomainService invWhDomainService;

    private final OrgOutService orgOutService;

    private final SystemService systemService;


    private final InvWhAreaService invWhAreaService;

    private final InvWhService invWhService;
    private final InvWhTreeService invWhTreeService;
    private final PurDubbleService purDubbleService;





    private void translateWhRpcDTO(List<InvWhRpcDTO> invWhRpcDTOS) {
        //查询地址、客户、公司信息
        List<Long> ouIds = invWhRpcDTOS.stream().map(InvWhRpcDTO::getOuId).distinct().collect(Collectors.toList());
        // 更具OUIDS查询公司数据
        List<OrgOuRpcDTO> orgOuVOS = orgOutService.findOuByIds(ouIds);
        invWhRpcDTOS.forEach(VO -> {
            //根据地址号查询地址信息，目前没有批量查询接口，支撑域建议分页这种看是否可以去掉不展示地址信息，可在详情展示
            List<OrgAddrAddressRpcDTO> orgAddrAddressVOS = findOrgAddrAddressList(VO.getAddrNo());
            if (!CollectionUtils.isEmpty(orgAddrAddressVOS)) {
                OrgAddrAddressRpcDTO orgAddrAddressVO = orgAddrAddressVOS.get(0);
                String email = "";
                for (OrgAddrAddressRpcDTO address : orgAddrAddressVOS) {
                    email += address.getEmail() + ";";
                }
                VO.setCountry(orgAddrAddressVO.getCountry());
                VO.setProvince(orgAddrAddressVO.getProvince());
                VO.setCity(orgAddrAddressVO.getCity());
                VO.setCounty(orgAddrAddressVO.getCounty());
                VO.setCountryName(orgAddrAddressVO.getCountry());
                VO.setProvinceName(orgAddrAddressVO.getProvinceName());
                VO.setCityName(orgAddrAddressVO.getCityName());
                VO.setCountyName(orgAddrAddressVO.getCountyName());
                VO.setDetailaddr(orgAddrAddressVO.getDetailAddr());
                VO.setEmail(email);
                VO.setContPerson(orgAddrAddressVO.getContPerson());
                VO.setTel(orgAddrAddressVO.getTel());
            }
            if (!CollectionUtils.isEmpty(orgOuVOS)) {
                Optional<OrgOuRpcDTO> first1 = orgOuVOS.stream().filter(a -> a.getId().equals(VO.getOuId())).findFirst();
                if (first1.isPresent()) {
                    OrgOuRpcDTO orgOuVO = first1.get();
                    VO.setOuName(orgOuVO.getOuName());
                    VO.setOuCode(orgOuVO.getOuCode());
                    VO.setOuCurr(orgOuVO.getOuCurr());
                }
            }
        });
    }


    /**
     * 根据地址号获取对应的地址信息集合
     *
     * @param addrNo 地址号
     * @return 地址号地址信息对象集合
     */
    private List<OrgAddrAddressRpcDTO> findOrgAddrAddressList(Long addrNo) {
        OrgAddrDetailsRpcDTO orgAddrDetailsRpcDto = orgOutService.findRpcDtoByAddrNo(addrNo);
        if (Objects.isNull(orgAddrDetailsRpcDto)) {
            return Lists.newArrayList();
        }
        return orgAddrDetailsRpcDto.getOrgAddrAddressVos();
    }

    @Override
    public ApiResult<List<InvWhDetailRpcDTO>> findWhAreaDTOByParam(InvWhRpcDtoParam param) {
        log.info("查询仓库及库区，时间：{}，入参：{}", LocalDateTime.now(), param);
        try {
            if(param == null){
                throw new BusinessException("参数校验不通过，参数值不能为空");
            }
            List<InvWhDetailRpcDTO> rpcDTOS = invWhDomainService.findWhRpcDTOByParam(param);
            translateWh(rpcDTOS);
            log.info("查询仓库及库区结果为：{}", rpcDTOS);
            return ApiResult.ok(rpcDTOS);
        } catch (BusinessException e) {
            log.error("findWhDTOByParam{}", e);
            return ApiResult.fail(e.getMessage());
        }
    }

    @Override
    public ApiResult<List<InvWhRpcDTO>> findWhDTOByParam(InvWhRpcDtoParam param) {
        try {
            log.info("查询仓库，时间：{}，入参：{}", LocalDateTime.now(), param);
            if(param == null){
                throw new BusinessException("参数校验不通过，参数值不能为空");
            }
            ArrayList<InvWhRpcDTO> results = new ArrayList<>();
            List<InvWhRpcDTO> whRpcDTOS = invWhDomainService.findWhPartRpcDTOByParam(param);
            Map<Long, List<InvWhRpcDTO>> map = whRpcDTOS.stream().collect(Collectors.groupingBy(InvWhRpcDTO::getId));
            for(val wh : map.entrySet()){
                results.add(wh.getValue().get(0));
            }
            if(! CollectionUtils.isEmpty(results)) {
                translateWhRpcDTO(results);
            }
            log.info("仓库查询结果为：{}", results);
            return ApiResult.ok(results);
        } catch (BusinessException e) {
            log.error("findWhPartDTOByParam error:", e);
            return ApiResult.fail(e.getMessage());
        }
    }


    @Override
    @SysCodeProc
    public List<InvWhRpcDTO> findWhByDeliveryParam(InvWhDeliveryRpcDtoParam param) {
        try {
            log.info("根据配送范围查询仓库，时间：{}，入参：{}", LocalDateTime.now(), param);
            List<InvWhDeliveryRpcDTO> whRpcDTOByDelivery = invWhDomainService.findWhRpcDTOByDelivery(param);
            //查询全国仓仓库
            if(StringUtils.isNotEmpty(param.getPcode()) || StringUtils.isNotEmpty(param.getCcode()) ||
                    StringUtils.isNoneEmpty(param.getCcode())) {
                List<InvWhDeliveryRpcDTO> byAllArea = invWhDomainService.findWhRpcDTOByAllArea(param);
                whRpcDTOByDelivery.addAll(byAllArea);
            }
            ArrayList<InvWhDeliveryRpcDTO> whDeliveryRpcDTOS = whRpcDTOByDelivery.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() ->
                    new TreeSet<>(Comparator.comparing(f -> f.getWhId()))), ArrayList::new));
            List<Long> whIds = whDeliveryRpcDTOS.stream().map(InvWhDeliveryRpcDTO::getWhId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(whIds)) {
                ArrayList<InvWhRpcDTO> whPartRpcDTOS = new ArrayList<>();
                return whPartRpcDTOS;
            }
            List<InvWhAreaRpcDTO> invWhAreaRpcDTOS = invWhAreaService.findWhAreaRpcDTOByWhIds(whIds);
            List<InvWhRpcDTO> invWhRpcDTOS = whDeliveryRpcDTOS.stream().map(v -> {
                InvWhRpcDTO invWhRpcDTO = new InvWhRpcDTO();
                invWhRpcDTO.setId(v.getWhId());
                if (!CollectionUtils.isEmpty(invWhAreaRpcDTOS)) {
                    List<InvWhAreaRpcDTO> whAreaRpcDTOS = invWhAreaRpcDTOS.stream()
                            .filter(i -> i.getWhId().equals(v.getWhId()))
                            .collect(Collectors.toList());
                    invWhRpcDTO.setInvWhAreaRespVOList(whAreaRpcDTOS);
                }
                invWhRpcDTO.setWhType(v.getWhType());
                invWhRpcDTO.setWhCode(v.getWhCode());
                invWhRpcDTO.setWhName(v.getWhName());
                invWhRpcDTO.setAddrNo(v.getAddrNo());
                invWhRpcDTO.setOuId(v.getOuId());
                invWhRpcDTO.setThirdplFlag(v.getThirdplFlag());
                invWhRpcDTO.setErpCode(v.getErpCode());
                invWhRpcDTO.setEs1(v.getEs1());
                return invWhRpcDTO;
            }).collect(Collectors.toList());
            this.translate2(invWhRpcDTOS);
            log.info("根据配送范围查询仓库结果：{}",invWhRpcDTOS);
            return invWhRpcDTOS;
        } catch (BusinessException e) {
            log.error("findWhDeliveryDTOByParam", e);
            throw new BusinessException(ApiCode.FAIL, e.getMessage());
        }
    }

    @Override
    public ApiResult<String> createTreeOne(InvWhSaveDTO param) {
        InvWhSaveVO invWhSaveVO = BeanUtil.copyProperties(param, InvWhSaveVO.class);
        Long treeOne = invWhTreeService.createTreeOne(invWhSaveVO);
        if(StringUtils.isNotEmpty(treeOne.toString())){
            return ApiResult.ok(treeOne.toString());
        }else {
            return ApiResult.fail();
        }
    }


    private Boolean existVerify(Long id, String whCode) {
        InvWhParamVO param = new InvWhParamVO();
        param.setWhCode(whCode);
        List<InvWhRespVO> invWhRespVOList = invWhDomainService.select(param);
        return invWhRespVOList.stream().anyMatch(w -> !w.getId().equals(id));
    }

    private void translate2(List<InvWhRpcDTO> invWhPartRpcDtoVOList) {
        //查询地址、客户、公司信息
        List<Long> ouIds = invWhPartRpcDtoVOList.stream().map(InvWhRpcDTO::getOuId).distinct().collect(Collectors.toList());
        // 更具OUIDS查询公司数据
        List<OrgOuRpcDTO> orgOuVOS = orgOutService.findOuByIds(ouIds);
        invWhPartRpcDtoVOList.forEach(VO -> {
            Optional<OrgOuRpcDTO> first1 = orgOuVOS.stream().filter(a -> a.getId().equals(VO.getOuId())).findFirst();
            if (first1.isPresent()) {
                OrgOuRpcDTO orgOuVO = first1.get();
                VO.setOuName(orgOuVO.getOuName());
                VO.setOuCode(orgOuVO.getOuCode());
                VO.setOuCurr(orgOuVO.getOuCurr());
            }

        });
    }


    private void translateWh(List<InvWhDetailRpcDTO> invWhDetailRpcDTOList) {
        //查询地址、客户、公司信息
        List<Long> ouIds = invWhDetailRpcDTOList.stream().map(InvWhDetailRpcDTO::getOuId).distinct().collect(Collectors.toList());
        // 更具OUIDS查询公司数据
        List<OrgOuRpcDTO> orgOuVOS = orgOutService.findOuByIds(ouIds);
        invWhDetailRpcDTOList.forEach(VO -> {
            //根据地址号查询地址信息，目前没有批量查询接口，支撑域建议分页这种看是否可以去掉不展示地址信息，可在详情展示
            List<OrgAddrAddressRpcDTO> orgAddrAddressVOS = findOrgAddrAddressList(VO.getAddrNo());
            if (!CollectionUtils.isEmpty(orgAddrAddressVOS)) {
                OrgAddrAddressRpcDTO orgAddrAddressVO = orgAddrAddressVOS.get(0);
                String email = "";
                for (OrgAddrAddressRpcDTO address : orgAddrAddressVOS) {
                    email += address.getEmail() + ";";
                }
                VO.setCountry(orgAddrAddressVO.getCountry());
                VO.setProvince(orgAddrAddressVO.getProvince());
                VO.setCity(orgAddrAddressVO.getCity());
                VO.setCounty(orgAddrAddressVO.getCounty());
                VO.setCountryName(orgAddrAddressVO.getCountry());
                VO.setProvinceName(orgAddrAddressVO.getProvinceName());
                VO.setCityName(orgAddrAddressVO.getCityName());
                VO.setCountyName(orgAddrAddressVO.getCountyName());
                VO.setDetailaddr(orgAddrAddressVO.getDetailAddr());
                VO.setEmail(email);
                VO.setContPerson(orgAddrAddressVO.getContPerson());
                VO.setTel(orgAddrAddressVO.getTel());
            }
            if (!CollectionUtils.isEmpty(orgOuVOS)) {
                Optional<OrgOuRpcDTO> first1 = orgOuVOS.stream().filter(a -> a.getId().equals(VO.getOuId())).findFirst();
                if (first1.isPresent()) {
                    OrgOuRpcDTO orgOuVO = first1.get();
                    VO.setOuName(orgOuVO.getOuName());
                    VO.setOuCode(orgOuVO.getOuCode());
                    VO.setOuCurr(orgOuVO.getOuCurr());
                }
            }

        });
    }


    public void update(InvWhDO invWhDO) {
        Optional<InvWhDO> optional = invWhDomainService.findById(invWhDO.getId());
        if (optional.isPresent()) {
            BeanCopyUtil.beanCopyWithIngore(invWhDO, optional.get(), BeanCopyUtil.getNullAndIgnorePropertyNames(invWhDO));
            invWhDomainService.saveInvWh(invWhDO);
        } else {
            throw new BusinessException(ApiCode.FAIL, "修改失败，数据不存在" + invWhDO.getId());
        }
    }


    private void translateWhArea(List<InvWhAreaRespVO> invWhAreaRespVOS, List<InvWhRespVO> invWhRespVOList) {
        List<Long> custIds = invWhAreaRespVOS.stream().filter(VO ->
                VO.getPType() != null && VO.getPCode() != null && VO.getPType().equals(UdcEnum.INV_PARTNER_TYPE_CUST.getValueCode()))
                .map(InvWhAreaRespVO::getEs1).distinct().map(Long::valueOf).collect(Collectors.toList());
        List<Long> suppIds = invWhAreaRespVOS.stream().filter(VO ->
                VO.getPType() != null && VO.getPCode() != null && VO.getPType().equals(UdcEnum.INV_PARTNER_TYPE_SUPP.getValueCode()))
                .map(InvWhAreaRespVO::getEs1).distinct().map(Long::valueOf).collect(Collectors.toList());
        List<Long> empIds = invWhAreaRespVOS.stream().filter(VO ->
                VO.getPType() != null && VO.getPCode() != null && VO.getPType().equals(UdcEnum.INV_PARTNER_TYPE_EMP.getValueCode()))
                .map(InvWhAreaRespVO::getEs1).distinct().map(Long::valueOf).collect(Collectors.toList());
        //  List<OrgCustVO> custVOS = Collections.emptyList();
        List<PurSuppBaseRpcDTO> suppRespVOS = purDubbleService.findSuppByIdBatch(suppIds);
        OrgEmpRpcDtoParam empParam = new OrgEmpRpcDtoParam();
        empParam.setEmpIds(empIds);
        List<OrgEmpRpcDTO> empVOS = orgOutService.findEmpDtoByParam(empParam);
        invWhAreaRespVOS.forEach(VO -> {
                    invWhRespVOList.stream().filter(record -> VO.getWhId().equals(record.getId())).findAny().ifPresent(
                            VO::setInvWhRespVO
                    );
                    if (VO.getPType() != null && VO.getPCode() != null) {
                        if (UdcEnum.INV_PARTNER_TYPE_CUST.getValueCode().equals(VO.getPType())) {
                           /* Optional<OrgCustVO> first = custVOS.stream().filter(a -> a.getId().toString().equals(VO.getEs1())).findFirst();
                            first.ifPresent(orgCustVO -> {
                                VO.setPName(orgCustVO.getCustName());
                            });*/
                        } else if (UdcEnum.INV_PARTNER_TYPE_SUPP.getValueCode().equals(VO.getPType())) {
                            Optional<PurSuppBaseRpcDTO> first = suppRespVOS.stream().filter(a -> a.getId().toString().equals(VO.getEs1())).findFirst();
                            first.ifPresent(suppRespVO -> {
                                VO.setPName(suppRespVO.getSuppName());
                            });
                        } else {
                            Optional<OrgEmpRpcDTO> first = empVOS.stream().filter(a -> a.getId().toString().equals(VO.getEs1())).findFirst();
                            first.ifPresent(empVO -> {
                                VO.setPName(empVO.getEmpName());
                            });
                        }
                    }
                }
        );
    }


}

