package com.elitesland.yst.production.inv.utils;

import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.springframework.util.StringUtils;

import java.util.List;

public class CustomWriteCellValue implements CellWriteHandler {

    public CustomWriteCellValue() {
    }

    @Override
    public void beforeCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Head head, Integer columnIndex, Integer relativeRowIndex, Boolean isHead) {

    }

    @Override
    public void afterCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Cell cell, Head head,
                                Integer relativeRowIndex, Boolean isHead) {


    }

    @Override
    public void afterCellDataConverted(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, CellData cellData, Cell cell, Head head, Integer integer, Boolean aBoolean) {

    }

    @Override
    public void afterCellDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, List<CellData> cellDataList, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
        CellType cellTypeEnum = cell.getCellTypeEnum();
        //单元格为数值和string类型
        String stringCellValue = "";
        if(CellType.NUMERIC.name().equals(cellTypeEnum.name())){
            stringCellValue = String.valueOf(cell.getNumericCellValue());
        }else {
            stringCellValue = cell.getStringCellValue();
        }
        if(!StringUtils.isEmpty(stringCellValue) && ("0".equals(stringCellValue) || "0%".equals(stringCellValue) || "0.0".equals(stringCellValue))){
            cell.setCellValue("");
        }
    }
}
