package com.elitesland.yst.production.inv.utils;

import com.alibaba.excel.util.StringUtils;
import com.alibaba.excel.util.StyleUtil;
import com.alibaba.excel.write.handler.RowWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import org.apache.poi.ss.usermodel.*;

import java.util.Iterator;

public class RptCustomWriterStyle implements RowWriteHandler {
    @Override
    public void beforeRowCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Integer integer, Integer integer1, Boolean aBoolean) {

    }

    @Override
    public void afterRowCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Integer integer, Boolean aBoolean) {
    }

    @Override
    public void afterRowDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Integer integer, Boolean aBoolean) {
        String value=row.getCell(0).getStringCellValue();
        boolean existed = (StringUtils.isEmpty(value) && (value.contains("汇总")||value.contains("合计")));
        if(existed){
            WriteCellStyle writeCellStyle=new WriteCellStyle();
            writeCellStyle.setFillForegroundColor(IndexedColors.PALE_BLUE.index);
            writeCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            WriteFont font=new WriteFont();
            font.setColor(IndexedColors.BLACK.index);
            font.setFontHeightInPoints((short)10);
            font.setFontName("Arial");
            font.setBold(true);
            writeCellStyle.setWriteFont(font);

            CellStyle customStyle= StyleUtil.buildContentCellStyle(writeSheetHolder.getSheet().getWorkbook(),writeCellStyle);
            customStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            Iterator<Cell> it=row.cellIterator();
            while(it.hasNext()) {it.next().setCellStyle(customStyle);}
        }
    }
//
//    @Override
//    public void beforeCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Head head, Integer integer, Integer integer1, Boolean aBoolean) {
//    }
//
//    @Override
//    public void afterCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Cell cell, Head head, Integer integer, Boolean aBoolean) {
//    }
//
//    @Override
//    public void afterCellDataConverted(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, CellData cellData, Cell cell, Head head, Integer integer, Boolean aBoolean) {
//        int rowIndex=cell.getRowIndex();
//        int columnIndex=cell.getColumnIndex();
//        String value=cell.getStringCellValue();
//
//
//        if(value!=null && value.contains("汇总")) {
////            Row row=cell.getRow();
//            var workbook = writeSheetHolder.getSheet().getWorkbook();
//            var style = workbook.createCellStyle();
//            style.setFillForegroundColor(IndexedColors.DARK_BLUE.getIndex());
//            Font font = workbook.createFont();
//            font.setBold(true);
//            style.setFont(font);
////            row.setRowStyle(style);
////            cell.getRow().setRowStyle(style);
//            cell.setCellStyle(style);
//        }
//    }
//
//    @Override
//    public void afterCellDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, List<CellData> list, Cell cell, Head head, Integer integer, Boolean aBoolean) {
//    }
}
