/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.out;

import com.alibaba.excel.util.CollectionUtils;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.req.SysCurrencyQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitescloud.cloudt.system.provider.extend.SysCurrencyRpcService;
import com.elitesland.yst.production.inv.application.facade.vo.InvParentParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.OrgRespVO;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.PurDubbleService;
import com.elitesland.yst.production.inv.utils.InvPTypeEnum;
import com.elitesland.yst.production.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddrDetailsRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddressRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgBuDetailsRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgBuRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgEmpRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgAddrQueryRpcParam;
import com.elitesland.yst.production.support.provider.org.param.OrgAddrRpcSaveParam;
import com.elitesland.yst.production.support.provider.org.param.OrgAddressRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.param.OrgBuRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.param.OrgBuRpcSaveParam;
import com.elitesland.yst.production.support.provider.org.param.OrgBuRpcSaveResult;
import com.elitesland.yst.production.support.provider.org.param.OrgEmpRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.param.OrgOuRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.service.OrgAddrRpcService;
import com.elitesland.yst.production.support.provider.org.service.OrgBuRpcService;
import com.elitesland.yst.production.support.provider.org.service.OrgEmpRpcService;
import com.elitesland.yst.production.support.provider.org.service.OrgOuRpcService;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class OrgOutServiceImpl
implements OrgOutService {
    private static final Logger log = LoggerFactory.getLogger(OrgOutServiceImpl.class);
    private final OrgOuRpcService orgOuRpcService;
    private final OrgEmpRpcService orgEmpRpcService;
    private final OrgBuRpcService orgBuRpcService;
    private final OrgAddrRpcService orgAddrRpcService;
    private final SysCurrencyRpcService sysCurrencyRpcService;
    private final PurDubbleService purDubbleService;

    @Override
    public OrgOuRpcDTO findOuById(Long ouId) {
        log.info("\u8c03\u7528\u652f\u6491\u57df-\u6839\u636e\u516c\u53f8ID\u83b7\u53d6\u516c\u53f8\u4fe1\u606f\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)ouId);
        OrgOuRpcDtoParam param = new OrgOuRpcDtoParam();
        param.setOuIds(Collections.singletonList(ouId));
        try {
            List orgOuVOS = this.orgOuRpcService.findOuDtoByParam(param);
            if (orgOuVOS != null && orgOuVOS.size() > 0) {
                return (OrgOuRpcDTO)orgOuVOS.get(0);
            }
        }
        catch (Exception e) {
            log.error("findOuById error:", (Throwable)e);
        }
        return null;
    }

    @Override
    public OrgOuRpcDTO findOuByOuCode(String ouCode) {
        log.info("\u8c03\u7528\u652f\u6491\u57df-\u6839\u636e\u516c\u53f8code\u83b7\u53d6\u516c\u53f8\u4fe1\u606f\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)ouCode);
        OrgOuRpcDtoParam param = new OrgOuRpcDtoParam();
        param.setOuCodes(Collections.singletonList(ouCode));
        try {
            List orgOuVOS = this.orgOuRpcService.findOuDtoByParam(param);
            if (orgOuVOS != null && orgOuVOS.size() > 0) {
                return (OrgOuRpcDTO)orgOuVOS.get(0);
            }
        }
        catch (Exception e) {
            log.error("findOuByOuCode error:", (Throwable)e);
        }
        return null;
    }

    @Override
    public OrgEmpRpcDTO findEmpById(Long empId) {
        log.info("\u8c03\u7528\u652f\u6491\u57df-\u6839\u636e\u5458\u5de5ID\u83b7\u53d6\u5458\u5de5\u4fe1\u606f\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)empId);
        OrgEmpRpcDtoParam param = new OrgEmpRpcDtoParam();
        param.setEmpIds(Collections.singletonList(empId));
        try {
            List emps = this.orgEmpRpcService.findEmpDtoByParam(param);
            if (emps != null && emps.size() > 0) {
                return (OrgEmpRpcDTO)emps.get(0);
            }
        }
        catch (Exception e) {
            log.error("findEmpById error:", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<OrgOuRpcDTO> findOuByIds(List<Long> ouIds) {
        log.info("\u8c03\u7528\u652f\u6491\u57df-\u6839\u636e\u516c\u53f8ID\u96c6\u5408\u83b7\u53d6\u516c\u53f8\u4fe1\u606f\u5217\u8868\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), ouIds);
        if (CollectionUtils.isEmpty(ouIds)) {
            return Collections.emptyList();
        }
        OrgOuRpcDtoParam param = new OrgOuRpcDtoParam();
        param.setOuIds(ouIds);
        try {
            List ous = this.orgOuRpcService.findOuDtoByParam(param);
            if (!CollectionUtils.isEmpty((Collection)ous)) {
                return ous;
            }
        }
        catch (Exception e) {
            log.error("findOuByIds error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<OrgOuRpcDTO> findOuByCodes(List<String> ouCodes) {
        log.info("\u8c03\u7528\u652f\u6491\u57df-\u6839\u636e\u516c\u53f8\u7f16\u53f7\u96c6\u5408\u83b7\u53d6\u516c\u53f8\u4fe1\u606f\u5217\u8868\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), ouCodes);
        OrgOuRpcDtoParam param = new OrgOuRpcDtoParam();
        param.setOuCodes(ouCodes);
        try {
            List ous = this.orgOuRpcService.findOuDtoByParam(param);
            if (!CollectionUtils.isEmpty((Collection)ous)) {
                return ous;
            }
        }
        catch (Exception e) {
            log.error("findOuByCodes error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<OrgOuRpcDTO> selectBaseByOuCodes(List<String> ouCodes) {
        log.info("\u8c03\u7528\u652f\u6491\u57df-\u6839\u636e\u516c\u53f8\u7f16\u53f7\u96c6\u5408\u83b7\u53d6\u516c\u53f8\u4fe1\u606f\u5217\u8868\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), ouCodes);
        OrgOuRpcDtoParam param = new OrgOuRpcDtoParam();
        param.setOuCodes(ouCodes);
        try {
            List ous = this.orgOuRpcService.findOuDtoByParam(param);
            if (!CollectionUtils.isEmpty((Collection)ous)) {
                return ous;
            }
        }
        catch (Exception e) {
            log.error("selectBaseByOuCodes error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<OrgOuRpcDTO> findOuDtoByParam(OrgOuRpcDtoParam param) {
        try {
            List ouDtoByParam = this.orgOuRpcService.findOuDtoByParam(param);
            if (!CollectionUtils.isEmpty((Collection)ouDtoByParam)) {
                return ouDtoByParam;
            }
        }
        catch (Exception e) {
            log.error("findAllEmpsByIdIn error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<OrgEmpRpcDTO> findEmpDtoByParam(OrgEmpRpcDtoParam param) {
        log.info("\u67e5\u8be2\u5458\u5de5\u65b9\u6cd5\u5f00\u59cb\uff1a{}", (Object)param);
        try {
            List empDtoByParam = this.orgEmpRpcService.findEmpDtoByParam(param);
            if (!CollectionUtils.isEmpty((Collection)empDtoByParam)) {
                return empDtoByParam;
            }
        }
        catch (Exception e) {
            log.error("findAllEmpsByIdIn error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<Long> findBuIdsByUserId(Long userId) {
        try {
            List buIdsByUserId = this.orgBuRpcService.findBuIdsByUserId(userId);
            if (!CollectionUtils.isEmpty((Collection)buIdsByUserId)) {
                return buIdsByUserId;
            }
        }
        catch (Exception e) {
            log.error("findAllEmpsByIdIn error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<Long> findBuIdsByUsername(String username) {
        try {
            List buIdsByUserId = this.orgBuRpcService.findBuIdsByUsername(username);
            if (!CollectionUtils.isEmpty((Collection)buIdsByUserId)) {
                return buIdsByUserId;
            }
        }
        catch (Exception e) {
            log.error("findAllEmpsByIdIn error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<OrgBuRpcDTO> findBuIdsByUsername(OrgBuRpcDtoParam param) {
        try {
            List buDtoByParam = this.orgBuRpcService.findBuDtoByParam(param);
            if (!CollectionUtils.isEmpty((Collection)buDtoByParam)) {
                return buDtoByParam;
            }
        }
        catch (Exception e) {
            throw new BusinessException(ApiCode.FAIL, "\u7cfb\u7edf\u57df\u90e8\u95e8\u67e5\u8be2\u65b9\u6cd5\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5,\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
        }
        return Lists.newArrayList();
    }

    @Override
    public OrgBuRpcSaveResult orgBuRpcSaveOrUpdate(OrgBuRpcSaveParam param) {
        log.info("\u8c03\u7528\u7cfb\u7edf\u57df-\u65b0\u589e/\u7f16\u8f91\u7ec4\u7ec7\u4fe1\u606f\u5f00\u59cb\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)param);
        try {
            ApiResult apiResult = this.orgBuRpcService.orgBuRpcSaveOrUpdate(param);
            if (apiResult.isSuccess()) {
                return (OrgBuRpcSaveResult)apiResult.getData();
            }
            throw new BusinessException("\u4ed3\u5e93\u540c\u6b65\u652f\u6491\u57df-\u7ec4\u7ec7\u4fdd\u5b58/\u7f16\u8f91\u65b9\u6cd5\u5931\u8d25:" + apiResult.getMsg());
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u7cfb\u7edf\u57df-\u65b0\u589e/\u7f16\u8f91\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff1a{}", (Throwable)e);
            throw new BusinessException("dubb\u8c03\u7528\u652f\u6491\u57df-\u7ec4\u7ec7\u4fdd\u5b58\u65b9\u6cd5\u670d\u52a1\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public ApiResult<OrgBuDetailsRpcDTO> findDetailDtoById(Long id) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> orgAddrSaveOrUpdateReturnAddrNo(OrgAddrRpcSaveParam param) {
        log.info("\u8c03\u7528\u652f\u6491\u57df-\u65b0\u589e\u6216\u4fee\u6539\u5730\u5740\u8584\u4fe1\u606f\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)param);
        ApiResult apiResult = null;
        try {
            apiResult = this.orgAddrRpcService.orgAddrSaveOrUpdateReturnAddrNo(param);
            log.info("\u8c03\u7528\u652f\u6491\u57df-\u65b0\u589e\u6216\u4fee\u6539\u5730\u5740\u8584\u4fe1\u606f\uff0c\u65f6\u95f4\uff1a{}\uff0c\u51fa\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)apiResult);
            if (apiResult.isSuccess()) {
                return apiResult;
            }
            throw new BusinessException(ApiCode.FAIL, "\u652f\u6491\u57df\u5730\u5740\u4fdd\u5b58\u65b9\u6cd5\u5931\u8d25" + apiResult.getMsg());
        }
        catch (Exception e) {
            log.error("orgAddrSaveOrUpdateReturnAddrNo error:", (Throwable)e);
            throw new BusinessException("\u65b0\u589e\u6216\u4fee\u6539\u5730\u5740\u8584\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5!" + e.getMessage());
        }
    }

    @Override
    public OrgAddrDetailsRpcDTO findRpcDtoByAddrNo(Long addrNo) {
        log.info("\u8c03\u7528\u652f\u6491\u57df-\u6839\u636e\u5730\u5740\u53f7\u83b7\u53d6\u5730\u5740\u8584\u8be6\u60c5\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)addrNo);
        try {
            OrgAddrQueryRpcParam param = new OrgAddrQueryRpcParam();
            param.setAddrNo(addrNo);
            ApiResult apiResult = this.orgAddrRpcService.findRpcDtoByParam(param);
            if (apiResult.isSuccess()) {
                return (OrgAddrDetailsRpcDTO)apiResult.getData();
            }
            throw new BusinessException(ApiCode.FAIL, apiResult.getMsg());
        }
        catch (Exception e) {
            log.error("findRpcDtoByAddrNo error:", (Throwable)e);
            return null;
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void softDeleteOrgAddrByAddrNo(Long addrNo) {
        log.info("\u8c03\u7528\u652f\u6491\u57df-\u8f6f\u5220\u9664\u5730\u5740\u8584\u4fe1\u606f\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)addrNo);
        try {
            this.orgAddrRpcService.softDeleteOrgAddrByAddrNo(addrNo);
        }
        catch (Exception e) {
            log.error("softDeleteOrgAddrByAddrNo error:", (Throwable)e);
        }
    }

    @Override
    public List<OrgAddressRpcDTO> findRpcDtoByBatchAddrNos(OrgAddressRpcDtoParam param) {
        log.info("\u8c03\u7528\u652f\u6491\u57df-\u6279\u91cf\u67e5\u8be2\u5730\u5740\u4fe1\u606f\u6570\u636e\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)param);
        try {
            List addressRpcDTOS = this.orgAddrRpcService.findAddrAddressRpcDtoByParam(param);
            if (!CollectionUtils.isEmpty((Collection)addressRpcDTOS)) {
                return addressRpcDTOS;
            }
        }
        catch (Exception e) {
            log.error("findRpcDtoByBatchAddrNos", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<OrgBuRpcDTO> findBuByIds(List<Long> buIds) {
        log.info("\u8c03\u7528\u652f\u6491\u57df-\u6839\u636e\u7ec4\u7ec7ID\u96c6\u5408\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5217\u8868\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), buIds);
        if (CollectionUtils.isEmpty(buIds)) {
            return Lists.newArrayList();
        }
        OrgBuRpcDtoParam param = new OrgBuRpcDtoParam();
        param.setBuIds(buIds);
        try {
            List ous = this.orgBuRpcService.findBuDtoByParam(param);
            if (!CollectionUtils.isEmpty((Collection)ous)) {
                return ous;
            }
        }
        catch (Exception e) {
            log.error("findOuByIds error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<OrgBuRpcDTO> findBuByCodes(List<String> buCodes) {
        log.info("\u8c03\u7528\u652f\u6491\u57df-\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u96c6\u5408\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5217\u8868\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), buCodes);
        if (CollectionUtils.isEmpty(buCodes)) {
            return Lists.newArrayList();
        }
        OrgBuRpcDtoParam param = new OrgBuRpcDtoParam();
        param.setBuCodes(buCodes);
        try {
            List ous = this.orgBuRpcService.findBuDtoByParam(param);
            if (!CollectionUtils.isEmpty((Collection)ous)) {
                return ous;
            }
        }
        catch (Exception e) {
            log.error("findBuByCodes error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public Optional<OrgBuRpcDTO> findBuById(Long buId) {
        log.info("\u8c03\u7528\u652f\u6491\u57df-\u6839\u636e\u7ec4\u7ec7ID\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)buId);
        if (StringUtils.isEmpty((Object)buId)) {
            return Optional.empty();
        }
        OrgBuRpcDtoParam param = new OrgBuRpcDtoParam();
        param.setBuIds(Collections.singletonList(buId));
        try {
            List ous = this.orgBuRpcService.findBuDtoByParam(param);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)ous)) {
                return Optional.of((OrgBuRpcDTO)ous.get(0));
            }
        }
        catch (Exception e) {
            log.error("findBuById error:", (Throwable)e);
        }
        return Optional.empty();
    }

    @Override
    public List<SysCurrencyRespDTO> findRpcDtoByParam(List<String> currCodes) {
        log.info("\u8c03\u7528\u7cfb\u7edf\u5e01\u79cd\u67e5\u8be2\u65b9\u6cd5\u5f00\u59cb\uff0c\u65f6\u95f4\uff1a{}.\u53c2\u6570\u4e3a\uff1a{}", (Object)LocalDateTime.now(), currCodes);
        try {
            HashSet<String> set = new HashSet<String>(currCodes);
            SysCurrencyQueryDTO currencyQueryDTO = new SysCurrencyQueryDTO();
            currencyQueryDTO.setCurrCodes(set);
            ApiResult result = this.sysCurrencyRpcService.queryList(currencyQueryDTO);
            return (List)result.getData();
        }
        catch (Exception e) {
            throw new BusinessException("\u8c03\u7528\u7cfb\u7edf\u57df\u5e01\u79cd\u67e5\u8be2\u65b9\u6cd5\u670d\u52a1\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    @Override
    public List<OrgRespVO> findcodeAndName(InvParentParamVO param) {
        ArrayList<OrgRespVO> orgRespVOList = new ArrayList<OrgRespVO>();
        try {
            if (!InvPTypeEnum.INV_PARTNER_TYPE_CUST.getPType().equals(param.getType())) {
                if (InvPTypeEnum.INV_PARTNER_TYPE_SUPP.getPType().equals(param.getType())) {
                    PurSuppBaseRpcDTO purSuppBaseDTOS;
                    Optional<PurSuppBaseRpcDTO> suppBaseDTOOptional = this.purDubbleService.findSuppByCode(param.getCode());
                    if (suppBaseDTOOptional.isPresent() && (purSuppBaseDTOS = suppBaseDTOOptional.get()) != null) {
                        OrgRespVO respVO = this.convertSuppDTOToOrgRespVO(purSuppBaseDTOS);
                        orgRespVOList.add(respVO);
                    }
                } else if (InvPTypeEnum.INV_PARTNER_TYPE_EMP.getPType().equals(param.getType())) {
                    OrgEmpRpcDtoParam empParam = new OrgEmpRpcDtoParam();
                    ArrayList<String> orgemplist = new ArrayList<String>();
                    orgemplist.add(param.getCode());
                    empParam.setEmpCodes(orgemplist);
                    List<OrgEmpRpcDTO> emps = this.findEmpDtoByParam(empParam);
                    for (OrgEmpRpcDTO emp : emps) {
                        OrgRespVO orgRespVO = new OrgRespVO();
                        orgRespVO.setId(emp.getId());
                        orgRespVO.setCode(emp.getEmpCode());
                        orgRespVO.setName(emp.getEmpName());
                        orgRespVOList.add(orgRespVO);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("findcodeAndName error:", (Throwable)e);
        }
        return orgRespVOList;
    }

    @Override
    public List<OrgRespVO> findcodeAndNameList(InvPTypeEnum type, List<String> codes) {
        List<OrgRespVO> orgRespVOList = new ArrayList<OrgRespVO>();
        try {
            switch (type) {
                case INV_PARTNER_TYPE_CUST: {
                    return orgRespVOList;
                }
                case INV_PARTNER_TYPE_EMP: {
                    OrgEmpRpcDtoParam empParam = new OrgEmpRpcDtoParam();
                    empParam.setEmpCodes(codes);
                    List<OrgEmpRpcDTO> emps = this.findEmpDtoByParam(empParam);
                    for (OrgEmpRpcDTO emp : emps) {
                        OrgRespVO orgRespVO = new OrgRespVO();
                        orgRespVO.setId(emp.getId());
                        orgRespVO.setCode(emp.getEmpCode());
                        orgRespVO.setName(emp.getEmpName());
                        orgRespVOList.add(orgRespVO);
                    }
                    return orgRespVOList;
                }
                case INV_PARTNER_TYPE_SUPP: {
                    List<PurSuppBaseRpcDTO> suppBaseDTOS = this.purDubbleService.findSuppByCodeBatch(codes);
                    if (!org.springframework.util.CollectionUtils.isEmpty(suppBaseDTOS) && !CollectionUtils.isEmpty(suppBaseDTOS)) {
                        orgRespVOList = suppBaseDTOS.stream().map(this::convertSuppDTOToOrgRespVO).collect(Collectors.toList());
                    }
                    return orgRespVOList;
                }
            }
        }
        catch (Exception e) {
            log.error("findcodeAndNameList error:", (Throwable)e);
        }
        return orgRespVOList;
    }

    private OrgRespVO convertSuppDTOToOrgRespVO(PurSuppBaseRpcDTO purSuppBaseDTO) {
        if (purSuppBaseDTO == null) {
            return null;
        }
        OrgRespVO orgRespVO = new OrgRespVO();
        orgRespVO.setId(purSuppBaseDTO.getId());
        orgRespVO.setName(purSuppBaseDTO.getSuppName());
        orgRespVO.setCode(purSuppBaseDTO.getSuppCode());
        return orgRespVO;
    }

    public OrgOutServiceImpl(OrgOuRpcService orgOuRpcService, OrgEmpRpcService orgEmpRpcService, OrgBuRpcService orgBuRpcService, OrgAddrRpcService orgAddrRpcService, SysCurrencyRpcService sysCurrencyRpcService, PurDubbleService purDubbleService) {
        this.orgOuRpcService = orgOuRpcService;
        this.orgEmpRpcService = orgEmpRpcService;
        this.orgBuRpcService = orgBuRpcService;
        this.orgAddrRpcService = orgAddrRpcService;
        this.sysCurrencyRpcService = sysCurrencyRpcService;
        this.purDubbleService = purDubbleService;
    }
}

