/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.elitesland.yst.production.inv.application.facade.vo.InvParentParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.base.InvBaseModel;
import com.elitesland.yst.production.inv.application.facade.vo.invTrn.InvTrnAllQueryParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invTrn.InvTrnAndTrnDSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.invTrn.InvTrnDDetailRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invTrn.InvTrnDRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invTrn.InvTrnDetailRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invTrn.InvTrnSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.OrgRespVO;
import com.elitesland.yst.production.inv.application.out.ItmOutService;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvStkCommonService;
import com.elitesland.yst.production.inv.application.service.InvTrnService;
import com.elitesland.yst.production.inv.application.service.InvWhAreaService;
import com.elitesland.yst.production.inv.application.service.InvWhService;
import com.elitesland.yst.production.inv.application.service.stk.InvStkOptBizService;
import com.elitesland.yst.production.inv.domain.convert.InvTrnConvert;
import com.elitesland.yst.production.inv.domain.convert.InvTrnDConvert;
import com.elitesland.yst.production.inv.domain.entity.invtrn.InvTrn;
import com.elitesland.yst.production.inv.domain.service.InvTrnDDomainService;
import com.elitesland.yst.production.inv.domain.service.InvTrnDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhDomainService;
import com.elitesland.yst.production.inv.entity.InvTrnDDO;
import com.elitesland.yst.production.inv.entity.InvTrnDO;
import com.elitesland.yst.production.inv.entity.QInvTrnDO;
import com.elitesland.yst.production.inv.enums.InvStkSceneCodeEnum;
import com.elitesland.yst.production.inv.enums.ProcDefKey;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateBodyDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateDTO;
import com.elitesland.yst.production.inv.infr.dto.InvTrnAndTrnDTO;
import com.elitesland.yst.production.inv.infr.dto.InvTrnDDTO;
import com.elitesland.yst.production.inv.infr.dto.InvTrnDTO;
import com.elitesland.yst.production.inv.infr.repo.InvTrnDRepo;
import com.elitesland.yst.production.inv.infr.repo.InvTrnRepo;
import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.elitesland.yst.production.inv.utils.NumSendObjectEnum;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.inv.utils.ValidationUtil;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.google.common.util.concurrent.AtomicDouble;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class InvTrnServiceImpl
implements InvTrnService {
    private static final Logger log = LoggerFactory.getLogger(InvTrnServiceImpl.class);
    private final InvTrnDomainService invTrnDomainService;
    private final InvTrnDDomainService invTrnDDomainService;
    private final SystemService systemService;
    private final InvTrnDRepo invTrnDRepo;
    private final InvTrnRepo invTrnRepo;
    private final OrgOutService orgOutService;
    private final ItmOutService itmOutService;
    private final InvWhAreaService invWhAreaService;
    private final InvWhDomainService invWhDomainService;
    private final InvWhService invWhService;
    private final InvStkOptBizService invStkOptBizService;
    private final JPAQueryFactory jpaQueryFactory;
    private final WorkflowService workflowService;
    private final InvStkCommonService invStkCommonService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Long saveInvTrnInfo(InvTrnAndTrnDSaveVO inv) {
        List<InvTrnDDTO> invTrnDDTOS;
        ArrayList<String> runtimeValues = new ArrayList<String>();
        InvTrnSaveVO invHeader = inv.getHeader();
        if (StrUtil.equals((CharSequence)inv.getHeader().getReasonCode(), (CharSequence)UdcEnum.INV_REASON_CODE_TRANS_201.getValueCode())) {
            if (ObjectUtil.equals((Object)invHeader.getIWhId(), (Object)invHeader.getOWhId())) {
                throw new BusinessException(ApiCode.FAIL, "\u8de8\u5e93\u8c03\u8d27\uff0c\u3010\u53d1\u8d27/\u6536\u8d27\u4ed3\u5e93\u3011\u76f8\u540c\uff0c\u8bf7\u4fee\u6539\uff01");
            }
        } else if (StrUtil.equals((CharSequence)inv.getHeader().getReasonCode(), (CharSequence)UdcEnum.INV_REASON_CODE_TRANS_202.getValueCode()) && ObjectUtil.notEqual((Object)invHeader.getIWhId(), (Object)invHeader.getOWhId())) {
            throw new BusinessException(ApiCode.FAIL, "\u540c\u4ed3\u8c03\u62e8\uff0c\u3010\u53d1\u8d27/\u6536\u8d27\u4ed3\u5e93\u3011\u4e0d\u540c\uff0c\u8bf7\u4fee\u6539\uff01");
        }
        invHeader.setODeter1(UdcEnum.INV_TEMP_TYPE_RT.getValueCode());
        invHeader.setIDeter1(UdcEnum.INV_TEMP_TYPE_RT.getValueCode());
        this.saveCheckIn(invHeader, inv.getDetails());
        InvTrnSaveVO invTrnSaveVO = new InvTrnSaveVO();
        invHeader.setDocStatus(UdcEnum.INV_TRN_STATUS_DR.getValueCode());
        invHeader.setDocType(UdcEnum.COM_DOC_CLS_STKTRN.getValueCode());
        BeanUtils.copyProperties((Object)invHeader, (Object)invTrnSaveVO);
        if (inv.getHeader().getId() != null) {
            if (UdcEnum.INV_TRN_STATUS_APPING.getValueCode().equals(inv.getHeader().getDocStatus()) || UdcEnum.INV_TRN_STATUS_APPED.getValueCode().equals(inv.getHeader().getDocStatus())) {
                throw new BusinessException(ApiCode.FAIL, "\u5df2\u5ba1\u6279\u6216\u5728\u5ba1\u6279\u4e2d\u7684\u5355\u636e\u4e0d\u80fd\u4fdd\u5b58\uff0c\u8bf7\u68c0\u67e5");
            }
            Optional<InvTrnDTO> invTrnDTOOptional = this.invTrnDomainService.findIdOne(inv.getHeader().getId());
            if (!invTrnDTOOptional.isPresent()) throw new BusinessException(ApiCode.FAIL, String.format("\u5355\u636e\u3010%s\u3011\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", inv.getHeader().getDocNo()));
            String procInstId = invTrnDTOOptional.get().getProcInstId();
            invTrnSaveVO.setProcInstId(procInstId);
            invTrnSaveVO.setDocNo(invTrnDTOOptional.get().getDocNo());
            invTrnSaveVO.setApprComment(invTrnDTOOptional.get().getApprComment());
            invTrnSaveVO.setProcInstStatus(invTrnDTOOptional.get().getProcInstStatus());
            invTrnSaveVO.setSubmitTime(invTrnDTOOptional.get().getSubmitTime());
        } else {
            invHeader.setDocStatus(UdcEnum.INV_TRN_STATUS_DR.getValueCode());
            runtimeValues.add(invHeader.getOuCode());
            String code = this.systemService.sysNumberRuleGenerateCode(NumSendObjectEnum.INV_IT.getCode(), runtimeValues);
            invTrnSaveVO.setDocNo(inv.getHeader().getDocNo() != null ? inv.getHeader().getDocNo() : code);
        }
        invTrnSaveVO.setCreateTime(LocalDateTime.now());
        InvTrn invTrn = InvTrnConvert.INSTANCE.saveVOToInvTrn(invTrnSaveVO);
        Long id = this.invTrnDomainService.create(invTrn);
        if (CollectionUtils.isEmpty(inv.getDetails())) return id;
        if (inv.getHeader().getId() != null && !CollectionUtils.isEmpty(invTrnDDTOS = this.invTrnDDomainService.findByMasId(inv.getHeader().getId()))) {
            List<Long> trndIds = invTrnDDTOS.stream().map(BaseModelVO::getId).collect(Collectors.toList());
            this.invTrnDDomainService.deleteBatch(trndIds);
        }
        List<Long> owhIds = inv.getDetails().stream().map(InvTrnDDetailRespVO::getOWhId).collect(Collectors.toList());
        List<Long> iwhIds = inv.getDetails().stream().map(InvTrnDDetailRespVO::getIWhId).collect(Collectors.toList());
        InvWhAreaParamVO areaParamVO = new InvWhAreaParamVO();
        areaParamVO.setWhIds(owhIds);
        List<InvWhAreaRespVO> whAreasByParam1 = this.invWhAreaService.findWhAreasByParam(areaParamVO);
        areaParamVO.setWhIds(iwhIds);
        List<InvWhAreaRespVO> whAreasByParam2 = this.invWhAreaService.findWhAreasByParam(areaParamVO);
        AtomicDouble linoNo = new AtomicDouble(0.0);
        List detailDOs = inv.getDetails().stream().map(d -> {
            List whAreaRespVOS;
            InvTrnDDO invTrnDDO = new InvTrnDDO();
            BeanUtils.copyProperties((Object)d, (Object)invTrnDDO);
            invTrnDDO.setCreateTime(LocalDateTime.now());
            invTrnDDO.setMasId(id);
            invTrnDDO.setLineNo(linoNo.addAndGet(1.0));
            invTrnDDO.setIDeter1(UdcEnum.INV_TEMP_TYPE_RT.getValueCode());
            invTrnDDO.setODeter1(UdcEnum.INV_TEMP_TYPE_RT.getValueCode());
            try {
                GeneralUserDetails user = SecurityContextUtil.currentUser();
                invTrnDDO.setSecBuId(invTrnSaveVO.getSecBuId() == null ? null : invTrnSaveVO.getSecBuId());
                invTrnDDO.setSecOuId(invTrnSaveVO.getOOuId() == null ? null : invTrnSaveVO.getOOuId());
            }
            catch (Exception e) {
                log.error("\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4eba\u4fe1\u606f\uff0c\u8bf7\u5148\u767b\u5f55\uff1a{}" + e.getMessage());
            }
            List invWhAreaRespVOS = whAreasByParam2.stream().filter(v -> v.getWhId().equals(d.getIWhId())).collect(Collectors.toList());
            List deter2List = invWhAreaRespVOS.stream().map(InvWhAreaRespVO::getDeter2).collect(Collectors.toList());
            if (!deter2List.contains(d.getIDeter2())) {
                throw new BusinessException(ApiCode.FAIL, "\u81f3\u4ed3\u5e93\u6ca1\u6709" + d.getIDeter2Name() + "\u529f\u80fd\u5e93\u533a");
            }
            if (d.getOPCode() != null && d.getOPType() != null && CollectionUtils.isEmpty(whAreaRespVOS = whAreasByParam1.stream().filter(v -> d.getOPType().equals(v.getPType()) && d.getOPCode().equals(v.getPCode())).collect(Collectors.toList()))) {
                throw new BusinessException(String.format("\u4ece\u4ed3\u5e93\u3010%s\u3011\u529f\u80fd\u533a\u3010%s\u3011\u5408\u4f5c\u4f19\u4f34\u3010%s\u3011\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", d.getOWhName(), d.getODeter2Name(), d.getOPName()));
            }
            if (d.getIPCode() != null && d.getIPType() != null && CollectionUtils.isEmpty(whAreaRespVOS = whAreasByParam2.stream().filter(v -> d.getIPType().equals(v.getPType()) && d.getIPCode().equals(v.getPCode())).collect(Collectors.toList()))) {
                throw new BusinessException(String.format("\u81f3\u4ed3\u5e93\u3010%s\u3011\u529f\u80fd\u533a\u3010%s\u3011\u5408\u4f5c\u4f19\u4f34[%s]\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", d.getIWhName(), d.getIDeter2Name(), d.getIPName()));
            }
            return invTrnDDO;
        }).collect(Collectors.toList());
        this.invTrnDRepo.saveAll(detailDOs);
        return id;
    }

    @Override
    @SysCodeProc
    public InvTrnDetailRespVO invTrnDetail(Long id) {
        List<InvTrnAndTrnDTO> domainServiceAll;
        Long userId;
        Long ouId;
        OrgOuRpcDTO orgOuRpcDTO;
        Optional<InvTrnDTO> invTrnDTOOptional = this.invTrnDomainService.findIdOne(id);
        if (!invTrnDTOOptional.isPresent()) {
            return null;
        }
        Optional<InvWhRespVO> oWh = this.invWhDomainService.findById(invTrnDTOOptional.get().getOWhId() != null ? invTrnDTOOptional.get().getOWhId() : 0L);
        Optional<InvWhRespVO> iWh = this.invWhDomainService.findById(invTrnDTOOptional.get().getIWhId() != null ? invTrnDTOOptional.get().getIWhId() : 0L);
        if (oWh.isPresent()) {
            invTrnDTOOptional.get().setOWhName(oWh.get().getWhName());
            invTrnDTOOptional.get().setOWhCode(oWh.get().getWhCode());
        }
        if (iWh.isPresent()) {
            invTrnDTOOptional.get().setIWhName(iWh.get().getWhName());
            invTrnDTOOptional.get().setIWhCode(iWh.get().getWhCode());
        }
        InvTrnDetailRespVO invTrnDetailRespVO = InvTrnConvert.INSTANCE.trnDTOToDetailRespVO(invTrnDTOOptional.get());
        InvTrnAllQueryParamVO queryParamVO = new InvTrnAllQueryParamVO();
        queryParamVO.setMasId(invTrnDTOOptional.get().getId());
        ArrayList<String> deter2s = new ArrayList<String>();
        ArrayList<Long> whIds = new ArrayList<Long>();
        deter2s.add(invTrnDetailRespVO.getODeter2());
        deter2s.add(invTrnDetailRespVO.getIDeter2());
        whIds.add(invTrnDTOOptional.get().getOWhId());
        whIds.add(invTrnDTOOptional.get().getIWhId());
        InvWhAreaParamVO areaParamVO = new InvWhAreaParamVO();
        areaParamVO.setDeter2s(deter2s);
        areaParamVO.setWhIds(whIds);
        List<InvWhAreaRespVO> whAreaRespVOS = this.invWhAreaService.findWhAreasByParam(areaParamVO);
        invTrnDetailRespVO.setDocStatusName(this.getUdcDesc(UdcEnum.INV_TRN_STATUS_DR.getModel(), UdcEnum.INV_TRN_STATUS_DR.getCode(), invTrnDTOOptional.get().getDocStatus()));
        invTrnDetailRespVO.setReasonCodeName(this.getUdcDesc(UdcEnum.COM_REASON_CODE_183.getModel(), UdcEnum.COM_REASON_CODE_183.getCode(), invTrnDetailRespVO.getReasonCode()));
        Map<String, String> pTypeMap = this.systemService.sysUdcGetCodeMap(UdcEnum.INV_PARTNER_TYPE_EMP.getModel(), UdcEnum.INV_PARTNER_TYPE_EMP.getCode());
        if (!CollectionUtils.isEmpty(whAreaRespVOS)) {
            whAreaRespVOS.stream().filter(w -> w.getDeter2().equals(invTrnDetailRespVO.getODeter2()) && w.getWhId().equals(invTrnDetailRespVO.getOWhId())).findAny().ifPresent(m -> invTrnDetailRespVO.setODeter2Name(m.getDeter2Name()));
            whAreaRespVOS.stream().filter(w -> w.getDeter2().equals(invTrnDetailRespVO.getIDeter2()) && w.getWhId().equals(invTrnDetailRespVO.getIWhId())).findAny().ifPresent(m -> invTrnDetailRespVO.setIDeter2Name(m.getDeter2Name()));
        }
        if ((orgOuRpcDTO = this.orgOutService.findOuById(ouId = invTrnDetailRespVO.getOuId())) != null) {
            invTrnDetailRespVO.setOuCode(orgOuRpcDTO.getOuCode());
            invTrnDetailRespVO.setOuName(orgOuRpcDTO.getOuName());
        }
        if ((userId = invTrnDetailRespVO.getCreateUserId()) != null) {
            ArrayList<Long> list = new ArrayList<Long>();
            list.add(userId);
            List<SysUserVO> sysUsers = this.systemService.findAllEmpsByIdIn(list);
            if (!CollectionUtils.isEmpty(sysUsers)) {
                SysUserVO userVO = sysUsers.get(0);
                invTrnDetailRespVO.setCreateUserName(userVO.getUsername());
            }
        }
        if (!CollectionUtils.isEmpty(domainServiceAll = this.invTrnDDomainService.findAll(queryParamVO))) {
            ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
            List itemIds = domainServiceAll.stream().filter(f -> f.getItemId() != null).map(InvTrnAndTrnDTO::getItemId).collect(Collectors.toList());
            itmItemPartParam.setItemIds(itemIds);
            List<ItmItemRpcDTO> itmItemPartDTOS = this.itmOutService.findItemRpcDtoByParam(itmItemPartParam);
            Map<String, String> udcUom = this.systemService.sysUdcGetCodeMap(UdcEnum.COM_UOM_BG.getModel(), UdcEnum.COM_UOM_BG.getCode());
            List<InvTrnDRespVO> invTrnDRespVOList = domainServiceAll.stream().map(e -> {
                List<OrgRespVO> vos;
                InvParentParamVO paramVO;
                InvTrnDRespVO invTrnDRespVO = InvTrnDConvert.INSTANCE.dtoToRespVO((InvTrnAndTrnDTO)e);
                invTrnDRespVO.setIWhName(invTrnDetailRespVO.getIWhName());
                invTrnDRespVO.setOWhName(invTrnDetailRespVO.getOWhName());
                invTrnDRespVO.setODeter2Name(invTrnDetailRespVO.getODeter2Name());
                invTrnDRespVO.setIDeter2Name(invTrnDetailRespVO.getIDeter2Name());
                if (e.getUom() != null && MapUtils.isNotEmpty((Map)udcUom)) {
                    invTrnDRespVO.setUomName((String)udcUom.get(e.getUom()));
                }
                if (!CollectionUtils.isEmpty((Collection)itmItemPartDTOS)) {
                    itmItemPartDTOS.stream().filter(f -> f.getId().equals(e.getItemId())).findFirst().ifPresent(i -> {
                        invTrnDRespVO.setItemCode(i.getItemCode());
                        invTrnDRespVO.setItemName(i.getItemName());
                        invTrnDRespVO.setLotFlag(i.getLotFlag());
                        invTrnDRespVO.setBrandCode(i.getBrand());
                        invTrnDRespVO.setBrandName(i.getBrandName());
                        invTrnDRespVO.setPackageSpec(i.getPackageSpec());
                    });
                }
                if (e.getOPType() != null && e.getOPCode() != null) {
                    paramVO = new InvParentParamVO();
                    paramVO.setCode(invTrnDRespVO.getOPCode());
                    paramVO.setType(invTrnDRespVO.getOPType());
                    vos = this.orgOutService.findcodeAndName(paramVO);
                    if (!CollectionUtils.isEmpty(vos)) {
                        invTrnDRespVO.setOPName(vos.get(0).getName());
                    }
                }
                if (invTrnDRespVO.getIPType() != null && e.getIPCode() != null) {
                    paramVO = new InvParentParamVO();
                    paramVO.setCode(invTrnDRespVO.getIPCode());
                    paramVO.setType(invTrnDRespVO.getIPType());
                    vos = this.orgOutService.findcodeAndName(paramVO);
                    if (!CollectionUtils.isEmpty(vos)) {
                        invTrnDRespVO.setIPName(vos.get(0).getName());
                    }
                }
                if (!MapUtils.isEmpty((Map)pTypeMap)) {
                    invTrnDRespVO.setIPTypeName((String)pTypeMap.get(invTrnDRespVO.getIPType()));
                }
                if (!MapUtils.isEmpty((Map)pTypeMap)) {
                    invTrnDRespVO.setOPTypeName((String)pTypeMap.get(invTrnDRespVO.getOPType()));
                }
                invTrnDRespVO.setAvalQty(this.getAvalQty((InvTrnAndTrnDTO)e));
                return invTrnDRespVO;
            }).collect(Collectors.toList());
            invTrnDetailRespVO.setInvTrnDRespVOList(invTrnDRespVOList);
        }
        return invTrnDetailRespVO;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long submit(Long id) {
        SysUserDTO user = this.systemService.sysUserCurrent();
        if (user == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u6cd5\u5230\u83b7\u53d6\u5f53\u524d\u7528\u6237");
        }
        Optional invTrnVOOptional = this.invTrnRepo.findById(id);
        if (!invTrnVOOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        try {
            if (((InvTrnDO)invTrnVOOptional.get()).getProcInstId() == null || WorkflowConstant.CAN_START_PROC_STATUSES.contains(((InvTrnDO)invTrnVOOptional.get()).getProcInstStatus())) {
                Long ouId = ((InvTrnDO)invTrnVOOptional.get()).getOuId();
                OrgOuRpcDTO orgOuRpcDTO = this.orgOutService.findOuById(ouId);
                if (orgOuRpcDTO == null) throw new BusinessException("\u516c\u53f8\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
                String procInstName = ProcDefKey.INV_TRN.getDesc() + ((InvTrnDO)invTrnVOOptional.get()).getDocNo();
                this.startWorkFlow(ProcDefKey.INV_TRN.name(), procInstName, "" + ((InvTrnDO)invTrnVOOptional.get()).getId(), "" + user.getId(), id);
                return id;
            } else {
                ((InvTrnDO)invTrnVOOptional.get()).setDocStatus(UdcEnum.INV_TRN_STATUS_APPING.getValueCode());
                ((InvTrnDO)invTrnVOOptional.get()).setIoDate(LocalDateTime.now());
                this.invTrnRepo.save((InvTrnDO)invTrnVOOptional.get());
            }
            return id;
        }
        catch (Exception e) {
            throw new BusinessException(ApiCode.FAIL, "\u63d0\u4ea4\u5931\u8d25" + e.getMessage());
        }
    }

    private InvStkCommonOperateDTO getInvStkCommonOperateDTO(List<InvTrnDDO> invTrnDRespVOS, InvTrnDO invTrnDO, String sceneCode) {
        InvStkCommonOperateDTO operateDTO = new InvStkCommonOperateDTO();
        operateDTO.setRequestId(UUID.randomUUID().toString().trim().replaceAll("-", ""));
        operateDTO.setSceneCode(sceneCode);
        operateDTO.setSource("YST-INV");
        ArrayList<InvStkCommonOperateBodyDTO> operateBodyDTOS = new ArrayList<InvStkCommonOperateBodyDTO>();
        invTrnDRespVOS.stream().forEach(invTrnDRespVo -> {
            InvStkCommonOperateBodyDTO operateBodyDTO = new InvStkCommonOperateBodyDTO();
            operateBodyDTO.setWhId(invTrnDRespVo.getOWhId());
            operateBodyDTO.setItemId(invTrnDRespVo.getItemId());
            operateBodyDTO.setDeter2(invTrnDRespVo.getODeter2());
            operateBodyDTO.setSrcDocId(invTrnDO.getId());
            operateBodyDTO.setDocNo(invTrnDO.getDocNo());
            operateBodyDTO.setSrcDocDid(invTrnDRespVo.getId());
            operateBodyDTO.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKTRN.getValueCode());
            operateBodyDTO.setLineNo(invTrnDRespVo.getLineNo());
            operateBodyDTO.setCreateUserId(invTrnDO.getCreateUserId());
            operateBodyDTO.setOpDate(LocalDateTime.now());
            operateBodyDTO.setUom(invTrnDRespVo.getUom());
            operateBodyDTO.setQty(invTrnDRespVo.getQty());
            operateBodyDTO.setLotNo(invTrnDRespVo.getLotNo());
            operateBodyDTO.setPCode(invTrnDRespVo.getOPCode());
            operateBodyDTO.setPType(invTrnDRespVo.getOPType());
            operateBodyDTO.setOuId(invTrnDRespVo.getOuId());
            operateBodyDTO.setVariId(invTrnDRespVo.getVariId());
            operateBodyDTOS.add(operateBodyDTO);
        });
        operateDTO.setSourceBodyList(operateBodyDTOS);
        return operateDTO;
    }

    private void startWorkFlow(String processDefinitionKey, String procInstName, String businessKey, String currentUserId, Long id) {
        try {
            WorkflowResult processInfoWorkflowResult = this.workflowService.startProcess(StartProcessPayload.of((String)processDefinitionKey, (String)procInstName, (String)businessKey, null));
            log.info("\u5e93\u5b58\u8f6c\u79fb\u542f\u52a8\u6d41\u7a0b\u8fd4\u56de:" + processInfoWorkflowResult.getData());
            if (!processInfoWorkflowResult.isSuccess() || Objects.isNull(processInfoWorkflowResult.getData())) {
                throw new BusinessException("\u8c03\u7528\u5de5\u4f5c\u6d41\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f:" + processInfoWorkflowResult.getMsg());
            }
            QInvTrnDO qInvTrnDO = QInvTrnDO.invTrnDO;
            JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)qInvTrnDO).set((Path)qInvTrnDO.procInstId, (Object)((ProcessInfo)processInfoWorkflowResult.getData()).getProcInstId()).set(qInvTrnDO.submitTime, (Object)LocalDateTime.now()).set(qInvTrnDO.ioDate, (Object)LocalDateTime.now()).where(new Predicate[]{qInvTrnDO.id.eq((Object)id)});
            if (!Objects.equals(((ProcessInfo)processInfoWorkflowResult.getData()).getProcInstStatus(), ProcInstStatus.APPROVED)) {
                jpaUpdateClause.set(qInvTrnDO.procInstStatus, (Object)ProcInstStatus.APPROVING);
                jpaUpdateClause.set((Path)qInvTrnDO.docStatus, (Object)UdcEnum.INV_TRN_STATUS_APPING.getValueCode());
            }
            jpaUpdateClause.execute();
        }
        catch (Exception e) {
            throw new BusinessException(ApiCode.FAIL, "\u5f00\u542f\u5de5\u4f5c\u6d41\u670d\u52a1\u5931\u8d25:" + e.getMessage());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> updateStatusInBatch(List<Long> ids, String status) {
        this.invTrnDomainService.updateDocStatusByIds(ids, status);
        return ids;
    }

    private BigDecimal getAvalQty(InvTrnAndTrnDTO invTrnAndTrnDRespVO) {
        InvBaseModel invStkParam = new InvBaseModel();
        invStkParam.setItemId(invTrnAndTrnDRespVO.getItemId());
        invStkParam.setWhId(invTrnAndTrnDRespVO.getOWhId());
        invStkParam.setVariId(invTrnAndTrnDRespVO.getVariId());
        invStkParam.setLotNo(invTrnAndTrnDRespVO.getLotNo());
        invStkParam.setDeter2(invTrnAndTrnDRespVO.getODeter2());
        InvStkRespVO invStk = this.invStkCommonService.getInvGroupStk(invStkParam);
        if (invStk != null) {
            return invStk.getAvalQty();
        }
        return null;
    }

    private String getUdcDesc(String domain, String udcCode, String udcVal) {
        if (StringUtils.isEmpty((Object)domain) || StringUtils.isEmpty((Object)udcCode)) {
            return null;
        }
        Map<String, String> codeMap = this.systemService.sysUdcGetCodeMap(domain, udcCode);
        if (CollectionUtils.isEmpty(codeMap)) {
            return null;
        }
        if (codeMap.containsKey(udcVal)) {
            return codeMap.get(udcVal);
        }
        return null;
    }

    public void saveCheckIn(InvTrnSaveVO invTrnSaveVO, List<InvTrnDDetailRespVO> invTrnDDetailRespVOS) {
        ValidationUtil.ValidResult validResult = ValidationUtil.validate(invTrnSaveVO);
        if (validResult.isError()) {
            throw new BusinessException("\u4e3b\u6570\u636e\u53c2\u6570\u9519\u8bef\uff0c\u79fb\u5e93\u539f\u56e0\u3001\u7533\u8bf7\u65e5\u671f\u3001\u4ece\u4ed3\u5e93\u3001\u81f3\u4ed3\u5e93\u3001\u4ece\u529f\u80fd\u5e93\u533a\u3001\u81f3\u529f\u80fd\u5e93\u533a\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ValidationUtil.ValidResult validResult2 = ValidationUtil.validate(invTrnDDetailRespVOS);
        if (validResult2.isError()) {
            throw new BusinessException("\u660e\u7ec6\u6570\u636e\u53c2\u6570\u9519\u8bef\uff0c\u4ece\u529f\u80fd\u5e93\u533a\u3001\u81f3\u529f\u80fd\u5e93\u533a\u3001\u8f6c\u79fb\u6570\u91cf\u3001\u4ece\u4ed3\u5e93\u3001\u81f3\u4ed3\u5e93 \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!invTrnSaveVO.getOOuId().toString().equals(invTrnSaveVO.getIOuId().toString())) {
            throw new BusinessException("\u79fb\u5165\u548c\u79fb\u51fa\u4ed3\u5e93\u516c\u53f8\u975e\u540c\u4e00\u516c\u53f8\u8bf7\u68c0\u67e5\uff01");
        }
        long count2 = invTrnDDetailRespVOS.stream().map(v -> v.getItemId() + v.getOWhId() + "_" + v.getODeter2() + v.getIWhId() + "_" + v.getIDeter2() + "_" + v.getIPCode() + "_" + v.getIPType() + "_" + v.getOPCode() + "_" + v.getOPType()).distinct().count();
        if (count2 != (long)invTrnDDetailRespVOS.size()) {
            throw new BusinessException("\u660e\u7ec6\u6570\u636e\u53c2\u6570\u9519\u8bef\uff0c\u5546\u54c1ID,\u4ece\u4ed3\u5e93/\u4ece\u529f\u80fd\u533a,\u81f3\u529f\u80fd\u533a/\u81f3\u529f\u80fd\u5e93\u533a\u5b58\u5728\u76f8\u540c\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
        }
        List<InvWhRespVO> oWhRespVOS = this.invWhService.findIdBatch(invTrnDDetailRespVOS.stream().map(InvTrnDDetailRespVO::getOWhId).collect(Collectors.toList()));
        List<InvWhRespVO> iWhRespVOS = this.invWhService.findIdBatch(invTrnDDetailRespVOS.stream().map(InvTrnDDetailRespVO::getIWhId).collect(Collectors.toList()));
        oWhRespVOS.forEach(o -> {
            List vos = iWhRespVOS.stream().filter(i -> !o.getOuId().equals(i.getOuId())).collect(Collectors.toList());
            if (vos.size() > 0) {
                throw new BusinessException("\u79fb\u5165\u548c\u79fb\u51fa\u4ed3\u5e93\u975e\u540c\u4e00\u516c\u53f8\uff01\u8bf7\u68c0\u67e5");
            }
        });
    }

    @Override
    @Transactional
    public Long check(Long masId) {
        Optional invTrnVOOptional = this.invTrnRepo.findById(masId);
        if (!invTrnVOOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + masId);
        }
        if (!UdcEnum.INV_TRN_STATUS_APPING.getValueCode().equals(((InvTrnDO)invTrnVOOptional.get()).getDocStatus())) {
            throw new BusinessException(ApiCode.FAIL, "\u8bf7\u9009\u62e9\u72b6\u6001\u4e3a\u5ba1\u6838\u4e2d\u7684\u5355\u636e" + masId);
        }
        ((InvTrnDO)invTrnVOOptional.get()).setProcInstStatus(ProcInstStatus.APPROVED);
        ((InvTrnDO)invTrnVOOptional.get()).setApprStatus(UdcEnum.INV_TRN_STATUS_APPED.getValueCode());
        ((InvTrnDO)invTrnVOOptional.get()).setDocStatus(UdcEnum.INV_TRN_STATUS_APPED.getValueCode());
        this.invTrnRepo.save((InvTrnDO)invTrnVOOptional.get());
        List<InvTrnDDO> invTrnDDOS = this.invTrnDRepo.findByMasId(masId);
        InvStkCommonOperateDTO invStkCommonOperateDTO = this.getInvStkCommonOperateDTO(invTrnDDOS, (InvTrnDO)invTrnVOOptional.get(), InvStkSceneCodeEnum.INV_TRN_TRN001.getType());
        this.invStkOptBizService.invStkCommonOperate(invStkCommonOperateDTO);
        return masId;
    }

    @Override
    @Transactional
    public void refuse(Long masId) {
        Optional<InvTrnDTO> invTrnDTOOptional = this.invTrnDomainService.findIdOne(masId);
        if (!invTrnDTOOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + masId);
        }
        invTrnDTOOptional.get().setDocStatus(UdcEnum.INV_TRN_STATUS_RJ.getValueCode());
        InvTrn invTrn = InvTrnConvert.INSTANCE.dtoToInvTrn(invTrnDTOOptional.get());
        this.invTrnDomainService.create(invTrn);
    }

    public InvTrnServiceImpl(InvTrnDomainService invTrnDomainService, InvTrnDDomainService invTrnDDomainService, SystemService systemService, InvTrnDRepo invTrnDRepo, InvTrnRepo invTrnRepo, OrgOutService orgOutService, ItmOutService itmOutService, InvWhAreaService invWhAreaService, InvWhDomainService invWhDomainService, InvWhService invWhService, InvStkOptBizService invStkOptBizService, JPAQueryFactory jpaQueryFactory, WorkflowService workflowService, InvStkCommonService invStkCommonService) {
        this.invTrnDomainService = invTrnDomainService;
        this.invTrnDDomainService = invTrnDDomainService;
        this.systemService = systemService;
        this.invTrnDRepo = invTrnDRepo;
        this.invTrnRepo = invTrnRepo;
        this.orgOutService = orgOutService;
        this.itmOutService = itmOutService;
        this.invWhAreaService = invWhAreaService;
        this.invWhDomainService = invWhDomainService;
        this.invWhService = invWhService;
        this.invStkOptBizService = invStkOptBizService;
        this.jpaQueryFactory = jpaQueryFactory;
        this.workflowService = workflowService;
        this.invStkCommonService = invStkCommonService;
    }
}

