/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.service.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.inv.application.facade.vo.SelectOptionParam;
import com.elitesland.yst.production.inv.application.facade.vo.SelectOptionVO;
import com.elitesland.yst.production.inv.application.facade.vo.whAreaSetting.InvWhAreaSettingParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.whAreaSetting.InvWhAreaSettingRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.whAreaSetting.InvWhAreaSettingSaveVO;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvWhAreaSettingService;
import com.elitesland.yst.production.inv.domain.convert.InvWhAreaSettingConvert;
import com.elitesland.yst.production.inv.domain.entity.whAreaSetting.InvWhAreaSetting;
import com.elitesland.yst.production.inv.domain.service.InvWhAreaSettingDomainService;
import com.elitesland.yst.production.inv.infr.dto.InvWhAreaSettingDTO;
import com.elitesland.yst.production.inv.utils.InvUdcEnum;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="InvWhAreaSettingService")
public class InvWhAreaSettingServiceImpl
implements InvWhAreaSettingService {
    private static final Logger log = LoggerFactory.getLogger(InvWhAreaSettingServiceImpl.class);
    private final InvWhAreaSettingDomainService invWhAreaSettingDomainService;
    private final SystemService systemService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> createOne(InvWhAreaSettingSaveVO saveVo) {
        saveVo.setWhType(this.transitionWhTypeCode(saveVo.getWhTypes()));
        InvWhAreaSetting invWhAreaSetting = InvWhAreaSettingConvert.INSTANCE.saveVoToEn(saveVo);
        invWhAreaSetting.setStatus(InvUdcEnum.INV_ACTIVE_STATUS_ACTIVE.getValueCode());
        this.checkMandatory(invWhAreaSetting);
        this.checkDeter2AndDeter2Name(invWhAreaSetting);
        Long id = this.invWhAreaSettingDomainService.saveInvWhAreaSetting(invWhAreaSetting, Optional.empty());
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> update(InvWhAreaSettingSaveVO saveVo) {
        Optional<InvWhAreaSettingDTO> whAreaSetOptional = this.invWhAreaSettingDomainService.findById(saveVo.getId());
        if (whAreaSetOptional.isEmpty()) {
            return ApiResult.fail((String)"\u672a\u67e5\u8be2\u5230\u529f\u80fd\u533a\u914d\u7f6e\u4fe1\u606f!");
        }
        saveVo.setWhType(this.transitionWhTypeCode(saveVo.getWhTypes()));
        InvWhAreaSetting invWhAreaSetting = InvWhAreaSettingConvert.INSTANCE.saveVoToEn(saveVo);
        this.checkMandatory(invWhAreaSetting);
        this.checkDeter2AndDeter2Name(invWhAreaSetting);
        Long id = this.invWhAreaSettingDomainService.saveInvWhAreaSetting(invWhAreaSetting, whAreaSetOptional);
        return ApiResult.ok((Object)id);
    }

    private void checkMandatory(InvWhAreaSetting invWhAreaSetting) {
        if (!StringUtils.hasLength((String)invWhAreaSetting.getDeter2Type())) {
            throw new BusinessException(ApiCode.FAIL, "\u529f\u80fd\u533a\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (!StringUtils.hasLength((String)invWhAreaSetting.getDeter2TypeName())) {
            throw new BusinessException(ApiCode.FAIL, "\u529f\u80fd\u533a\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (Objects.isNull(invWhAreaSetting.getBusinessChoose())) {
            throw new BusinessException(ApiCode.FAIL, "\u5efa\u4ed3\u524d\u7aef\u662f\u5426\u53ef\u9009\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (Objects.isNull(invWhAreaSetting.getIsZeroWh())) {
            throw new BusinessException(ApiCode.FAIL, "\u662f\u5426\u96f6\u4ef7\u5e93\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (!StringUtils.hasLength((String)invWhAreaSetting.getStatus())) {
            throw new BusinessException(ApiCode.FAIL, "\u662f\u5426\u542f\u7528\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (!StringUtils.hasLength((String)invWhAreaSetting.getWhType())) {
            throw new BusinessException(ApiCode.FAIL, "\u53ef\u4f7f\u7528\u4ed3\u5e93\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }

    private void checkDeter2AndDeter2Name(InvWhAreaSetting whAreaSet) {
        InvWhAreaSettingParamVO param = new InvWhAreaSettingParamVO();
        param.setDeter2Type(whAreaSet.getDeter2Type());
        List<InvWhAreaSettingDTO> whAreaSetList = this.invWhAreaSettingDomainService.selectByParam(param);
        Optional<InvWhAreaSettingDTO> whAreaSetOptional = whAreaSetList.stream().filter(dto -> Objects.equals(whAreaSet.getDeter2Type(), dto.getDeter2Type()) && !Objects.equals(whAreaSet.getId(), dto.getId())).findFirst();
        whAreaSetOptional.ifPresent(whAreaSetDTO -> {
            throw new BusinessException(ApiCode.FAIL, "\u529f\u80fd\u533a\u7c7b\u578b\u7f16\u7801\u5df2\u5b58\u5728-(" + whAreaSetDTO.getDeter2Type() + ")!");
        });
        param.setDeter2Type(null);
        param.setDeter2TypeName(whAreaSet.getDeter2TypeName());
        List<InvWhAreaSettingDTO> whAreaSetNameList = this.invWhAreaSettingDomainService.selectByParam(param);
        Optional<InvWhAreaSettingDTO> whAreaSetNameOptional = whAreaSetNameList.stream().filter(dto -> Objects.equals(whAreaSet.getDeter2TypeName(), dto.getDeter2TypeName()) && !Objects.equals(whAreaSet.getId(), dto.getId())).findFirst();
        whAreaSetNameOptional.ifPresent(whAreaSetDTO -> {
            throw new BusinessException(ApiCode.FAIL, "\u529f\u80fd\u533a\u7c7b\u578b\u540d\u79f0\u5df2\u5b58\u5728-(" + whAreaSetDTO.getDeter2TypeName() + ")!");
        });
    }

    @Override
    @SysCodeProc
    public ApiResult<InvWhAreaSettingRespVO> findIdOne(Long id) {
        Optional<InvWhAreaSettingDTO> whAreaSetOptional = this.invWhAreaSettingDomainService.findById(id);
        if (whAreaSetOptional.isEmpty()) {
            return ApiResult.fail((String)"\u672a\u67e5\u8be2\u5230\u529f\u80fd\u533a\u914d\u7f6e\u4fe1\u606f!");
        }
        InvWhAreaSettingDTO invWhAreaSettingDTO = whAreaSetOptional.get();
        invWhAreaSettingDTO.setWhTypes(this.transitionWhTypeCodeList(invWhAreaSettingDTO.getWhType()));
        this.transitionWhTypeCodeName(Collections.singletonList(invWhAreaSettingDTO));
        InvWhAreaSettingRespVO invWhAreaSettingRespVO = InvWhAreaSettingConvert.INSTANCE.dtoToRespVo(invWhAreaSettingDTO);
        return ApiResult.ok((Object)invWhAreaSettingRespVO);
    }

    @Override
    @SysCodeProc
    public Optional<InvWhAreaSettingRespVO> findByDeter2(String deter2) {
        Optional<InvWhAreaSettingDTO> whAreaSetOptional = this.invWhAreaSettingDomainService.findByDeter2(deter2);
        if (whAreaSetOptional.isEmpty()) {
            return Optional.empty();
        }
        InvWhAreaSettingDTO invWhAreaSettingDTO = whAreaSetOptional.get();
        invWhAreaSettingDTO.setWhTypes(this.transitionWhTypeCodeList(invWhAreaSettingDTO.getWhType()));
        this.transitionWhTypeCodeName(Collections.singletonList(invWhAreaSettingDTO));
        InvWhAreaSettingRespVO invWhAreaSettingRespVO = InvWhAreaSettingConvert.INSTANCE.dtoToRespVo(invWhAreaSettingDTO);
        return Optional.of(invWhAreaSettingRespVO);
    }

    @Override
    public List<InvWhAreaSettingRespVO> findByDeter2s(List<String> deter2s) {
        List<InvWhAreaSettingDTO> invWhAreaSettingDTOS = this.invWhAreaSettingDomainService.findByDeter2Batch(deter2s);
        if (CollectionUtils.isEmpty(invWhAreaSettingDTOS)) {
            return Collections.EMPTY_LIST;
        }
        List<InvWhAreaSettingRespVO> whAreaSettingRespVOS = invWhAreaSettingDTOS.stream().map(InvWhAreaSettingConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());
        return whAreaSettingRespVOS;
    }

    @Override
    public List<InvWhAreaSettingRespVO> findByDeter2Types(List<String> deter2Types) {
        return this.invWhAreaSettingDomainService.findByDeter2Types(deter2Types);
    }

    @Override
    @SysCodeProc
    public List<InvWhAreaSettingRespVO> findByDeter2Batch(List<String> deter2List) {
        List<InvWhAreaSettingDTO> invWhAreaSettingDTOList = this.invWhAreaSettingDomainService.findByDeter2Batch(deter2List);
        if (CollectionUtils.isEmpty(invWhAreaSettingDTOList)) {
            return Collections.EMPTY_LIST;
        }
        invWhAreaSettingDTOList.forEach(invWhAreaSettingDTO -> invWhAreaSettingDTO.setWhTypes(this.transitionWhTypeCodeList(invWhAreaSettingDTO.getWhType())));
        this.transitionWhTypeCodeName(invWhAreaSettingDTOList);
        List<InvWhAreaSettingRespVO> whAreaSettingRespVOList = invWhAreaSettingDTOList.stream().map(InvWhAreaSettingConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());
        return whAreaSettingRespVOList;
    }

    @Override
    @SysCodeProc
    public PagingVO<InvWhAreaSettingRespVO> search(InvWhAreaSettingParamVO param) {
        PagingVO<InvWhAreaSettingDTO> pagingVo = this.invWhAreaSettingDomainService.search(param);
        if (CollectionUtils.isEmpty((Collection)pagingVo.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List vos = pagingVo.getRecords();
        vos.forEach(invWhAreaSettingDTO -> invWhAreaSettingDTO.setWhTypes(this.transitionWhTypeCodeList(invWhAreaSettingDTO.getWhType())));
        this.transitionWhTypeCodeName(vos);
        List whAreaSettingRespVOList = vos.stream().map(InvWhAreaSettingConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());
        return PagingVO.builder().total(pagingVo.getTotal()).records(whAreaSettingRespVOList).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<String> deleteBatch(List<Long> ids) {
        this.invWhAreaSettingDomainService.updateDeleteFlagByIds(1, ids);
        return ApiResult.ok();
    }

    private String transitionWhTypeCode(List<String> whTypeCodes) {
        if (CollectionUtils.isEmpty(whTypeCodes)) {
            return null;
        }
        String whTypeCode = String.join((CharSequence)",", whTypeCodes);
        return whTypeCode;
    }

    private void transitionWhTypeCodeName(List<InvWhAreaSettingDTO> whAreaSetDtoList) {
        Map<String, String> map = this.systemService.sysUdcGetCodeMap(InvUdcEnum.INV_WH_TYPE_1.getModel(), InvUdcEnum.INV_WH_TYPE_1.getCode());
        whAreaSetDtoList.forEach(invWhAreaSettingDTO -> {
            ArrayList list = new ArrayList();
            if (!CollectionUtils.isEmpty(invWhAreaSettingDTO.getWhTypes()) && !MapUtils.isEmpty((Map)map)) {
                invWhAreaSettingDTO.getWhTypes().forEach(str -> list.add((String)map.get(str)));
            }
            String whTypeCodeName = list.stream().map(String::valueOf).collect(Collectors.joining(","));
            invWhAreaSettingDTO.setWhTypeName(whTypeCodeName);
            this.transitionName((InvWhAreaSettingDTO)invWhAreaSettingDTO);
        });
    }

    private List<String> transitionWhTypeCodeList(String whTypeCode) {
        if (StringUtils.isEmpty((Object)whTypeCode)) {
            return Collections.EMPTY_LIST;
        }
        List<String> list = Arrays.asList(whTypeCode.split(","));
        return list;
    }

    @Override
    @SysCodeProc
    public List<InvWhAreaSettingRespVO> findAllActives(InvWhAreaSettingParamVO paramVO) {
        if (StringUtils.isEmpty((Object)paramVO.getStatus())) {
            throw new BusinessException(ApiCode.FAIL, "\u8bf7\u4f20\u5165\u662f\u5426\u542f\u7528\u53c2\u6570");
        }
        List<InvWhAreaSettingDTO> invWhAreaSettingDTOS = this.invWhAreaSettingDomainService.selectByParam(paramVO);
        if (CollectionUtils.isEmpty(invWhAreaSettingDTOS)) {
            return Collections.EMPTY_LIST;
        }
        Map<String, String> pTypeMap = this.systemService.sysUdcGetCodeMap(UdcEnum.INV_PARTNER_TYPE_CUST.getModel(), UdcEnum.INV_PARTNER_TYPE_CUST.getCode());
        invWhAreaSettingDTOS.forEach(invWhAreaSettingDTO -> invWhAreaSettingDTO.setWhTypes(this.transitionWhTypeCodeList(invWhAreaSettingDTO.getWhType())));
        this.transitionWhTypeCodeName(invWhAreaSettingDTOS);
        List<InvWhAreaSettingRespVO> whAreaSettingRespVOList = invWhAreaSettingDTOS.stream().map(InvWhAreaSettingConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());
        return whAreaSettingRespVOList;
    }

    @Override
    public List<SelectOptionVO> listDeter2Type(SelectOptionParam select) {
        return this.invWhAreaSettingDomainService.listDeter2Type(select);
    }

    private void transitionName(InvWhAreaSettingDTO whAreaSetDTO) {
        if (!StringUtils.isEmpty((Object)whAreaSetDTO.getBusinessChoose())) {
            String businessChooseName = whAreaSetDTO.getBusinessChoose() != false ? InvUdcEnum.INV_BUSINESS_CHOOSE_Y.getValueCodeName() : InvUdcEnum.INV_BUSINESS_CHOOSE_N.getValueCodeName();
            whAreaSetDTO.setBusinessChooseName(businessChooseName);
        }
        if (!StringUtils.isEmpty((Object)whAreaSetDTO.getIsZeroWh())) {
            String isZeroWhName = whAreaSetDTO.getIsZeroWh() != false ? InvUdcEnum.INV_ZERO_WH_Y.getValueCodeName() : InvUdcEnum.INV_ZERO_WH_N.getValueCodeName();
            whAreaSetDTO.setIsZeroWhName(isZeroWhName);
        }
    }

    private void transitionNameBatch(List<InvWhAreaSettingDTO> whAreaSetDtoList) {
        whAreaSetDtoList.forEach(whAreaSetDTO -> this.transitionName((InvWhAreaSettingDTO)whAreaSetDTO));
    }

    public InvWhAreaSettingServiceImpl(InvWhAreaSettingDomainService invWhAreaSettingDomainService, SystemService systemService) {
        this.invWhAreaSettingDomainService = invWhAreaSettingDomainService;
        this.systemService = systemService;
    }
}

