/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.provider;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhRespVO;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvTrnDService;
import com.elitesland.yst.production.inv.application.service.InvTrnService;
import com.elitesland.yst.production.inv.application.service.InvWhAreaService;
import com.elitesland.yst.production.inv.domain.convert.InvTrnConvert;
import com.elitesland.yst.production.inv.domain.entity.invtrn.InvTrn;
import com.elitesland.yst.production.inv.domain.entity.invtrn.InvTrnD;
import com.elitesland.yst.production.inv.domain.service.InvTrnDDomainService;
import com.elitesland.yst.production.inv.domain.service.InvTrnDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhDomainService;
import com.elitesland.yst.production.inv.dto.invTrn.InvTrnResultRpcDTO;
import com.elitesland.yst.production.inv.dto.invTrn.InvTrnSaveRpcDTO;
import com.elitesland.yst.production.inv.provider.InvTrnProvider;
import com.elitesland.yst.production.inv.utils.BeanCopyUtil;
import com.elitesland.yst.production.inv.utils.NumSendObjectEnum;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.inv.utils.ValidationUtil;
import com.google.common.util.concurrent.AtomicDouble;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"/invTrn"})
public class InvTrnProviderImpl
implements InvTrnProvider {
    private static final Logger log = LoggerFactory.getLogger(InvTrnProviderImpl.class);
    private final InvTrnDomainService invTrnDomainService;
    private final InvTrnDDomainService invTrnDDomainService;
    private final InvWhDomainService invWhDomainService;
    private final SystemService systemService;
    private final InvWhAreaService invWhAreaService;
    private final InvTrnDService invTrnDService;
    private final InvTrnService invTrnService;

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<InvTrnResultRpcDTO> submitInvTrn(InvTrnSaveRpcDTO invTrnSaveRpcDTO) {
        log.info("\u5e93\u5b58\u8f6c\u79fb\u751f\u5355\u5f00\u59cb\uff1a{}", (Object)JSON.toJSONString((Object)invTrnSaveRpcDTO));
        try {
            this.saveCheckIn(invTrnSaveRpcDTO);
            List details = invTrnSaveRpcDTO.getDetails();
            InvTrn invTrn = InvTrnConvert.INSTANCE.saveRpcDTOToInvTrn(invTrnSaveRpcDTO);
            invTrn.setDocStatus(UdcEnum.INV_TRN_STATUS_APPING.getValueCode());
            invTrn.setProcInstStatus(ProcInstStatus.APPROVING);
            invTrn.setSubmitTime(LocalDateTime.now());
            invTrn.setApprTime(LocalDateTime.now());
            invTrn.setApplyDate(LocalDateTime.now());
            invTrn.setOuCode(invTrnSaveRpcDTO.getOOuCode());
            invTrn.setOuId(invTrnSaveRpcDTO.getOOuId());
            InvWhRespVO invWhRespVO = this.invWhDomainService.findByWhId(invTrnSaveRpcDTO.getOWhId());
            if (invWhRespVO == null) {
                throw new BusinessException(ApiCode.FAIL, "\u4ed3\u5e93\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            }
            invTrn.setSecBuId(invWhRespVO.getSecBuId());
            invTrn.setSecOuId(invTrnSaveRpcDTO.getOOuId());
            ArrayList<String> runtimeValues = new ArrayList<String>();
            runtimeValues.add(invTrnSaveRpcDTO.getOOuCode());
            String code = this.systemService.sysNumberRuleGenerateCode(NumSendObjectEnum.INV_IT.getCode(), runtimeValues);
            invTrn.setDocNo(code);
            Long id = this.invTrnDomainService.create(invTrn);
            AtomicDouble linoNo = new AtomicDouble(0.0);
            List<InvTrnD> invTrnDS = details.stream().map(d -> {
                InvTrnD invTrnD = new InvTrnD();
                BeanCopyUtil.beanCopyWithIngore(d, invTrnD, BeanCopyUtil.getNullPropertyNames(d));
                invTrnD.setMasId(id);
                invTrnD.setLineNo(linoNo.addAndGet(1.0));
                return invTrnD;
            }).collect(Collectors.toList());
            this.invTrnDDomainService.createBatch(invTrnDS);
            InvTrnResultRpcDTO resultRpcDTO = new InvTrnResultRpcDTO();
            resultRpcDTO.setDocNo(invTrn.getDocNo());
            resultRpcDTO.setId(id);
            return ApiResult.ok((Object)resultRpcDTO);
        }
        catch (Exception e) {
            throw new BusinessException(ApiCode.FAIL, "\u64cd\u4f5c\u5931\u8d25:" + e.getMessage());
        }
    }

    private void saveCheckIn(InvTrnSaveRpcDTO invTrnSaveVO) {
        if (CollectionUtils.isEmpty((Collection)invTrnSaveVO.getDetails())) {
            throw new BusinessException(ApiCode.FAIL, "\u53c2\u6570\u9519\u8bef\uff0c\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ValidationUtil.ValidResult validResult = ValidationUtil.validate(invTrnSaveVO);
        if (validResult.isError()) {
            throw new BusinessException("\u4e3b\u6570\u636e\u53c2\u6570\u9519\u8bef\uff0c\u79fb\u5e93\u539f\u56e0\u3001\u7533\u8bf7\u65e5\u671f\u3001\u4ece\u4ed3\u5e93\u3001\u81f3\u4ed3\u5e93\u3001\u4ece\u529f\u80fd\u5e93\u533a\u3001\u81f3\u529f\u80fd\u5e93\u533a\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ValidationUtil.ValidResult validResult2 = ValidationUtil.validate(invTrnSaveVO.getDetails());
        if (validResult2.isError()) {
            throw new BusinessException("\u660e\u7ec6\u6570\u636e\u53c2\u6570\u9519\u8bef\uff0c\u4ece\u529f\u80fd\u5e93\u533a\u3001\u81f3\u529f\u80fd\u5e93\u533a\u3001\u8f6c\u79fb\u6570\u91cf\u3001\u4ece\u4ed3\u5e93\u3001\u81f3\u4ed3\u5e93 \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!invTrnSaveVO.getOOuId().toString().equals(invTrnSaveVO.getIOuId().toString())) {
            throw new BusinessException("\u79fb\u5165\u548c\u79fb\u51fa\u4ed3\u5e93\u516c\u53f8\u975e\u540c\u4e00\u516c\u53f8\u8bf7\u68c0\u67e5\uff01");
        }
        List<InvWhAreaRespVO> whAreaList = this.invWhAreaService.findAllByWhId(invTrnSaveVO.getDetails().stream().map(InvTrnSaveRpcDTO.InvTrnDetail::getOWhId).collect(Collectors.toList()));
        long count = whAreaList.stream().filter(v -> UdcEnum.INV_FUNC_TYPE_9.getValueCode().equals(v.getDeter2())).distinct().count();
        if (count < 1L) {
            throw new BusinessException("\u4ece\u4ed3\u5e93" + invTrnSaveVO.getOWhCode() + "\u6ca1\u6709\u9ed8\u8ba4\u5728\u9014\u529f\u80fd\u533a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        long count2 = invTrnSaveVO.getDetails().stream().map(v -> v.getItemId() + v.getOWhId() + "_" + v.getODeter2() + v.getIWhId() + "_" + v.getIDeter2() + "_" + v.getIPCode() + "_" + v.getIPType() + "_" + v.getOPCode() + "_" + v.getOPType()).distinct().count();
        if (count2 != (long)invTrnSaveVO.getDetails().size()) {
            throw new BusinessException("\u660e\u7ec6\u6570\u636e\u53c2\u6570\u9519\u8bef\uff0c\u5546\u54c1ID,\u4ece\u4ed3\u5e93/\u4ece\u529f\u80fd\u533a,\u81f3\u529f\u80fd\u533a/\u81f3\u529f\u80fd\u5e93\u533a\u5b58\u5728\u76f8\u540c\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
        }
        List<Long> owhIds = invTrnSaveVO.getDetails().stream().map(InvTrnSaveRpcDTO.InvTrnDetail::getOWhId).collect(Collectors.toList());
        List<Long> iwhIds = invTrnSaveVO.getDetails().stream().map(InvTrnSaveRpcDTO.InvTrnDetail::getIWhId).collect(Collectors.toList());
        InvWhAreaParamVO areaParamVO = new InvWhAreaParamVO();
        areaParamVO.setWhIds(owhIds);
        List<InvWhAreaRespVO> whAreasByParam1 = this.invWhAreaService.findWhAreasByParam(areaParamVO);
        areaParamVO.setWhIds(iwhIds);
        List<InvWhAreaRespVO> whAreasByParam2 = this.invWhAreaService.findWhAreasByParam(areaParamVO);
        invTrnSaveVO.getDetails().stream().forEach(d -> {
            List whAreaRespVOS;
            if (d.getOPCode() != null && d.getOPType() != null && CollectionUtils.isEmpty(whAreaRespVOS = whAreasByParam1.stream().filter(v -> d.getOPType().equals(v.getPType()) && d.getOPCode().equals(v.getPCode())).collect(Collectors.toList()))) {
                throw new BusinessException(String.format("\u4ece\u4ed3\u5e93\u3010%s\u3011\u529f\u80fd\u533a\u3010%s\u3011\u5408\u4f5c\u4f19\u4f34\u3010%s\u3011\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", d.getOWhCode(), d.getODeter2(), d.getOPName()));
            }
            if (d.getIPCode() != null && d.getIPType() != null && CollectionUtils.isEmpty(whAreaRespVOS = whAreasByParam2.stream().filter(v -> d.getIPType().equals(v.getPType()) && d.getIPCode().equals(v.getPCode())).collect(Collectors.toList()))) {
                throw new BusinessException(String.format("\u81f3\u4ed3\u5e93\u3010%s\u3011\u529f\u80fd\u533a\u3010%s\u3011\u5408\u4f5c\u4f19\u4f34[%s]\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", d.getIWhCode(), d.getIDeter2(), d.getIPName()));
            }
        });
    }

    public Long checkInvTrn(Long masId) {
        log.info("\u5e93\u5b58\u8f6c\u79fb\u5ba1\u6838\u5f00\u59cb\uff1a{}", (Object)masId);
        try {
            Long id = this.invTrnService.check(masId);
            return id;
        }
        catch (Exception e) {
            throw new BusinessException(ApiCode.FAIL, "\u5ba1\u6838\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public Long confirmInvTrn(Long masId) {
        log.info("\u5e93\u5b58\u8f6c\u79fb\u79fb\u5e93\u786e\u8ba4\u5f00\u59cb\uff1a{}", (Object)masId);
        try {
            this.invTrnDService.confirm(masId);
            return masId;
        }
        catch (Exception e) {
            throw new BusinessException(ApiCode.FAIL, "\u6536\u8d27\u786e\u8ba4\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public Long recvConfirmInvTrn(Long masId) {
        log.info("\u5e93\u5b58\u8f6c\u79fb\u6536\u8d27\u786e\u8ba4\u5f00\u59cb\uff1a{}", (Object)masId);
        try {
            this.invTrnDService.recevieConfirm(masId, false);
            return masId;
        }
        catch (Exception e) {
            throw new BusinessException(ApiCode.FAIL, "\u79fb\u5e93\u786e\u8ba4\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public InvTrnProviderImpl(InvTrnDomainService invTrnDomainService, InvTrnDDomainService invTrnDDomainService, InvWhDomainService invWhDomainService, SystemService systemService, InvWhAreaService invWhAreaService, InvTrnDService invTrnDService, InvTrnService invTrnService) {
        this.invTrnDomainService = invTrnDomainService;
        this.invTrnDDomainService = invTrnDDomainService;
        this.invWhDomainService = invWhDomainService;
        this.systemService = systemService;
        this.invWhAreaService = invWhAreaService;
        this.invTrnDService = invTrnDService;
        this.invTrnService = invTrnService;
    }
}

