/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.service.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tms.api.vo.TmsOuQueryParamVO;
import com.elitesland.tms.api.vo.TmsOuRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.carr.InvCarrDRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.carr.InvCarrDSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.carr.InvCarrFileRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.carr.InvCarrFileSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.carr.InvCarrParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.carr.InvCarrRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.carr.InvCarrSaveVO;
import com.elitesland.yst.production.inv.application.out.ComFileOutService;
import com.elitesland.yst.production.inv.application.out.ItmOutService;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.PurDubbleService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.out.TmsOutService;
import com.elitesland.yst.production.inv.application.service.InvCarrService;
import com.elitesland.yst.production.inv.domain.convert.carr.InvCarrConvert;
import com.elitesland.yst.production.inv.domain.convert.carr.InvCarrDConvert;
import com.elitesland.yst.production.inv.domain.convert.carr.InvCarrFileConvert;
import com.elitesland.yst.production.inv.domain.entity.carr.InvCarrDDO;
import com.elitesland.yst.production.inv.domain.entity.carr.InvCarrDO;
import com.elitesland.yst.production.inv.domain.entity.carr.InvCarrFileDO;
import com.elitesland.yst.production.inv.domain.entity.carr.QInvCarrDDO;
import com.elitesland.yst.production.inv.domain.entity.carr.QInvCarrDO;
import com.elitesland.yst.production.inv.infr.repo.carr.InvCarrDRepo;
import com.elitesland.yst.production.inv.infr.repo.carr.InvCarrDRepoProc;
import com.elitesland.yst.production.inv.infr.repo.carr.InvCarrFileRepo;
import com.elitesland.yst.production.inv.infr.repo.carr.InvCarrRepo;
import com.elitesland.yst.production.inv.infr.repo.carr.InvCarrRepoProc;
import com.elitesland.yst.production.inv.utils.InvUdcEnum;
import com.elitesland.yst.production.pur.dto.ss.PurSsDTO;
import com.elitesland.yst.production.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitesland.yst.production.pur.file.vo.ComFileUploadRespVO;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class InvCarrServiceImpl
implements InvCarrService {
    private final InvCarrRepo invCarrRepo;
    private final InvCarrDRepo invCarrDRepo;
    private final InvCarrRepoProc invCarrRepoProc;
    private final InvCarrDRepoProc invCarrDRepoProc;
    private final SystemService systemService;
    private final PurDubbleService purDubbleService;
    private final OrgOutService orgOutService;
    private final TmsOutService tmsOutService;
    private final ItmOutService itmOutService;
    private final InvCarrFileRepo invCarrFileRepo;
    private final ComFileOutService comFileOutService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveInvCarr(InvCarrSaveVO invCarrSaveVO, boolean isSubmit) {
        Long id = 0L;
        Long relateDocId = invCarrSaveVO.getRelateDocId();
        InvCarrParamVO invCarrParamVO = new InvCarrParamVO();
        invCarrParamVO.setRelateDocId(relateDocId);
        List invCarrRespVOS = this.invCarrRepoProc.select(invCarrParamVO).fetch();
        invCarrRespVOS = invCarrRespVOS.stream().filter(f -> !f.getId().equals(invCarrSaveVO.getId())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(invCarrRespVOS)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6b64\u53d1\u8d27\u5355\u5df2\u521b\u5efa\u8fc7\u914d\u9001\u5355\uff0c\u4e0d\u80fd\u91cd\u590d\u521b\u5efa\uff01");
        }
        InvCarrDO invCarrDO = InvCarrConvert.INSTANCE.saveVOToDO(invCarrSaveVO);
        if (StringUtils.isEmpty((Object)invCarrSaveVO.getDocNo())) {
            String docNo = this.systemService.sysNumberRuleGenerateCode("CARR", Collections.EMPTY_LIST);
            invCarrDO.setDocNo(docNo);
        }
        invCarrDO.setDocStatus(InvUdcEnum.INV_CARR_STATUS_DR.getValueCode());
        if (isSubmit) {
            invCarrDO.setDocStatus(InvUdcEnum.INV_CARR_STATUS_SUBMIT.getValueCode());
        }
        id = ((InvCarrDO)this.invCarrRepo.save(invCarrDO)).getId();
        PurSsDTO purSsDTO = new PurSsDTO();
        purSsDTO.setCarrierContactName(invCarrDO.getCarrierContactName());
        purSsDTO.setCarrierContactTel(invCarrDO.getCarrierContactTel());
        purSsDTO.setCarrierSuppId(invCarrDO.getCarrierSuppId());
        purSsDTO.setId(relateDocId);
        this.purDubbleService.updateCarrierInfo(purSsDTO);
        Long finalId = id;
        List<InvCarrDSaveVO> invCarrDSaveVOS = invCarrSaveVO.getInvCarrDSaveVOS();
        if (CollectionUtils.isEmpty(invCarrDSaveVOS)) {
            return id;
        }
        this.invCarrDRepo.deleteByMasId(id);
        List invCarrDDOS = invCarrDSaveVOS.stream().map(e -> {
            InvCarrDDO invCarrDDO = InvCarrDConvert.INSTANCE.saveVOToDO((InvCarrDSaveVO)e);
            invCarrDDO.setMasId(finalId);
            return invCarrDDO;
        }).collect(Collectors.toList());
        this.invCarrDRepo.saveAll(invCarrDDOS);
        this.invCarrFileRepo.deleteByMasId(id);
        List<InvCarrFileSaveVO> invCarrFileSaveVOS = invCarrSaveVO.getInvCarrFileSaveVOS();
        if (!CollectionUtils.isEmpty(invCarrFileSaveVOS)) {
            List invCarrFileDOS = invCarrFileSaveVOS.stream().map(file -> {
                InvCarrFileDO invCarrFileDO = InvCarrFileConvert.INSTANCE.saveVOToDO((InvCarrFileSaveVO)file);
                invCarrFileDO.setMasId(finalId);
                return invCarrFileDO;
            }).collect(Collectors.toList());
            this.invCarrFileRepo.saveAll(invCarrFileDOS);
        }
        if (invCarrDO.getRelateDocId() != null) {
            purSsDTO = new PurSsDTO();
            purSsDTO.setId(invCarrDO.getRelateDocId());
            purSsDTO.setCarriageFlag(Boolean.valueOf(true));
            this.purDubbleService.updateIsCarrige(purSsDTO);
        }
        return id;
    }

    @Override
    @SysCodeProc
    public InvCarrRespVO detail(Long id) {
        if (id == null) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Optional carrDOOptional = this.invCarrRepo.findById(id);
        if (carrDOOptional.isEmpty()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5355\u636e\u4e0d\u5b58\u5728\uff01");
        }
        InvCarrDO invCarrDO = (InvCarrDO)carrDOOptional.get();
        InvCarrRespVO invCarrRespVO = InvCarrConvert.INSTANCE.doToRespVO(invCarrDO);
        this.convertCarrInfo(Arrays.asList(invCarrRespVO));
        JPAQuery jpaQuery = (JPAQuery)this.invCarrDRepoProc.select(null).where((Predicate)QInvCarrDDO.invCarrDDO.masId.eq((Object)id));
        List invCarrDRespVOS = jpaQuery.fetch();
        this.convertCarrDInfo(invCarrDRespVOS);
        invCarrRespVO.setInvCarrDRespVOS(invCarrDRespVOS);
        List<InvCarrFileDO> invCarrFileDOS = this.invCarrFileRepo.findByMasId(invCarrDO.getId());
        if (CollectionUtils.isEmpty(invCarrFileDOS)) {
            return invCarrRespVO;
        }
        List<InvCarrFileRespVO> invCarrFileRespVOS = invCarrFileDOS.stream().map(file -> {
            List<String> fileCodeList;
            List<ComFileUploadRespVO> fileUploadRespVOS;
            InvCarrFileRespVO respVO = InvCarrFileConvert.INSTANCE.doToRespVO((InvCarrFileDO)file);
            if (!StringUtils.isEmpty((Object)respVO.getFileCode()) && !CollectionUtils.isEmpty(fileUploadRespVOS = this.comFileOutService.findByFileCodeIn(fileCodeList = Arrays.asList(respVO.getFileCode().split(","))).stream().map(t -> {
                ComFileUploadRespVO respVO1 = new ComFileUploadRespVO();
                respVO1.setId(t.getId());
                respVO1.setFileCode(t.getFileCode());
                respVO1.setModifyTime(t.getModifyTime());
                respVO1.setOriginalName(t.getOriginalName());
                respVO1.setUploadName(t.getUploadName());
                return respVO1;
            }).collect(Collectors.toList()))) {
                respVO.setFileUploadRespVOS(fileUploadRespVOS);
            }
            return respVO;
        }).collect(Collectors.toList());
        invCarrRespVO.setInvCarrFileRespVOS(invCarrFileRespVOS);
        return invCarrRespVO;
    }

    private void convertCarrDInfo(List<InvCarrDRespVO> invCarrDRespVOS) {
        List itemIdList = invCarrDRespVOS.stream().filter(f -> f.getItemId() != null).map(InvCarrDRespVO::getItemId).collect(Collectors.toList());
        ItmItemRpcDtoParam itmItemRpcDtoParam = new ItmItemRpcDtoParam();
        itmItemRpcDtoParam.setItemIds(itemIdList);
        List<ItmItemRpcDTO> itmItemRpcDTOS = this.itmOutService.findItemRpcDtoByParam(itmItemRpcDtoParam);
        for (InvCarrDRespVO respVO : invCarrDRespVOS) {
            if (CollectionUtils.isEmpty(itmItemRpcDTOS)) continue;
            itmItemRpcDTOS.stream().filter(f -> f.getId().equals(respVO.getItemId())).findFirst().ifPresent(itm -> {
                respVO.setItemCode(itm.getItemCode());
                respVO.setItemName(itm.getItemName());
                respVO.setItemSpec(itm.getSpec());
            });
        }
    }

    @Override
    @SysCodeProc
    public PagingVO<InvCarrRespVO> list(InvCarrParamVO invCarrParamVO) {
        PagingVO pagingVO = new PagingVO();
        JPAQuery<InvCarrRespVO> jpaQuery = this.invCarrRepoProc.select(invCarrParamVO);
        long count = jpaQuery.fetchCount();
        this.invCarrRepoProc.openOrderAndLimit(jpaQuery, invCarrParamVO, QInvCarrDO.invCarrDO);
        List invCarrRespVOS = jpaQuery.fetch();
        this.convertCarrInfo(invCarrRespVOS);
        pagingVO.setTotal(count);
        pagingVO.setRecords(invCarrRespVOS);
        return pagingVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteInvCarr(Long id) {
        Optional invCarrDOOptional = this.invCarrRepo.findById(id);
        if (invCarrDOOptional.isEmpty()) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u5355\u636e\u4e0d\u5b58\u5728\uff01");
        }
        InvCarrDO invCarrDO = (InvCarrDO)invCarrDOOptional.get();
        if (invCarrDO.getRelateDocId() != null) {
            PurSsDTO purSsDTO = new PurSsDTO();
            purSsDTO.setId(invCarrDO.getRelateDocId());
            purSsDTO.setCarriageFlag(Boolean.valueOf(false));
            this.purDubbleService.updateIsCarrige(purSsDTO);
        }
        this.invCarrRepo.deleteById(id);
        this.invCarrDRepo.deleteByMasId(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void commitInvCarr(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.invCarrRepoProc.updateInvCarrStatus(ids, InvUdcEnum.INV_CARR_STATUS_SUBMIT.getValueCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateInvCarrStatus(List<Long> ids, String docStatus) {
        this.invCarrRepoProc.updateInvCarrStatus(ids, docStatus);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateInvCarrStatusByRelateDocId(Long relateDocId, String docStatus) {
        this.invCarrRepoProc.updateInvCarrStatusByRelateDocId(relateDocId, docStatus);
    }

    private void convertCarrInfo(List<InvCarrRespVO> invCarrRespVOS) {
        List<TmsOuRespVO> tmsOuDTOS = null;
        List<Long> carrierSuppIdList = invCarrRespVOS.stream().filter(f -> f.getCarrierSuppId() != null).map(InvCarrRespVO::getCarrierSuppId).collect(Collectors.toList());
        List<Long> suppIdList = invCarrRespVOS.stream().filter(f -> f.getSuppId() != null).map(InvCarrRespVO::getSuppId).distinct().collect(Collectors.toList());
        List<Long> ouIdList = invCarrRespVOS.stream().filter(f -> f.getOuId() != null).map(InvCarrRespVO::getOuId).distinct().collect(Collectors.toList());
        List logisticsOuCodeList = invCarrRespVOS.stream().filter(f -> !StringUtils.isEmpty((Object)f.getLogisticsOuCode())).map(InvCarrRespVO::getLogisticsOuCode).collect(Collectors.toList());
        List<PurSuppBaseRpcDTO> suppBaseList = this.purDubbleService.findSuppByIdBatch(suppIdList);
        List<OrgOuRpcDTO> orgOuRpcDTOS = this.orgOutService.findOuByIds(ouIdList);
        List<PurSuppBaseRpcDTO> carrierSuppList = this.purDubbleService.findSuppByIdBatch(carrierSuppIdList);
        if (!CollectionUtils.isEmpty(logisticsOuCodeList)) {
            TmsOuQueryParamVO tmsOuQueryParamVO = new TmsOuQueryParamVO();
            tmsOuQueryParamVO.setLogisticsOuCodes(logisticsOuCodeList);
            tmsOuDTOS = this.tmsOutService.findTmsOuList(tmsOuQueryParamVO);
        }
        for (InvCarrRespVO respVO : invCarrRespVOS) {
            if (!CollectionUtils.isEmpty(suppBaseList)) {
                suppBaseList.stream().filter(f -> f.getId().equals(respVO.getSuppId())).findFirst().ifPresent(supp -> {
                    respVO.setSuppCode(supp.getSuppCode());
                    respVO.setSuppName(supp.getSuppName());
                });
            }
            if (!CollectionUtils.isEmpty(orgOuRpcDTOS)) {
                orgOuRpcDTOS.stream().filter(f -> f.getId().equals(respVO.getOuId())).findFirst().ifPresent(ou -> {
                    respVO.setOuCode(ou.getOuCode());
                    respVO.setOuName(ou.getOuName());
                });
            }
            if (!CollectionUtils.isEmpty(carrierSuppList)) {
                carrierSuppList.stream().filter(f -> f.getId().equals(respVO.getCarrierSuppId())).findFirst().ifPresent(carr -> {
                    respVO.setCarrierSuppCode(carr.getSuppCode());
                    respVO.setCarrierSuppName(carr.getSuppName());
                });
            }
            if (CollectionUtils.isEmpty(tmsOuDTOS)) continue;
            tmsOuDTOS.stream().filter(f -> !StringUtils.isEmpty((Object)f.getLogisticsOuCode()) && f.getLogisticsOuCode().equals(respVO.getLogisticsOuCode())).findFirst().ifPresent(tms -> respVO.setLogisticsOuName(tms.getLogisticsOuName()));
        }
    }

    public InvCarrServiceImpl(InvCarrRepo invCarrRepo, InvCarrDRepo invCarrDRepo, InvCarrRepoProc invCarrRepoProc, InvCarrDRepoProc invCarrDRepoProc, SystemService systemService, PurDubbleService purDubbleService, OrgOutService orgOutService, TmsOutService tmsOutService, ItmOutService itmOutService, InvCarrFileRepo invCarrFileRepo, ComFileOutService comFileOutService) {
        this.invCarrRepo = invCarrRepo;
        this.invCarrDRepo = invCarrDRepo;
        this.invCarrRepoProc = invCarrRepoProc;
        this.invCarrDRepoProc = invCarrDRepoProc;
        this.systemService = systemService;
        this.purDubbleService = purDubbleService;
        this.orgOutService = orgOutService;
        this.tmsOutService = tmsOutService;
        this.itmOutService = itmOutService;
        this.invCarrFileRepo = invCarrFileRepo;
        this.comFileOutService = comFileOutService;
    }
}

