/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.provider.org.OrgRpcService;
import com.elitesland.yst.production.inv.application.facade.vo.SelectOptionParam;
import com.elitesland.yst.production.inv.application.facade.vo.SelectOptionVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.InvDespatchConfigPageVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.InvDespatchConfigRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.InvDespatchConfigSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.InvDespatchConfigWhPageVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.param.InvDespatchConfigDtlQueryParam;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.param.InvDespatchConfigQueryParam;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.whAreaSetting.InvWhAreaSettingRespVO;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvDespatchConfigService;
import com.elitesland.yst.production.inv.application.service.InvWhAreaSettingService;
import com.elitesland.yst.production.inv.application.service.InvWhService;
import com.elitesland.yst.production.inv.domain.convert.despatch.InvDespatchConfigConvert;
import com.elitesland.yst.production.inv.domain.service.InvDespatchConfigDomainService;
import com.elitesland.yst.production.inv.dto.invDes.resp.InvDespatchRpcDTO;
import com.elitesland.yst.production.inv.infr.dto.InvDespatchConfigDTO;
import com.elitesland.yst.production.inv.infr.repo.despatch.InvDespatchConfigProc;
import com.elitesland.yst.production.inv.utils.BeanCopyUtil;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service(value="invDespatchConfigBizService")
public class InvDespatchConfigServiceImpl
implements InvDespatchConfigService {
    private static final Logger log = LoggerFactory.getLogger(InvDespatchConfigServiceImpl.class);
    private final InvDespatchConfigDomainService invDespatchConfigDomainService;
    private final SystemService systemService;
    private final InvWhService invWhService;
    private final InvDespatchConfigProc invDespatchConfigProc;
    private final OrgOutService orgOutService;
    private final OrgRpcService orgRpcService;
    private final InvWhAreaSettingService invWhAreaSettingService;

    @Override
    public PagingVO<InvDespatchConfigPageVO> searchPage(InvDespatchConfigQueryParam queryParam) {
        PagingVO<InvDespatchConfigPageVO> page;
        List records;
        if (StringUtils.hasLength((String)queryParam.getDeter2KeyWord())) {
            List<InvWhRespVO> invWhRespVOS = this.invWhService.getDespatchWhByDeter2KeyWord(queryParam.getDeter2KeyWord());
            if (CollectionUtils.isEmpty(invWhRespVOS)) {
                return PagingVO.builder().total(0L).records(new ArrayList()).build();
            }
            List<String> desCodes = invWhRespVOS.stream().map(InvWhRespVO::getDesCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            queryParam.setDesCodes(desCodes);
        }
        if (!CollectionUtils.isEmpty((Collection)(records = (page = this.invDespatchConfigDomainService.searchPage(queryParam)).getRecords()))) {
            HashMap ouMap;
            List<String> desCodes = records.stream().map(InvDespatchConfigPageVO::getDesCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<InvDespatchConfigRespVO> configRespVOS = this.invDespatchConfigDomainService.getDeter2Count(desCodes);
            List<String> deter1List = records.stream().map(InvDespatchConfigPageVO::getDeter1).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<Object> orgOuRpcDTOList = CollectionUtil.isEmpty(deter1List) ? new ArrayList() : this.orgOutService.findOuByCodes(deter1List);
            Map<Object, Object> map = ouMap = CollectionUtil.isEmpty(orgOuRpcDTOList) ? new HashMap() : orgOuRpcDTOList.stream().collect(Collectors.toMap(OrgOuRpcDTO::getOuCode, t -> t, (t1, t2) -> t1));
            if (!CollectionUtils.isEmpty(configRespVOS)) {
                Map<String, List<InvDespatchConfigRespVO>> map2 = configRespVOS.stream().collect(Collectors.groupingBy(InvDespatchConfigRespVO::getDesCode));
                records.forEach(i -> {
                    if (map2.containsKey(i.getDesCode())) {
                        i.setDeter2Count(((InvDespatchConfigRespVO)((List)map2.get(i.getDesCode())).get(0)).getDeter2Count());
                    }
                });
            }
            Map<String, SysOrgBasicDTO> orgParentMap = this.selectParentByCodesAndParentType(desCodes.stream().collect(Collectors.toSet()), "COMPANY");
            records.forEach(i -> {
                SysOrgBasicDTO sysOrgParentDTO;
                OrgOuRpcDTO orgOuRpcDTO;
                if (ouMap.containsKey(i.getDeter1()) && Objects.nonNull(orgOuRpcDTO = (OrgOuRpcDTO)ouMap.get(i.getDeter1()))) {
                    i.setDeter1Name(orgOuRpcDTO.getOuName());
                    i.setOuId(orgOuRpcDTO.getId());
                }
                if (Objects.nonNull(sysOrgParentDTO = (SysOrgBasicDTO)orgParentMap.get(i.getDesCode()))) {
                    i.setParentCode(sysOrgParentDTO.getCode());
                    i.setSuperiorsCode(sysOrgParentDTO.getParentCode());
                }
            });
        }
        return PagingVO.builder().total(page.getTotal()).records(records).build();
    }

    @Override
    @Transactional
    public Long saveOrUpdate(InvDespatchConfigSaveVO createParam) {
        InvDespatchConfigDTO despatchConfigDTO;
        this.verifyParam(createParam);
        if (Objects.nonNull(createParam.getId())) {
            InvDespatchConfigDTO ret = this.invDespatchConfigDomainService.findIdOne(createParam.getId());
            if (ret == null) {
                throw new BusinessException(ApiCode.FAIL, "\u6570\u636e\u4e0d\u5b58\u5728");
            }
            BeanCopyUtil.beanCopyWithIngore(createParam, ret, BeanCopyUtil.getNullPropertyNames(createParam));
            despatchConfigDTO = ret;
        } else {
            despatchConfigDTO = InvDespatchConfigConvert.INSTANCE.saveVoToDto(createParam);
        }
        return this.invDespatchConfigDomainService.saveOrUpdate(despatchConfigDTO);
    }

    private void verifyParam(InvDespatchConfigSaveVO createParam) {
        long count;
        long count2;
        List<InvDespatchRpcDTO> despatchRpcDTOS = this.invDespatchConfigDomainService.findByDesName(createParam.getDesName());
        if (!CollectionUtils.isEmpty(despatchRpcDTOS) && (count2 = despatchRpcDTOS.stream().filter(i -> !i.getId().equals(createParam.getId())).count()) > 0L) {
            throw new BusinessException(ApiCode.FAIL, "\u5df2\u5b58\u5728\u76f8\u540c\u7684\u540d\u79f0\uff0c\u4e0d\u80fd\u91cd\u590d");
        }
        List<InvDespatchRpcDTO> byDesCode = this.invDespatchConfigDomainService.findByDesCode(createParam.getDesCode());
        if (!CollectionUtils.isEmpty(byDesCode) && (count = byDesCode.stream().filter(i -> !i.getId().equals(createParam.getId())).count()) > 0L) {
            throw new BusinessException(ApiCode.FAIL, "\u5df2\u5b58\u5728\u76f8\u540c\u7684\u7f16\u7801\uff0c\u4e0d\u80fd\u91cd\u590d");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)createParam.getDeter1())) {
            throw new BusinessException(ApiCode.FAIL, "\u6240\u5c5e\u516c\u53f8\u7f16\u7801\u4e3a\u7a7a");
        }
        if (Objects.isNull(createParam.getTradeCompanyFlag())) {
            throw new BusinessException(ApiCode.FAIL, "\u8d38\u6613\u516c\u53f8\u767d\u540d\u5355\u4e3a\u7a7a");
        }
    }

    @Override
    public InvDespatchConfigRespVO findIdOne(Long id) {
        OrgOuRpcDTO orgOuRpcDTO;
        InvDespatchConfigDTO configDTO = this.invDespatchConfigDomainService.findIdOne(id);
        InvDespatchConfigRespVO invDespatchConfigRespVO = InvDespatchConfigConvert.INSTANCE.dtoToVo(configDTO);
        if (Objects.nonNull(invDespatchConfigRespVO) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)invDespatchConfigRespVO.getDeter1()) && Objects.nonNull(orgOuRpcDTO = this.orgOutService.findOuByOuCode(invDespatchConfigRespVO.getDeter1()))) {
            invDespatchConfigRespVO.setDeter1Name(orgOuRpcDTO.getOuName());
        }
        return invDespatchConfigRespVO;
    }

    @Override
    public PagingVO<InvDespatchConfigWhPageVO> searchDtlPage(InvDespatchConfigDtlQueryParam param) {
        PagingVO<InvDespatchConfigWhPageVO> pagingVO = this.invDespatchConfigDomainService.searchDespatchWhPage(param);
        if (!CollectionUtils.isEmpty((Collection)pagingVO.getRecords())) {
            this.translateWhPageVO(pagingVO.getRecords());
        }
        return pagingVO;
    }

    @Override
    public Boolean enableDespatchConfig(List<Long> id, String isEnable) {
        return this.invDespatchConfigDomainService.enableDespatchConfig(id, isEnable);
    }

    @Override
    public List<SelectOptionVO> listDespatchConfig(SelectOptionParam selectOptionParam) {
        List<SelectOptionVO> selectOptionVOList = this.invDespatchConfigProc.listDespatchConfig(selectOptionParam);
        if (CollectionUtil.isEmpty(selectOptionVOList)) {
            return Collections.EMPTY_LIST;
        }
        if (Objects.nonNull(selectOptionParam.getSuperiorsFlag()) && selectOptionParam.getSuperiorsFlag().booleanValue()) {
            Set<String> codeSet = selectOptionVOList.stream().map(SelectOptionVO::getCode).filter(Objects::nonNull).distinct().collect(Collectors.toSet());
            Map<String, SysOrgBasicDTO> orgBasicDTOMap = this.systemService.getParentByCodeAndParentType(codeSet, "COMPANY");
            selectOptionVOList.forEach(selectOptionVO -> {
                SysOrgBasicDTO sysOrgBasicDTO = (SysOrgBasicDTO)orgBasicDTOMap.get(selectOptionVO.getCode());
                if (Objects.nonNull(sysOrgBasicDTO)) {
                    selectOptionVO.setParentCode(sysOrgBasicDTO.getCode());
                    selectOptionVO.setSuperiorsCode(sysOrgBasicDTO.getParentCode());
                }
            });
        }
        return selectOptionVOList;
    }

    private void translateWhPageVO(List<InvDespatchConfigWhPageVO> invDespatchConfigWhPageVOS) {
        List<Long> ouIds = invDespatchConfigWhPageVOS.stream().map(InvDespatchConfigWhPageVO::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<OrgOuRpcDTO> ouRpcDTOS = this.orgOutService.findOuByIds(ouIds);
        List<String> deter2Types = invDespatchConfigWhPageVOS.stream().map(InvDespatchConfigWhPageVO::getDeter2Type).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<InvWhAreaSettingRespVO> whAreaSettingRespVOS = this.invWhAreaSettingService.findByDeter2Types(deter2Types);
        Map<Long, List<OrgOuRpcDTO>> ouMap = null;
        if (!CollectionUtils.isEmpty(ouRpcDTOS)) {
            ouMap = ouRpcDTOS.stream().collect(Collectors.groupingBy(OrgOuRpcDTO::getId));
        }
        Map<Long, List<OrgOuRpcDTO>> finalOuMap = ouMap;
        invDespatchConfigWhPageVOS.forEach(i -> {
            if (!CollectionUtils.isEmpty((Collection)whAreaSettingRespVOS)) {
                whAreaSettingRespVOS.stream().filter(w -> w.getDeter2Type().equals(i.getDeter2Type())).findAny().ifPresent(m -> i.setDeter2TypeName(m.getDeter2TypeName()));
            }
            if (finalOuMap != null && finalOuMap.containsKey(i.getOuId())) {
                i.setOuName(((OrgOuRpcDTO)((List)finalOuMap.get(i.getOuId())).get(0)).getOuName());
            }
        });
    }

    public Map<String, SysOrgBasicDTO> selectParentByCodesAndParentType(Set<String> codes, String parentType) {
        if (CollectionUtil.isEmpty(codes)) {
            return null;
        }
        try {
            ApiResult apiResult = this.orgRpcService.getParentByCode(codes, parentType);
            if (apiResult.isSuccess()) {
                Map map = (Map)apiResult.getData();
                return map;
            }
            throw new BusinessException(ApiCode.FAIL, "\u8c03\u7528\u7cfb\u7edf\u57df(getParentByCode)\u6839\u636e\u7f16\u7801\u83b7\u53d6\u4e0a\u7ea7\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff1a" + apiResult.getMsg());
        }
        catch (Exception e) {
            log.error("selectParentByCodesAndParentType error:", (Throwable)e);
            throw new BusinessException(ApiCode.FAIL, "\u8c03\u7528\u7cfb\u7edf\u4e2d\u5fc3dubbo\u670d\u52a1\u5f02\u5e38\uff1a" + e);
        }
    }

    public InvDespatchConfigServiceImpl(InvDespatchConfigDomainService invDespatchConfigDomainService, SystemService systemService, InvWhService invWhService, InvDespatchConfigProc invDespatchConfigProc, OrgOutService orgOutService, OrgRpcService orgRpcService, InvWhAreaSettingService invWhAreaSettingService) {
        this.invDespatchConfigDomainService = invDespatchConfigDomainService;
        this.systemService = systemService;
        this.invWhService = invWhService;
        this.invDespatchConfigProc = invDespatchConfigProc;
        this.orgOutService = orgOutService;
        this.orgRpcService = orgRpcService;
        this.invWhAreaSettingService = invWhAreaSettingService;
    }
}

