/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.service.impl;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvIoSearchBatchParam;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvIoStkAcctRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.OrgRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.ioc.InvIocRespVO;
import com.elitesland.yst.production.inv.application.out.ItmOutService;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvIoService;
import com.elitesland.yst.production.inv.application.service.InvIocService;
import com.elitesland.yst.production.inv.domain.entity.invstk.InvIoDO;
import com.elitesland.yst.production.inv.domain.entity.invstk.QInvIoDO;
import com.elitesland.yst.production.inv.domain.service.InvWhAreaDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhDomainService;
import com.elitesland.yst.production.inv.infr.repo.InvIoRepo;
import com.elitesland.yst.production.inv.infr.repo.InvIoRepoProc;
import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.elitesland.yst.production.inv.utils.InvPTypeEnum;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="InvIoService")
public class InvIoServiceImpl
implements InvIoService {
    private final InvIoRepoProc invIoRepoProc;
    private final SystemService systemService;
    private final InvWhDomainService invWhDomainService;
    private final InvWhAreaDomainService invWhAreaDomainService;
    private final InvIoRepo invIoRepo;
    private final ItmOutService itmOutService;
    private final OrgOutService orgOutService;
    private final InvIocService invIocService;

    @Override
    @SysCodeProc
    public PagingVO<InvIoStkAcctRespVO> searchStkAcct(InvIoSearchBatchParam param) {
        if (param.getBrands() != null || !com.alibaba.excel.util.StringUtils.isEmpty((Object)param.getItemType())) {
            ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
            itmItemPartParam.setBrands(param.getBrands());
            itmItemPartParam.setItemType(param.getItemType());
            List<ItmItemRpcDTO> itmItemRpcDTOS = this.itmOutService.findItemRpcDtoByParam(itmItemPartParam);
            if (itmItemRpcDTOS.size() > 0) {
                List<Long> itemIds = itmItemRpcDTOS.stream().map(ItmItemRpcDTO::getId).distinct().collect(Collectors.toList());
                param.setItemIds(itemIds);
            } else {
                return PagingVO.builder().total(0L).records(new ArrayList()).build();
            }
        }
        JPAQuery<InvIoStkAcctRespVO> query = this.invIoRepoProc.searchStkAcct(param);
        this.invIoRepoProc.openOrderAndLimit(query, param, QInvIoDO.invIoDO);
        param.setPaging(query);
        List invIoDetailedVOList = query.fetch();
        if (CollectionUtils.isEmpty((Collection)invIoDetailedVOList)) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List<String> pEmpCodes = invIoDetailedVOList.stream().filter(i -> UdcEnum.INV_PARTNER_TYPE_EMP.getValueCode().equals(i.getPType())).map(InvIoStkAcctRespVO::getPCode).distinct().collect(Collectors.toList());
        List<String> pSuppCodes = invIoDetailedVOList.stream().filter(i -> UdcEnum.INV_PARTNER_TYPE_SUPP.getValueCode().equals(i.getPType())).map(InvIoStkAcctRespVO::getPCode).distinct().collect(Collectors.toList());
        List<OrgRespVO> empList = this.orgOutService.findcodeAndNameList(InvPTypeEnum.INV_PARTNER_TYPE_EMP, pEmpCodes);
        List<OrgRespVO> suppList = this.orgOutService.findcodeAndNameList(InvPTypeEnum.INV_PARTNER_TYPE_SUPP, pSuppCodes);
        List<String> ioCodes = invIoDetailedVOList.stream().map(InvIoStkAcctRespVO::getIoCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<InvIocRespVO> invIocRespVOS = this.invIocService.findByCodeBatch(ioCodes);
        invIoDetailedVOList.forEach(v -> {
            if (!com.alibaba.excel.util.StringUtils.isEmpty((Object)v.getIoDate())) {
                v.setSrcDate(InvIoServiceImpl.formatDateTime(v.getIoDate()));
            }
            if (!com.alibaba.excel.util.CollectionUtils.isEmpty((Collection)invIocRespVOS)) {
                invIocRespVOS.stream().filter(io -> io.getIoCode().equals(v.getIoCode())).findAny().ifPresent(m -> v.setIoCodeName(m.getIoName()));
            }
            if (v.getPCode() != null && UdcEnum.INV_PARTNER_TYPE_EMP.getValueCode().equals(v.getPType())) {
                empList.stream().filter(s -> s.getCode().equals(v.getPCode())).findAny().ifPresent(o -> v.setPName(o.getName()));
            }
            if (v.getPCode() != null && UdcEnum.INV_PARTNER_TYPE_SUPP.getValueCode().equals(v.getPType())) {
                suppList.stream().filter(s -> s.getCode().equals(v.getPCode())).findAny().ifPresent(o -> v.setPName(o.getName()));
            }
        });
        this.results(invIoDetailedVOList);
        List<InvIoStkAcctRespVO> invIoStkAcctRespVOS = this.udcChange(invIoDetailedVOList);
        return PagingVO.builder().total(query.fetchCount()).records(invIoStkAcctRespVOS).build();
    }

    public static String formatDateTime(LocalDateTime dateTime) {
        if (dateTime == null) {
            return "";
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return dateTime.format(formatter);
    }

    @Override
    @Transactional
    public List<Long> createBatch(List<InvIoDO> list) {
        return this.invIoRepo.saveAll(list).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    public void results(List<InvIoStkAcctRespVO> invIoDetailedVOList) {
        List itemIdList = invIoDetailedVOList.stream().map(InvIoStkAcctRespVO::getItemId).collect(Collectors.toList());
        ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
        itmItemPartParam.setItemIds(itemIdList);
        List<ItmItemRpcDTO> itmItemDTOS = this.itmOutService.findItemRpcDtoByParam(itmItemPartParam);
        List<Long> ouIdList = invIoDetailedVOList.stream().map(InvIoStkAcctRespVO::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<OrgOuRpcDTO> ouVoList = this.orgOutService.findOuByIds(ouIdList);
        List<Long> createUserIds = invIoDetailedVOList.stream().map(BaseModelVO::getCreateUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<SysUserVO> empsByIdIn = this.systemService.findAllEmpsByIdIn(createUserIds);
        Map<String, String> docClsMap = this.systemService.sysUdcGetCodeMap(UdcEnum.COM_DOC_CLS_STKAJ.getModel(), UdcEnum.COM_DOC_CLS_STKAJ.getCode());
        invIoDetailedVOList.forEach(v -> {
            if (!docClsMap.isEmpty() && docClsMap.containsKey(v.getSrcDocCls())) {
                v.setSrcDocClsName((String)docClsMap.get(v.getSrcDocCls()));
            }
            if (!com.alibaba.excel.util.CollectionUtils.isEmpty((Collection)itmItemDTOS)) {
                itmItemDTOS.stream().filter(i -> i.getId().equals(v.getItemId())).findAny().ifPresent(m -> {
                    v.setItemCode(m.getItemCode());
                    v.setItemName(m.getItemName());
                    v.setPackageSpec(m.getPackageSpec());
                    v.setBrand(m.getBrand());
                    v.setBrandName(m.getBrandName());
                    v.setBarCode(m.getBarCode());
                    v.setBrandName(m.getBrandName());
                    v.setItemType(m.getItemType());
                    v.setGuaranteeDays(m.getGuaranteeDays());
                    v.setGuaranteePeriod(m.getGuaranteePeriod());
                });
            }
            if (!com.alibaba.excel.util.CollectionUtils.isEmpty((Collection)ouVoList)) {
                ouVoList.stream().filter(i -> i.getId().equals(v.getOuId())).findAny().ifPresent(m -> {
                    v.setOuCode(m.getOuCode());
                    v.setOuName(m.getOuName());
                });
            }
            if (!com.alibaba.excel.util.CollectionUtils.isEmpty((Collection)empsByIdIn)) {
                empsByIdIn.stream().filter(e -> e.getId().equals(v.getCreateUserId())).findAny().ifPresent(m -> v.setCreator(m.getUsername()));
            }
        });
    }

    public List<InvIoStkAcctRespVO> udcChange(List<InvIoStkAcctRespVO> asms) {
        Map<String, String> udcUom = this.systemService.sysUdcGetCodeMap(UdcEnum.COM_UOM_BG.getModel(), UdcEnum.COM_UOM_BG.getCode());
        Map<String, String> udcDoccls = this.systemService.sysUdcGetCodeMap(UdcEnum.COM_DOC_CLS_SPA.getModel(), UdcEnum.COM_DOC_CLS_SPA.getCode());
        asms.stream().forEach(Asm -> {
            if (StringUtils.isNotBlank((CharSequence)Asm.getSrcDocCls()) && !MapUtils.isEmpty((Map)udcDoccls)) {
                Asm.setSrcDocClsName((String)udcDoccls.get(Asm.getSrcDocCls()));
            }
            if (StringUtils.isNotBlank((CharSequence)Asm.getUom()) && !MapUtils.isEmpty((Map)udcUom)) {
                Asm.setUomName((String)udcUom.get(Asm.getUom()));
            }
        });
        return asms;
    }

    public InvIoServiceImpl(InvIoRepoProc invIoRepoProc, SystemService systemService, InvWhDomainService invWhDomainService, InvWhAreaDomainService invWhAreaDomainService, InvIoRepo invIoRepo, ItmOutService itmOutService, OrgOutService orgOutService, InvIocService invIocService) {
        this.invIoRepoProc = invIoRepoProc;
        this.systemService = systemService;
        this.invWhDomainService = invWhDomainService;
        this.invWhAreaDomainService = invWhAreaDomainService;
        this.invIoRepo = invIoRepo;
        this.itmOutService = itmOutService;
        this.orgOutService = orgOutService;
        this.invIocService = invIocService;
    }
}

