/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.service.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.inv.application.facade.vo.ioc.InvIocParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.ioc.InvIocRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.ioc.InvIocSaveVO;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvIocService;
import com.elitesland.yst.production.inv.domain.convert.InvIocConvert;
import com.elitesland.yst.production.inv.domain.entity.ioc.InvIoc;
import com.elitesland.yst.production.inv.domain.service.InvIocDomainService;
import com.elitesland.yst.production.inv.infr.dto.InvIocDTO;
import com.elitesland.yst.production.inv.utils.InvUdcEnum;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="InvIocService")
public class InvIocServiceImpl
implements InvIocService {
    private static final Logger log = LoggerFactory.getLogger(InvIocServiceImpl.class);
    private final InvIocDomainService InvIocDomainService;
    private final SystemService systemService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> createOne(InvIocSaveVO saveVo) {
        InvIoc InvIoc2 = InvIocConvert.INSTANCE.saveVoToEn(saveVo);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)InvIoc2.getStatus())) {
            InvIoc2.setStatus(InvUdcEnum.INV_ACTIVE_STATUS_ACTIVE.getValueCode());
        }
        this.checkIocMandatory(InvIoc2);
        this.checkIocCodeAndName(InvIoc2);
        Long id = this.InvIocDomainService.saveInvIoc(InvIoc2, Optional.empty());
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> update(InvIocSaveVO saveVo) {
        Optional<InvIocDTO> iocDTOOptional = this.InvIocDomainService.findById(saveVo.getId());
        if (iocDTOOptional.isEmpty()) {
            return ApiResult.fail((String)"\u672a\u67e5\u8be2\u5230\u5e93\u5b58\u64cd\u4f5c\u7801\u4fe1\u606f!");
        }
        InvIoc InvIoc2 = InvIocConvert.INSTANCE.saveVoToEn(saveVo);
        this.checkIocMandatory(InvIoc2);
        this.checkIocCodeAndName(InvIoc2);
        Long id = this.InvIocDomainService.saveInvIoc(InvIoc2, iocDTOOptional);
        return ApiResult.ok((Object)id);
    }

    private void checkIocMandatory(InvIoc InvIoc2) {
        if (StringUtils.isEmpty((Object)InvIoc2.getIoCode())) {
            throw new BusinessException(ApiCode.FAIL, "\u64cd\u4f5c\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((Object)InvIoc2.getIoName())) {
            throw new BusinessException(ApiCode.FAIL, "\u64cd\u4f5c\u7801\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((Object)InvIoc2.getIoType())) {
            throw new BusinessException(ApiCode.FAIL, "\u64cd\u4f5c\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((Object)InvIoc2.getStatus())) {
            throw new BusinessException(ApiCode.FAIL, "\u662f\u5426\u542f\u7528\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }

    private void checkIocCodeAndName(InvIoc invIoc) {
        InvIocParamVO param = new InvIocParamVO();
        param.setIoCode(invIoc.getIoCode());
        List<InvIocDTO> invIocDTOList = this.InvIocDomainService.selectByParam(param);
        Optional<InvIocDTO> invIocDTOOptional = invIocDTOList.stream().filter(dto -> Objects.equals(invIoc.getIoCode(), dto.getIoCode()) && !Objects.equals(invIoc.getId(), dto.getId())).findFirst();
        invIocDTOOptional.ifPresent(iocDTO -> {
            throw new BusinessException(ApiCode.FAIL, "\u5e93\u5b58\u64cd\u4f5c\u7801\u5df2\u5b58\u5728-(" + iocDTO.getIoName() + ")!");
        });
        param.setIoCode(null);
        param.setIoName(invIoc.getIoName());
        List<InvIocDTO> invIocNameList = this.InvIocDomainService.selectByParam(param);
        Optional<InvIocDTO> invIocNameOptional = invIocNameList.stream().filter(dto -> Objects.equals(invIoc.getIoName(), dto.getIoName()) && !Objects.equals(invIoc.getId(), dto.getId())).findFirst();
        invIocNameOptional.ifPresent(iocDTO -> {
            throw new BusinessException(ApiCode.FAIL, "\u64cd\u4f5c\u7801\u540d\u79f0\u5df2\u5b58\u5728-(" + iocDTO.getIoCode() + ")!");
        });
    }

    @Override
    @SysCodeProc
    public ApiResult<InvIocRespVO> findIdOne(Long id) {
        Optional<InvIocDTO> invIocDTOOptional = this.InvIocDomainService.findById(id);
        if (invIocDTOOptional.isEmpty()) {
            return ApiResult.fail((String)"\u672a\u67e5\u8be2\u5230\u5e93\u5b58\u64cd\u4f5c\u7801\u4fe1\u606f!");
        }
        InvIocDTO InvIocDTO2 = invIocDTOOptional.get();
        InvIocRespVO InvIocRespVO2 = InvIocConvert.INSTANCE.dtoToRespVo(InvIocDTO2);
        return ApiResult.ok((Object)InvIocRespVO2);
    }

    @Override
    @SysCodeProc
    public Optional<InvIocRespVO> findByCode(String code) {
        Optional<InvIocDTO> invIocDTOOptional = this.InvIocDomainService.findByCode(code);
        if (invIocDTOOptional.isEmpty()) {
            return Optional.empty();
        }
        InvIocDTO InvIocDTO2 = invIocDTOOptional.get();
        InvIocRespVO InvIocRespVO2 = InvIocConvert.INSTANCE.dtoToRespVo(InvIocDTO2);
        return Optional.of(InvIocRespVO2);
    }

    @Override
    @SysCodeProc
    public List<InvIocRespVO> findByCodeBatch(List<String> codeList) {
        List<InvIocDTO> InvIocDTOList = this.InvIocDomainService.findByCodeBatch(codeList);
        if (CollectionUtils.isEmpty(InvIocDTOList)) {
            return Collections.EMPTY_LIST;
        }
        List<InvIocRespVO> invIocRespVOList = InvIocDTOList.stream().map(InvIocConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());
        return invIocRespVOList;
    }

    @Override
    @SysCodeProc
    public PagingVO<InvIocRespVO> search(InvIocParamVO param) {
        PagingVO<InvIocDTO> pagingVo = this.InvIocDomainService.search(param);
        if (CollectionUtils.isEmpty((Collection)pagingVo.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List vos = pagingVo.getRecords();
        List whAreaSettingRespVOList = vos.stream().map(InvIocConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());
        return PagingVO.builder().total(pagingVo.getTotal()).records(whAreaSettingRespVOList).build();
    }

    @Override
    @SysCodeProc
    public List<InvIocRespVO> select(InvIocParamVO param) {
        List<InvIocDTO> invIocDTOList = this.InvIocDomainService.selectByParam(param);
        if (CollectionUtils.isEmpty(invIocDTOList)) {
            return Collections.EMPTY_LIST;
        }
        List<InvIocRespVO> invIocRespVOList = invIocDTOList.stream().map(InvIocConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());
        return invIocRespVOList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<String> deleteBatch(List<Long> ids) {
        this.InvIocDomainService.updateDeleteFlagByIds(1, ids);
        return ApiResult.ok();
    }

    public InvIocServiceImpl(InvIocDomainService InvIocDomainService2, SystemService systemService) {
        this.InvIocDomainService = InvIocDomainService2;
        this.systemService = systemService;
    }
}

