/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.service.stk;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.util.RedLockUtils;
import com.elitesland.yst.production.inv.application.facade.vo.base.InvBaseModel;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotRespVO;
import com.elitesland.yst.production.inv.application.out.ItmOutService;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvIoService;
import com.elitesland.yst.production.inv.application.service.InvLotCommonService;
import com.elitesland.yst.production.inv.application.service.InvStkService;
import com.elitesland.yst.production.inv.application.service.InvWhService;
import com.elitesland.yst.production.inv.application.service.stk.InvStkOptService;
import com.elitesland.yst.production.inv.domain.convert.invstk.InvCommonConvert;
import com.elitesland.yst.production.inv.domain.entity.invstk.InvIoDO;
import com.elitesland.yst.production.inv.domain.entity.invstk.InvStkDO;
import com.elitesland.yst.production.inv.enums.InvOptEnum;
import com.elitesland.yst.production.inv.enums.WhetherEnum;
import com.elitesland.yst.production.inv.infr.dto.InvSceneConfigDtlDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateBodyDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkQtyResultDTO;
import com.elitesland.yst.production.inv.infr.dto.InvUomQueryDTO;
import com.elitesland.yst.production.inv.infr.dto.ItmItemDTO;
import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.elitesland.yst.production.inv.utils.NumSendObjectEnum;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemUomConvRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.yst.production.support.provider.item.param.ItmItemUomConvRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.redisson.RedissonRedLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Component
@Transactional(rollbackFor={Exception.class})
public abstract class AbstractInvStkOptService
implements InvStkOptService {
    private static final Logger log = LoggerFactory.getLogger(AbstractInvStkOptService.class);
    @Autowired
    protected ItmOutService itmOutService;
    @Autowired
    protected InvWhService invWhService;
    @Autowired
    protected InvLotCommonService invLotCommonService;
    @Autowired
    protected RedLockUtils redLockUtils;
    @Autowired
    protected InvStkService invStkService;
    @Autowired
    private OrgOutService outouService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private InvIoService invIoService;
    @PersistenceContext
    private EntityManager entityManager;

    protected abstract BigDecimal setInvIoQty(BigDecimal var1);

    protected abstract void updateQty(InvStkDO var1, BigDecimal var2);

    @Override
    public List<InvStkQtyResultDTO> stkOperatePortal(InvSceneConfigDtlDTO config, String sceneCode, List<InvStkCommonOperateBodyDTO> param) {
        long begin = System.currentTimeMillis();
        log.info("stkOperatePortal begin,config:{},param:{}", (Object)config, param);
        this.validateStkOperateList(config, param);
        this.resolveStkOperateParam(config, param);
        List<InvLotRespVO> invLotList = this.getInvLotList(param);
        List<ItmItemDTO> itmItemVOList = this.getItmItemVOList(param);
        List<InvWhRespVO> stkWhList = this.getStkWhList(param);
        Map<Long, OrgOuRpcDTO> orgMap = this.outouService.findOuByIds(param.stream().map(InvStkCommonOperateBodyDTO::getOuId).collect(Collectors.toList())).stream().collect(Collectors.toMap(OrgOuRpcDTO::getId, v -> v, (e1, e2) -> e2));
        Map<String, List<InvStkCommonOperateBodyDTO>> listMap = param.stream().collect(Collectors.groupingBy(dtl -> dtl.getWhId() + "-" + dtl.getOptDeter2() + "-" + dtl.getItemId() + "-" + dtl.getLotNo() + "-" + dtl.getDeter1() + "-" + dtl.getPType() + "-" + dtl.getPCode() + "-" + dtl.getUom() + "-" + dtl.getSnNo() + "-" + dtl.getLimit1() + "-" + dtl.getVariId()));
        this.doStkOpt(config, sceneCode, listMap, invLotList, itmItemVOList, stkWhList, orgMap);
        log.info("stkOperatePortal end,{}ms", (Object)(begin - System.currentTimeMillis()));
        return this.buildStkResult(param);
    }

    public void doStkOpt(InvSceneConfigDtlDTO config, String sceneCode, Map<String, List<InvStkCommonOperateBodyDTO>> listMap, List<InvLotRespVO> invLotList, List<ItmItemDTO> itmItemVOList, List<InvWhRespVO> stkWhList, Map<Long, OrgOuRpcDTO> orgOuMap) {
        Long ioBatchId = LocalDateTime.now().toInstant(ZoneOffset.ofHours(8)).toEpochMilli();
        ArrayList<InvIoDO> ioList = new ArrayList<InvIoDO>();
        for (String key : listMap.keySet()) {
            log.info("\u5f00\u59cb\u5904\u7406\u5e93\u5b58\uff0c\u4ed3\u5e93\u552f\u4e00\u503c\uff1a{}", (Object)key);
            List<InvStkCommonOperateBodyDTO> common28InSaveVO = listMap.get(key);
            RedissonRedLock redLock = this.redLockUtils.getRedLock("YST_INV_INV_STK_OPERATE_FOR_IO_TYPE_KEY_" + key);
            HashMap<CallSite, InvStkDO> dbStkMap = new HashMap<CallSite, InvStkDO>(16);
            for (InvStkCommonOperateBodyDTO operateBodyDTO : common28InSaveVO) {
                BigDecimal avalQty;
                String uniqueKey;
                InvStkDO invStkDO;
                List lotRespVOList;
                ItmItemDTO itmItemVO = itmItemVOList.stream().filter(i -> i.getId().equals(operateBodyDTO.getItemId())).findAny().get();
                InvWhRespVO invWhRespVO = stkWhList.stream().filter(i -> i.getId().equals(operateBodyDTO.getWhId())).findAny().get();
                InvLotRespVO lotRespVO = new InvLotRespVO();
                if (!org.springframework.util.CollectionUtils.isEmpty(invLotList) && !CollectionUtils.isEmpty(lotRespVOList = invLotList.stream().filter(lot -> (lot.getItemId() + "_" + lot.getLotNo() + "_" + lot.getVariId()).equals(operateBodyDTO.getItemId() + "_" + operateBodyDTO.getLotNo() + "_" + operateBodyDTO.getVariId())).collect(Collectors.toList()))) {
                    lotRespVO = (InvLotRespVO)lotRespVOList.get(0);
                }
                if ((invStkDO = (InvStkDO)dbStkMap.get(uniqueKey = operateBodyDTO.getItemId() + "_" + operateBodyDTO.getWhId() + "_" + operateBodyDTO.getOptDeter2() + "_" + operateBodyDTO.getDeter1() + "_" + operateBodyDTO.getUom() + "_" + operateBodyDTO.getSnNo() + "_" + operateBodyDTO.getPType() + "_" + operateBodyDTO.getPCode() + "_" + operateBodyDTO.getLotNo() + "_" + operateBodyDTO.getLimit1() + "_" + operateBodyDTO.getVariId())) != null) continue;
                invStkDO = this.queryInvStkAsync(operateBodyDTO);
                if (invStkDO == null) {
                    try {
                        boolean lockFlag = redLock.tryLock(3L, 60L, TimeUnit.SECONDS);
                        if (!lockFlag) {
                            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5e93\u5b58\u5e76\u53d1\u8fc7\u5927,\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
                        }
                        invStkDO = this.queryInvStkAsync(operateBodyDTO);
                        if (invStkDO == null) {
                            invStkDO = this.createStk(operateBodyDTO, itmItemVO, invWhRespVO, lotRespVO);
                            log.info("doStkOpt create invStkDO successful...,key:{}", (Object)uniqueKey);
                        }
                    }
                    catch (InterruptedException e) {
                        log.error("invStkCommonOperate InterruptedException,cause->", (Throwable)e);
                        Thread.currentThread().interrupt();
                        throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7cfb\u7edf\u7ebf\u7a0b\u4e2d\u65ad\uff01");
                    }
                    finally {
                        redLock.unlock();
                    }
                    dbStkMap.put((CallSite)((Object)uniqueKey), invStkDO);
                }
                BigDecimal qty = operateBodyDTO.getQty() == null ? BigDecimal.ZERO : operateBodyDTO.getQty().abs();
                BigDecimal bigDecimal = avalQty = invStkDO.getAvalQty() == null ? BigDecimal.ZERO : invStkDO.getAvalQty();
                if (InvOptEnum.INV_IO_TYPE_T.getType().equals(config.getIoType()) && avalQty.subtract(qty).compareTo(BigDecimal.ZERO) < 0) {
                    log.error("\u5e93\u5b58\u53ef\u7528\u91cf\u4e0d\u8db3,\u5355\u636e\u4fe1\u606f\uff1a{},\u5e93\u5b58\u4fe1\u606f:{},", (Object)operateBodyDTO, (Object)invStkDO);
                    throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u5e93\u5b58\u53ef\u7528\u91cf\u4e0d\u8db3");
                }
                this.clearStk(invStkDO);
                log.info("clearStk jps object sts success...");
                InvStkDO updateBean = new InvStkDO();
                BeanUtils.copyProperties((Object)invStkDO, (Object)updateBean);
                updateBean.setDeter2(operateBodyDTO.getOptDeter2());
                log.info("ready to update stk...");
                this.updateQty(updateBean, qty);
                int result = this.invStkService.updateStkQty(updateBean);
                log.info("update stk success...");
                ioList.add(this.getInvIoLog(operateBodyDTO, invStkDO.getId(), config, sceneCode, itmItemVO, orgOuMap.get(operateBodyDTO.getOuId()), ioBatchId, 1.0, invWhRespVO));
            }
        }
        this.invIoService.createBatch(ioList);
    }

    private void clearStk(InvStkDO invStkDO) {
        this.entityManager.detach((Object)invStkDO);
        invStkDO.setOhQty(BigDecimal.ZERO);
        invStkDO.setOhQty2(BigDecimal.ZERO);
        invStkDO.setRsvQty(BigDecimal.ZERO);
        invStkDO.setRsvQty2(BigDecimal.ZERO);
        invStkDO.setRsvQty3(BigDecimal.ZERO);
        invStkDO.setRsvQty4(BigDecimal.ZERO);
        invStkDO.setLockQty(BigDecimal.ZERO);
        invStkDO.setLockQty2(BigDecimal.ZERO);
        invStkDO.setLockQty3(BigDecimal.ZERO);
        invStkDO.setLockQty4(BigDecimal.ZERO);
        invStkDO.setOwQty(BigDecimal.ZERO);
        invStkDO.setOwQty2(BigDecimal.ZERO);
        invStkDO.setOwQty3(BigDecimal.ZERO);
        invStkDO.setOwQty4(BigDecimal.ZERO);
        invStkDO.setAvalQty(BigDecimal.ZERO);
        invStkDO.setAvalQty2(BigDecimal.ZERO);
    }

    protected InvIoDO getInvIoLog(InvStkCommonOperateBodyDTO common28InVO, Long stkId, InvSceneConfigDtlDTO invStk28Enum, String sceneCode, ItmItemDTO itmItemVO, OrgOuRpcDTO ou, Long ioBatchId, Double lineNo, InvWhRespVO invWhRespVO) {
        InvIoDO invIo = InvCommonConvert.INSTANCE.invStkCommonOperateBodyDTOToInvIoDO(common28InVO);
        invIo.setIoBatchId(ioBatchId);
        invIo.setLineNo(lineNo);
        invIo.setDeleteFlag(0);
        invIo.setStkId(stkId);
        invIo.setWhCode(invWhRespVO.getWhCode());
        invIo.setIoCode(invStk28Enum.getIoCode());
        invIo.setQty(this.setInvIoQty(common28InVO.getQty().abs()));
        invIo.setIoDate(common28InVO.getOpDate());
        invIo.setCreateUserId(common28InVO.getCreateUserId());
        ArrayList<String> runtimeValues = new ArrayList<String>();
        String generateCode = this.systemService.sysNumberRuleGenerateCode(NumSendObjectEnum.INV_MR.getCode(), runtimeValues);
        invIo.setDocNo(generateCode);
        invIo.setUom2(itmItemVO.getUom2());
        invIo.setSceneCode(sceneCode);
        if (itmItemVO.getVolume() != null) {
            invIo.setVolume(Double.valueOf(itmItemVO.getVolume().floatValue()));
        }
        if (itmItemVO.getNetWeight() != null) {
            invIo.setNetWeight(Double.valueOf(itmItemVO.getNetWeight().floatValue()));
        }
        if (itmItemVO.getGrossWeight() != null) {
            invIo.setGrossWeight(Double.valueOf(itmItemVO.getGrossWeight().floatValue()));
        }
        invIo.setWeightUomCode(itmItemVO.getWeightUom());
        if (ou != null) {
            invIo.setOuId(ou.getId());
        }
        invIo.setItemCode(itmItemVO.getItemCode());
        invIo.setItemCateCode(itmItemVO.getItemCateCode());
        invIo.setBrand(itmItemVO.getBrand());
        invIo.setIoStatus(UdcEnum.COM_STATUS_ACTIVEORNO_ACTIVE.getValueCode());
        invIo.setSrcDocNo(common28InVO.getDocNo());
        invIo.setPType(common28InVO.getPType());
        invIo.setPCode(common28InVO.getPCode());
        invIo.setSecBuId(invWhRespVO.getSecBuId());
        invIo.setSecOuId(invWhRespVO.getSecOuId());
        invIo.setCreateTime(LocalDateTime.now());
        return invIo;
    }

    private void resolveStkOperateParam(InvSceneConfigDtlDTO config, List<InvStkCommonOperateBodyDTO> param) {
        this.convertUom(param);
        this.convertDeter2(config, param);
        this.convertDocNo(config, param);
    }

    protected abstract void convertDeter2(InvSceneConfigDtlDTO var1, List<InvStkCommonOperateBodyDTO> var2);

    protected abstract void convertDocNo(InvSceneConfigDtlDTO var1, List<InvStkCommonOperateBodyDTO> var2);

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public InvStkDO queryInvStkAsync(InvStkCommonOperateBodyDTO bodyDTO) {
        InvBaseModel invBaseModel = new InvBaseModel();
        BeanUtils.copyProperties((Object)bodyDTO, (Object)invBaseModel);
        invBaseModel.setDeter2(bodyDTO.getOptDeter2());
        return this.invStkService.getInvStkDo(invBaseModel);
    }

    public void validateStkOperateList(InvSceneConfigDtlDTO config, List<InvStkCommonOperateBodyDTO> bodyList) {
        bodyList = bodyList.stream().filter(inVO -> inVO.getQty() != null && inVO.getQty().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
        bodyList.forEach(body -> this.validateStkOperate(config, (InvStkCommonOperateBodyDTO)body));
    }

    private List<InvWhRespVO> getStkWhList(List<InvStkCommonOperateBodyDTO> bodyList) {
        List<Long> whIdList = bodyList.stream().map(InvStkCommonOperateBodyDTO::getWhId).distinct().collect(Collectors.toList());
        List<InvWhRespVO> orgWhVOList = this.invWhService.findIdBatch(whIdList);
        if (CollectionUtils.isEmpty(orgWhVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4ed3\u5e93\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!");
        }
        List dbWhIds = orgWhVOList.stream().map(BaseModelVO::getId).distinct().collect(Collectors.toList());
        whIdList.removeAll(dbWhIds);
        if (CollectionUtils.isNotEmpty(whIdList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4ed3\u5e93\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!,\u4ed3\u5e93\u53f7\uff1a" + org.apache.commons.lang3.StringUtils.join(whIdList, (String)","));
        }
        return orgWhVOList;
    }

    private void validateStkOperate(InvSceneConfigDtlDTO config, InvStkCommonOperateBodyDTO body) {
        if (WhetherEnum.Y.name().equals(config.getIsRelDocReq())) {
            this.validateSrcDoc(body);
        }
    }

    private List<InvLotRespVO> getInvLotList(List<InvStkCommonOperateBodyDTO> bodyList) {
        ArrayList<InvLotRespVO> rs = new ArrayList<InvLotRespVO>();
        List<String> invLotStringList = bodyList.stream().filter(i -> !StringUtils.isEmpty((Object)i.getLotNo())).map(i -> i.getItemId() == null ? "" : "" + i.getItemId() + (Serializable)(i.getVariId() == null ? "" : i.getVariId()) + i.getLotNo() + i.getOuId()).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(invLotStringList)) {
            return rs;
        }
        Map<String, List<InvLotRespVO>> invLotListMap = this.invLotCommonService.getInvLotVOListByKey(invLotStringList);
        if (invLotListMap == null || invLotListMap.size() == 0) {
            throw new BusinessException("\u5e93\u5b58\u6279\u6b21\u4fe1\u606f\u4e0d\u5b58\u5728\uff01,key:" + invLotStringList);
        }
        invLotStringList.removeAll(invLotListMap.keySet());
        if (CollectionUtils.isNotEmpty(invLotStringList)) {
            throw new BusinessException("\u5e93\u5b58\u6279\u6b21\u4fe1\u606f\u4e0d\u5b58\u5728\uff01,key:" + invLotStringList);
        }
        Collection<List<InvLotRespVO>> values = invLotListMap.values();
        for (List<InvLotRespVO> value : values) {
            rs.addAll(value);
        }
        return rs;
    }

    private void validateSrcDoc(InvStkCommonOperateBodyDTO body) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)body.getDocNo())) {
            throw new BusinessException("\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)body.getSrcDocCls())) {
            throw new BusinessException("\u6765\u6e90\u5355\u636e\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (body.getSrcDocId() == null) {
            throw new BusinessException("\u6765\u6e90\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (body.getSrcDocDid() == null) {
            throw new BusinessException("\u6765\u6e90\u5355\u636e\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void convertUom(List<InvStkCommonOperateBodyDTO> bodyList) {
        List<@NotNull Long> itemIds = bodyList.stream().map(InvStkCommonOperateBodyDTO::getItemId).collect(Collectors.toList());
        List<ItmItemUomConvRpcDTO> uomRpcList = this.getUomRpcList(itemIds);
        ItmItemRpcDtoParam param = new ItmItemRpcDtoParam();
        param.setItemIds(itemIds);
        List<ItmItemRpcDTO> itemRpcList = this.itmOutService.findItemRpcDtoByParam(param);
        bodyList.stream().map(m -> {
            itemRpcList.stream().filter(v -> v.getId().equals(m.getItemId())).findAny().ifPresent(v -> {
                InvUomQueryDTO uomQueryParamVO = new InvUomQueryDTO();
                uomQueryParamVO.setFromUom(m.getUom());
                uomQueryParamVO.setToUom(v.getUom());
                uomQueryParamVO.setItemCode(v.getItemCode());
                uomQueryParamVO.setItemId(m.getItemId());
                BigDecimal uomRatio = this.getUomRatio(uomRpcList, uomQueryParamVO);
                if (uomRatio.compareTo(BigDecimal.ZERO) <= 0) {
                    throw new BusinessException(ApiCode.FAIL, String.format("\u5546\u54c1\u3010%s]\u5355\u4f4d\u4ece\u3010%s\u3011\u5230 \u3010%s\u3011\u5355\u4f4d\u8f6c\u6362\u7cfb\u6570\u672a\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5", v.getItemCode(), m.getUom(), v.getUom()));
                }
                m.setQty(m.getQty().multiply(uomRatio));
                m.setUom(v.getUom());
            });
            return m;
        }).collect(Collectors.toList());
    }

    private List<ItmItemDTO> getItmItemVOList(List<InvStkCommonOperateBodyDTO> bodyList) {
        List itemIdList = bodyList.stream().map(InvStkCommonOperateBodyDTO::getItemId).distinct().collect(Collectors.toList());
        log.info("\u5546\u54c1ID\u96c6\u5408\u662f\uff1a{}", itemIdList);
        if (CollectionUtils.isEmpty(itemIdList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
        itmItemPartParam.setItemIds(itemIdList);
        itmItemPartParam.setItemStatus3("ALL");
        List<ItmItemRpcDTO> itmItemRpcList = this.itmOutService.findItemRpcDtoByParam(itmItemPartParam);
        if (CollectionUtils.isEmpty(itmItemRpcList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5546\u54c1\u4fe1\u606f\u67e5\u8be2\u5931\u8d25!");
        }
        List<ItmItemDTO> itmItemList = itmItemRpcList.stream().map(e -> {
            ItmItemDTO itmItemVO = new ItmItemDTO();
            BeanUtils.copyProperties((Object)e, (Object)itmItemVO);
            return itmItemVO;
        }).collect(Collectors.toList());
        return itmItemList;
    }

    private List<ItmItemUomConvRpcDTO> getUomRpcList(List<Long> itemIds) {
        ItmItemUomConvRpcDtoParam param = new ItmItemUomConvRpcDtoParam();
        param.setItemIds(itemIds);
        List<ItmItemUomConvRpcDTO> uomRpcList = this.itmOutService.findItemUomConvDtoByParam(param);
        return uomRpcList;
    }

    private BigDecimal getUomRatio(List<ItmItemUomConvRpcDTO> uomRpcList, InvUomQueryDTO paramVO) {
        log.info("\u5355\u4f4d\u8f6c\u6362\u53c2\u6570\u4e3a1\uff1a{},\u53c2\u65702\uff1a{}", uomRpcList, (Object)paramVO);
        BigDecimal uomRatio = BigDecimal.ONE;
        if (paramVO.getFromUom() == null || paramVO.getToUom() == null || paramVO.getFromUom().equals(paramVO.getToUom())) {
            return uomRatio;
        }
        Optional<ItmItemUomConvRpcDTO> uomRpc = uomRpcList.stream().filter(u -> u.getItemId().equals(paramVO.getItemId()) && u.getFromUom().equals(paramVO.getFromUom()) && u.getToUom().equals(paramVO.getToUom())).findFirst();
        if (uomRpc.isPresent() && uomRpc.get().getRatio() != null) {
            if (uomRpc.get().getRatio().compareTo(BigDecimal.ZERO) <= 0) {
                throw new BusinessException(ApiCode.FAIL, "\u5546\u54c1\u3010" + paramVO.getItemCode() + "\u3011\u5355\u4f4d\u8f6c\u6362" + paramVO.getFromUom() + "->" + paramVO.getToUom() + "\u5f02\u5e38,\u5355\u4f4d\u8f6c\u6362\u7cfb\u6570\u4e3a0\uff0c\u8bf7\u68c0\u67e5\u5546\u54c1\u4e3b\u6570\u636e");
            }
            return uomRpc.get().getRatio();
        }
        Optional<ItmItemUomConvRpcDTO> uomRpcDto = uomRpcList.stream().filter(u -> u.getItemId().equals(paramVO.getItemId()) && u.getFromUom().equals(paramVO.getToUom()) && u.getToUom().equals(paramVO.getFromUom())).findFirst();
        if (uomRpcDto.isPresent() && uomRpcDto.get().getRatio() != null) {
            if (uomRpcDto.get().getRatio().compareTo(BigDecimal.ZERO) <= 0) {
                throw new BusinessException(ApiCode.FAIL, "\u5546\u54c1\u3010" + paramVO.getItemCode() + "\u3011\u5355\u4f4d\u8f6c\u6362" + paramVO.getFromUom() + "->" + paramVO.getToUom() + "\u5f02\u5e38,\u5355\u4f4d\u8f6c\u6362\u7cfb\u6570\u4e3a0\uff0c\u8bf7\u68c0\u67e5\u5546\u54c1\u4e3b\u6570\u636e");
            }
            return uomRpcDto.get().getRatio().negate();
        }
        throw new BusinessException(ApiCode.FAIL, "\u5546\u54c1\u3010" + paramVO.getItemCode() + "\u3011\u5355\u4f4d\u8f6c\u6362" + paramVO.getFromUom() + "->" + paramVO.getToUom() + "\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5546\u54c1\u4e3b\u6570\u636e");
    }

    public InvStkDO createStk(InvStkCommonOperateBodyDTO common28InVO, ItmItemDTO itmItemVO, InvWhRespVO invWhRespVO, InvLotRespVO invLotRespVO) {
        InvStkDO invStkDO = new InvStkDO();
        invStkDO.setItemId(itmItemVO.getId());
        invStkDO.setItemCode(itmItemVO.getItemCode());
        invStkDO.setUom(itmItemVO.getUom());
        invStkDO.setUom2(itmItemVO.getUom2());
        invStkDO.setDeleteFlag(0);
        invStkDO.setItemName(itmItemVO.getItemName());
        invStkDO.setItemCateCode(itmItemVO.getItemCateCode());
        invStkDO.setBrand(itmItemVO.getBrand());
        invStkDO.setWhId(invWhRespVO.getId());
        invStkDO.setWhCode(invWhRespVO.getWhCode());
        invStkDO.setOuId(invWhRespVO.getOuId());
        invStkDO.setBuId(itmItemVO.getBuId());
        invStkDO.setDesId(itmItemVO.getBuId());
        invStkDO.setSecBuId(invWhRespVO.getSecBuId());
        invStkDO.setSecOuId(invWhRespVO.getSecOuId());
        invStkDO.setVariId(common28InVO.getVariId());
        invStkDO.setDeter1(common28InVO.getDeter1());
        invStkDO.setDeter2(common28InVO.getOptDeter2());
        invStkDO.setDeter3(common28InVO.getDeter3());
        invStkDO.setDeter4(itmItemVO.getItemType5());
        invStkDO.setDeter5(itmItemVO.getItemType2());
        invStkDO.setLotNo(common28InVO.getLotNo());
        invStkDO.setSnNo(common28InVO.getSnNo());
        invStkDO.setLimit1(common28InVO.getLimit1());
        invStkDO.setLimit1(common28InVO.getLimit2());
        invStkDO.setLimit1(common28InVO.getLimit3());
        invStkDO.setInDate(common28InVO.getOpDate());
        invStkDO.setPCode(itmItemVO.getSpuCode());
        invStkDO.setPType(common28InVO.getPType());
        invStkDO.setOhQty(BigDecimal.ZERO);
        invStkDO.setOhQty2(BigDecimal.ZERO);
        invStkDO.setRsvQty(BigDecimal.ZERO);
        invStkDO.setRsvQty2(BigDecimal.ZERO);
        invStkDO.setRsvQty3(BigDecimal.ZERO);
        invStkDO.setRsvQty4(BigDecimal.ZERO);
        invStkDO.setLockQty(BigDecimal.ZERO);
        invStkDO.setLockQty2(BigDecimal.ZERO);
        invStkDO.setLockQty3(BigDecimal.ZERO);
        invStkDO.setLockQty4(BigDecimal.ZERO);
        invStkDO.setOwQty(BigDecimal.ZERO);
        invStkDO.setOwQty2(BigDecimal.ZERO);
        invStkDO.setOwQty3(BigDecimal.ZERO);
        invStkDO.setOwQty4(BigDecimal.ZERO);
        invStkDO.setAvalQty(BigDecimal.ZERO);
        invStkDO.setAvalQty2(BigDecimal.ZERO);
        invStkDO.setDeleteFlag(0);
        invStkDO.setSrcDocCls(common28InVO.getSrcDocCls());
        invStkDO.setSrcDocId(common28InVO.getSrcDocId());
        invStkDO.setSrcDocDid(common28InVO.getSrcDocDid());
        invStkDO.setCreateUserId(common28InVO.getCreateUserId());
        invStkDO.setUntilExpireDays(invLotRespVO.getUntilExpireDays());
        invStkDO.setFressType(invLotRespVO.getFressType());
        if (itmItemVO.getVolume() != null) {
            invStkDO.setVolume(BigDecimal.valueOf(itmItemVO.getVolume().floatValue()));
        }
        if (itmItemVO.getNetWeight() != null) {
            invStkDO.setNetWeight(BigDecimal.valueOf(itmItemVO.getNetWeight().floatValue()));
        }
        if (itmItemVO.getGrossWeight() != null) {
            invStkDO.setGrossWeight(BigDecimal.valueOf(itmItemVO.getGrossWeight().floatValue()));
        }
        this.invStkService.createInvStk(invStkDO);
        return invStkDO;
    }

    private List<InvStkQtyResultDTO> buildStkResult(List<InvStkCommonOperateBodyDTO> param) {
        ArrayList<InvStkQtyResultDTO> list = new ArrayList<InvStkQtyResultDTO>();
        param.forEach(i -> {
            InvStkQtyResultDTO resultDTO = new InvStkQtyResultDTO();
            resultDTO.setLotNo(i.getLotNo());
            resultDTO.setQty(i.getQty());
            resultDTO.setSrcDocNo(i.getDocNo());
            resultDTO.setSrcDocCls(i.getSrcDocCls());
            resultDTO.setSrcDocId(i.getSrcDocId());
            resultDTO.setSrcDocDid(i.getSrcDocDid());
            list.add(resultDTO);
        });
        return list;
    }

    protected BigDecimal setQty(BigDecimal qty) {
        return qty == null ? BigDecimal.ZERO : qty;
    }

    protected void convertDeter2(String transferDeter2, InvStkCommonOperateBodyDTO dto) {
        dto.setOptDeter2(dto.getDeter2());
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)transferDeter2)) {
            dto.setOptDeter2(transferDeter2);
        }
    }

    protected void convertDocNo(String isUseRelDoc, InvStkCommonOperateBodyDTO dto) {
        if (isUseRelDoc != null && WhetherEnum.Y.equals(isUseRelDoc)) {
            dto.setDocNo(dto.getSrcDocNo2());
            dto.setSrcDocId(dto.getSrcDocId2());
            dto.setSrcDocDid(dto.getSrcDocDid2());
            dto.setSrcDocCls(dto.getSrcDocCls2());
            dto.setOptDeter2(dto.getDeter2());
        }
    }
}

