/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.web.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkRespDVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotAllRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotCombineParam;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotCommonSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvStkDParam;
import com.elitesland.yst.production.inv.application.service.InvLotCommonService;
import com.elitesland.yst.production.inv.application.service.InvLotService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/invLot"})
@Api(value="\u6279\u6b21\u4e3b\u6863", tags={"\u6279\u6b21\u4e3b\u6863"})
public class InvLotController {
    private final InvLotService invLotService;
    private final InvLotCommonService invLotCommonService;

    @PostMapping(value={"/searchCombine"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    public ApiResult<?> searchCombine(@RequestBody InvLotCombineParam param) {
        PagingVO<InvLotRespVO> ret = this.invLotService.findCombine(param);
        return ApiResult.ok(ret);
    }

    @PostMapping(value={"/createOne"})
    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    public ApiResult<?> createOne(@RequestBody InvLotSaveVO param) {
        ArrayList<InvLotSaveVO> list = new ArrayList<InvLotSaveVO>();
        list.add(param);
        return this.invLotCommonService.createInvLotInfo(list);
    }

    @PostMapping(value={"/searchD"})
    @ApiOperation(value="\u8be6\u7ec6\u6570\u636e\u67e5\u8be2")
    public ApiResult<?> searchD(@RequestBody InvStkDParam param) {
        PagingVO<InvStkRespDVO> ret = this.invLotService.searchD(param);
        return ApiResult.ok(ret);
    }

    @PostMapping(value={"/createBatch"})
    @ApiOperation(value="\u6279\u91cf\u65b0\u589e\u6570\u636e")
    public ApiResult<?> createBatch(@RequestBody List<InvLotSaveVO> list) {
        List<InvLotSaveVO> dos = list.stream().map(i -> {
            InvLotSaveVO VO = new InvLotSaveVO();
            BeanUtils.copyProperties((Object)i, (Object)VO);
            return VO;
        }).collect(Collectors.toList());
        return ApiResult.ok(this.invLotService.createBatch(dos));
    }

    @PutMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    public ApiResult<?> update(@RequestBody InvLotSaveVO param) {
        InvLotCommonSaveVO VO = new InvLotCommonSaveVO();
        BeanUtils.copyProperties((Object)param, (Object)VO);
        ArrayList<InvLotCommonSaveVO> list = new ArrayList<InvLotCommonSaveVO>();
        list.add(VO);
        return this.invLotCommonService.updateInvLotInfo(list);
    }

    @GetMapping(value={"/findheader/{id}"})
    @ApiOperation(value="\u67e5\u5934\u4fe1\u606f")
    public ApiResult<?> findInvLotAllOne(@PathVariable Long id) {
        Optional<InvLotAllRespVO> ret = this.invLotService.findInvLotAllOne(id);
        return ApiResult.ok(ret);
    }

    @DeleteMapping(value={"/deleteOne/{id}"})
    @ApiOperation(value="\u6839\u636e\u4e3b\u952e\u5220\u9664\u6570\u636e")
    public ApiResult<?> deleteOne(@PathVariable Long id) {
        this.invLotService.deleteOne(id);
        return ApiResult.ok();
    }

    @DeleteMapping(value={"/deleteBatch"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    public ApiResult<?> deleteBatch(@RequestBody List<Long> ids) {
        this.invLotService.deleteBatch(ids);
        return ApiResult.ok();
    }

    @PutMapping(value={"/updateDeleteFlag/{id}"})
    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    public ApiResult<?> updateDeleteFlag(@PathVariable Long id) {
        this.invLotService.updateDeleteFlag(id);
        return ApiResult.ok();
    }

    @GetMapping(value={"/findIdOne/{id}"})
    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    public ApiResult<InvLotRespVO> findIdOne(@PathVariable Long id) {
        return this.invLotService.findLotById(id);
    }

    public InvLotController(InvLotService invLotService, InvLotCommonService invLotCommonService) {
        this.invLotService = invLotService;
        this.invLotCommonService = invLotCommonService;
    }
}

