/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.domain.service.impl;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvAsmAllQueryParam;
import com.elitesland.yst.production.inv.application.facade.vo.InvAsmDRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvCalCostQueryParam;
import com.elitesland.yst.production.inv.domain.convert.InvAsmDConvert;
import com.elitesland.yst.production.inv.domain.entity.InvAsmD;
import com.elitesland.yst.production.inv.domain.entity.InvAsmDDO;
import com.elitesland.yst.production.inv.domain.service.InvAsmDDomainService;
import com.elitesland.yst.production.inv.infr.dto.InvAsmAndAsmDDTO;
import com.elitesland.yst.production.inv.infr.repo.InvAsmDRepo;
import com.elitesland.yst.production.inv.infr.repo.InvAsmDRepoProc;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.List;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class InvAsmDDomainServiceImpl
implements InvAsmDDomainService {
    private final InvAsmDRepo invAsmDRepo;
    private final InvAsmDRepoProc invAsmDRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<InvAsmAndAsmDDTO> search(InvAsmAllQueryParam param) {
        JPAQuery<InvAsmAndAsmDDTO> invAsms = this.invAsmDRepoProc.selectH(param);
        param.fillOrders(invAsms);
        param.setPaging(invAsms);
        List asms = invAsms.fetch();
        return PagingVO.builder().total(invAsms.fetchCount()).records(asms).build();
    }

    @Override
    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(id -> this.invAsmDRepo.deleteById(id));
    }

    @Override
    @Transactional
    public void createBatch(List<InvAsmD> invAsmDList) {
        List invAsmDS = invAsmDList.stream().map(invAsmD -> {
            InvAsmDDO invAsmDDO = InvAsmDConvert.INSTANCE.asmdToDo((InvAsmD)invAsmD);
            return invAsmDDO;
        }).collect(Collectors.toList());
        this.invAsmDRepo.saveAll(invAsmDS);
    }

    @Override
    @SysCodeProc
    public List<InvAsmDRespVO> listByCostCal(InvCalCostQueryParam param, int current, int PAGE_SIZE) {
        PageRequest pageable = PageRequest.of((int)(current - 1), (int)PAGE_SIZE);
        Page<InvAsmDDO> invAsms = this.invAsmDRepoProc.listByCostCal(param, (Pageable)pageable);
        return invAsms.stream().map(InvAsmDConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    @Override
    @SysCodeProc
    public List<InvAsmAndAsmDDTO> findAll(InvAsmAllQueryParam param) {
        List invAsms = this.invAsmDRepoProc.selectD(param).fetch();
        return invAsms;
    }

    @Override
    @Transactional
    public int removeInBatch(List<Long> ids) {
        ids.forEach(id -> this.invAsmDRepo.deleteById(id));
        return ids.size();
    }

    @Override
    public List<InvAsmDDO> findByMasId(Long masId) {
        List<InvAsmDDO> invAsmDDOS = this.invAsmDRepo.findByMasId(masId);
        return invAsmDDOS;
    }

    public InvAsmDDomainServiceImpl(InvAsmDRepo invAsmDRepo, InvAsmDRepoProc invAsmDRepoProc) {
        this.invAsmDRepo = invAsmDRepo;
        this.invAsmDRepoProc = invAsmDRepoProc;
    }
}

