/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.domain.service.impl;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.yst.production.inv.application.facade.vo.ck.InvCkParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.ck.InvCkRespVO;
import com.elitesland.yst.production.inv.domain.convert.ck.InvCkConvert;
import com.elitesland.yst.production.inv.domain.entity.ck.InvCk;
import com.elitesland.yst.production.inv.domain.entity.ck.InvCkDO;
import com.elitesland.yst.production.inv.domain.service.InvCkDomainService;
import com.elitesland.yst.production.inv.infr.dto.ck.InvCkDTO;
import com.elitesland.yst.production.inv.infr.repo.ck.InvCkRepo;
import com.elitesland.yst.production.inv.infr.repo.ck.InvCkRepoProc;
import java.util.Optional;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InvCkDomainServiceImpl
implements InvCkDomainService {
    private final InvCkRepo invCkRepo;
    private final InvCkRepoProc invCkRepoProc;

    @Override
    @SysCodeProc
    public Optional<InvCkDTO> findById(Long id) {
        return this.invCkRepo.findById(id).map(InvCkConvert.INSTANCE::doToDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveInvCk(InvCk invCk) {
        InvCkDO invCkDO = InvCkConvert.INSTANCE.enToDo(invCk);
        return ((InvCkDO)this.invCkRepo.save(invCkDO)).getId();
    }

    @Override
    @SysCodeProc
    public PagingVO<InvCkRespVO> invCkSearch(InvCkParamVO param) {
        PagingVO<InvCkRespVO> pagingVo = this.invCkRepoProc.invCkSearch(param);
        return pagingVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDocStatus(Long id, String docStatus) {
        this.invCkRepoProc.updateDocStatus(id, docStatus);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateIsAjStatus(Long id, Integer isAjStatus) {
        this.invCkRepoProc.updateIsAjStatus(id, isAjStatus);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateProcInstStatusById(ProcInstStatus procInstStatus, Long id) {
        this.invCkRepoProc.updateProcInstStatusById(procInstStatus, id).execute();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateProcInst(ProcessInfo processInfo, Long id, String docStatus) {
        this.invCkRepoProc.updateProcInst(processInfo, id, docStatus).execute();
    }

    public InvCkDomainServiceImpl(InvCkRepo invCkRepo, InvCkRepoProc invCkRepoProc) {
        this.invCkRepo = invCkRepo;
        this.invCkRepoProc = invCkRepoProc;
    }
}

