/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.domain.service.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitesland.yst.production.inv.domain.convert.ck.InvCkDConvert;
import com.elitesland.yst.production.inv.domain.entity.ck.InvCkD;
import com.elitesland.yst.production.inv.domain.entity.ck.InvCkDDO;
import com.elitesland.yst.production.inv.domain.service.InvCkdDomainService;
import com.elitesland.yst.production.inv.infr.dto.ck.InvCkDDTO;
import com.elitesland.yst.production.inv.infr.repo.ck.InvCkDRepo;
import com.elitesland.yst.production.inv.infr.repo.ck.InvCkDRepoProc;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class InvCkdDomainServiceImpl
implements InvCkdDomainService {
    private final InvCkDRepo invCkDRepo;
    private final InvCkDRepoProc invCkDRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveInvCkD(InvCkD invCkD) {
        InvCkDDO invCkDDO = InvCkDConvert.INSTANCE.enToDo(invCkD);
        return ((InvCkDDO)this.invCkDRepo.save(invCkDDO)).getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> saveInvCkDList(List<InvCkD> invCkDList) {
        List invCkDDOList = invCkDList.stream().map(InvCkDConvert.INSTANCE::enToDo).collect(Collectors.toList());
        return this.invCkDRepo.saveAll(invCkDDOList).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByMasId(Long id) {
        this.invCkDRepo.deleteByMasId(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByMasIdBatch(List<Long> idList) {
        idList.forEach(this.invCkDRepo::deleteByMasId);
    }

    @Override
    @SysCodeProc
    public List<InvCkDDTO> selectByMasId(Long masId) {
        List<InvCkDDTO> invCkDDTOList = this.invCkDRepoProc.selectByMasId(masId);
        if (CollectionUtils.isEmpty(invCkDDTOList)) {
            return Collections.EMPTY_LIST;
        }
        return invCkDDTOList;
    }

    @Override
    public List<InvCkDDTO> selectByDeter2KeyWords(String deter2KeyWords) {
        if (!StringUtils.hasText((String)deter2KeyWords)) {
            throw new BusinessException(ApiCode.FAIL, "\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7");
        }
        return this.invCkDRepoProc.selectByDeter2KeyWords(deter2KeyWords);
    }

    public InvCkdDomainServiceImpl(InvCkDRepo invCkDRepo, InvCkDRepoProc invCkDRepoProc) {
        this.invCkDRepo = invCkDRepo;
        this.invCkDRepoProc = invCkDRepoProc;
    }
}

