/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.spi.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.elitesland.yst.production.inv.domain.entity.QInvAjDO;
import com.elitesland.yst.production.inv.enums.ProcDefKey;
import com.elitesland.yst.production.inv.spi.InvAjSpi;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.inv.vo.InvAjVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvAjSpiImpl
implements InvAjSpi {
    private static final Logger log = LoggerFactory.getLogger(InvAjSpiImpl.class);
    private WorkflowService workflowService;
    private JPAQueryFactory jpaQueryFactory;

    public Boolean submitAjCallBack(WorkflowService workflowService, JPAQueryFactory jpaQueryFactory, Long id, InvAjVO invAjDTO) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.workflowService = workflowService;
        if (id == null || invAjDTO.getProcInstId() == null || WorkflowConstant.CAN_START_PROC_STATUSES.contains(invAjDTO.getProcInstStatus())) {
            String procInstName = "\u5e93\u5b58\u8c03\u6574:" + invAjDTO.getDocNo();
            String procDefKeyName = ProcDefKey.INV_ADJST.name();
            this.startFile(procDefKeyName, invAjDTO, procInstName);
        }
        return true;
    }

    public void startFile(String procDefKeyName, InvAjVO invAjDTO, String procInstName) {
        WorkflowResult processInfoWorkflowResult = this.workflowService.startProcess(StartProcessPayload.of((String)procDefKeyName, (String)procInstName, (String)("" + invAjDTO.getId()), null));
        if (!processInfoWorkflowResult.isSuccess() || Objects.isNull(processInfoWorkflowResult.getData())) {
            throw new BusinessException("\u8c03\u7528\u5de5\u4f5c\u6d41\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f:" + processInfoWorkflowResult.getMsg());
        }
        QInvAjDO qInvAjDO = QInvAjDO.invAjDO;
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)qInvAjDO).set((Path)qInvAjDO.procInstId, (Object)((ProcessInfo)processInfoWorkflowResult.getData()).getProcInstId()).set(qInvAjDO.submitTime, (Object)LocalDateTime.now()).where(new Predicate[]{qInvAjDO.id.eq((Object)invAjDTO.getId())});
        if (!Objects.equals(((ProcessInfo)processInfoWorkflowResult.getData()).getProcInstStatus(), ProcInstStatus.APPROVED)) {
            jpaUpdateClause.set(qInvAjDO.procInstStatus, (Object)ProcInstStatus.APPROVING);
            jpaUpdateClause.set((Path)qInvAjDO.docStatus, (Object)UdcEnum.PUR_PO_STATUS_APPING.getValueCode());
        }
        jpaUpdateClause.execute();
    }
}

