package com.elitesland.yst.production.pur.dto.rns;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ApiModel(description = "退货申请单明细")
public class PurRnsDRpcDTO implements Serializable {

    private static final long serialVersionUID = -9066194839868175002L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("转移单明细ID")
    private Long id;

    @ApiModelProperty("商品id")
    private Long itemId;

    @ApiModelProperty("批次")
    private String lotNo;

    @ApiModelProperty("计划数量")
    private BigDecimal qty;

    @ApiModelProperty("出库数量")
    private BigDecimal outQty;

    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("出库存状态")
    private String outLimit1;

    @ApiModelProperty("关联明细id")
    private Long relateDocDid;
}