package com.elitesland.yst.production.pur.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2021/06/26
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "purPriceBatchParamDTO", description = "批量获取采购价格DTO入参")
public class PurPriceBatchParamDTO implements Serializable {
    private static final long serialVersionUID = 4539671829126021098L;

    @ApiModelProperty("批量获取采购价格DTO明细入参")
    @NotEmpty(message = "批量获取采购价格DTO明细入参不能为空")
    @Valid
    private List<PurPriceDetailParamDTO> purPriceDetailParamDtoList;

    @ApiModelProperty("公司ID")
    @NotNull(message = "公司ID不能为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    @ApiModelProperty("生效日期")
    @NotNull(message = "生效日期不能为空")
    private LocalDate validDate;
}
