package com.elitesland.yst.production.pur.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2021/06/26
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "purPriceDetailParamDTO", description = "批量获取采购价格DTO明细入参")
public class PurPriceDetailParamDTO implements Serializable {
    private static final long serialVersionUID = 1826798592265382116L;

    @ApiModelProperty("商品ID")
    @NotNull(message = "商品ID不能为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("单位")
    @NotNull(message = "单位不能为空")
    private String uom;

    @ApiModelProperty("币种")
    @NotNull(message = "币种不能为空")
    private String currCode;
}
