package com.elitesland.yst.production.pur.dto.po;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@ApiModel(description = "采购订单在线支付参数")
public class PurPoOnlinePayParamDTO implements Serializable {

    private static final long serialVersionUID = 402119355488680789L;

    @ApiModelProperty("采购订单编码")
    @NotBlank(message = "采购订单编码不能为空")
    private String docNo;

    @ApiModelProperty("在线支付单号")
    private String onlinePayOrderNo;

    @ApiModelProperty("在线支付时间")
    private LocalDateTime onlinePayTime;

    @ApiModelProperty("在线支付金额")
    private BigDecimal onlinePayAmt;

    @ApiModelProperty("在线支付标识")
    private Boolean onlinePayFlag;
}
