package com.elitesland.yst.production.pur.dto.account;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 对账单表
 *
 * @author chaofeng.xia
 * @date 2024/4/15 17:58
 */
@Data
@ApiModel(value = "purAccountCheckParamVO", description = "对账单表")
public class PurAccountCheckRpcParamVO implements Serializable {

    private static final long serialVersionUID = -8335936243134671233L;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long ouId;
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> ouIds;

    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long suppId;
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppIdSrm;

    @ApiModelProperty("id列表")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> ids;

    @ApiModelProperty("状态")
    String docStatus;
    private List<String> docStatusList;

    @ApiModelProperty("单据编号")
    String docNo;

    @ApiModelProperty("采购订单编号")
    String poNo;

    @ApiModelProperty("商品ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long itemId;

    @ApiModelProperty("单据类型")
    String accountType;

    @ApiModelProperty("对账开始日期 对账开始日期")
    LocalDateTime payFromDate;

    @ApiModelProperty("对账结束日期 对账结束日期")
    LocalDateTime payToDate;

    @ApiModelProperty("形式发票号码")
    String invNo;

    @ApiModelProperty("对账差异状态 标识是否有差异")
    String diffFlag;

    @ApiModelProperty("任务节点名称")
    String apprTaskName;

    @ApiModelProperty("审批状态")
    ProcInstStatus procInstStatus;

    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String relateDocCls;
    private String relateDocClsName;


    @ApiModelProperty("单据日期")
    private LocalDateTime relateDocDate;

    @ApiModelProperty("收发货单编码")
    private String relateDocNo;

    @ApiModelProperty("关联单据ID")
    private Long relateDocId;

    @ApiModelProperty("关联单据明细ID")
    private Long relateDocDid;

    @ApiModelProperty("收发货单行号")
    private BigDecimal relateDocLine;

    @ApiModelProperty("关联单据类别2")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String relateDoc2Cls;
    private String relateDoc2ClsName;

    @ApiModelProperty("订/退单编码")
    private String relateDoc2No;

    @ApiModelProperty("关联单据2ID")
    private Long relateDoc2Id;

    @ApiModelProperty("关联单据明细2ID")
    private Long relateDoc2Did;

    @ApiModelProperty("订/退单行号")
    private BigDecimal relateDoc2Line;

    @ApiModelProperty("对账单行号")
    private BigDecimal lineNo;

    @ApiModelProperty("任务节点名称")
    boolean mastdata;

}
