package com.elitesland.yst.production.pur.dto.po;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 采购订单明细(PurPoD)实体类
 *
 * @author liuqi
 * @since 2020-07-21 10:05:06
 */


@Data
@ApiModel(value = "pur_po_d", description = "采购订单明细")
public class PurPoDParamDTO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = 555547895571330470L;
    /**
     * 唯一编号ID
     */
    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    /**
     * 主表ID
     */
    @ApiModelProperty("主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;
    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;
    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;
    /**
     * 事业部ID
     */
    @ApiModelProperty("事业部ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long bdId;
    /**
     * 行号
     */
    @ApiModelProperty("行号")
    private Integer lineNo;
    /**
     * 行类型 [UDC]PUR:PO_LINE_TYPE
     */
    @ApiModelProperty("行类型 [UDC]PUR:PO_LINE_TYPE")
    private String lineType;
    /**
     * 行状态
     */
    @ApiModelProperty("行状态")
    private String lineStatus;
    /**
     * 收货仓库ID
     */
    @ApiModelProperty("收货仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;
    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;
    /**
     * 品项ID
     */
    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;
    /**
     * 品项编号
     */
    @ApiModelProperty("品项编号")
    private String itemCode;
    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    private String itemName;
    /**
     * 品项名称2
     */
    @ApiModelProperty("品项名称2")
    private String itemName2;
    /**
     * 品项规格
     */
    @ApiModelProperty("品项规格")
    private String itemSpec;
    /**
     * 供应商品项编号
     */
    @ApiModelProperty("供应商品项编号")
    private String itemCsCode;
    /**
     * 条码
     */
    @ApiModelProperty("条码")
    private String barcode;
    /**
     * 数量
     */
    @ApiModelProperty("数量")
    private Double qty;
    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String uom;
    /**
     * 数量2
     */
    @ApiModelProperty("数量2")
    private Double qty2;
    /**
     * 单位2
     */
    @ApiModelProperty("单位2")
    private String uom2;
    /**
     * 单位转换率
     */
    @ApiModelProperty("单位转换率")
    private BigDecimal uomRatio;
    /**
     * 保留小数位
     */
    @ApiModelProperty("保留小数位")
    private Integer decimalPlaces;
    /**
     * 单位转换率2
     */
    @ApiModelProperty("单位转换率2")
    private Double uomRatio2;
    /**
     * 包装要求
     */
    @ApiModelProperty("包装要求")
    private String packDemand;
    /**
     * 净重
     */
    @ApiModelProperty("净重")
    private Double netWeight;
    /**
     * 毛重
     */
    @ApiModelProperty("毛重")
    private Double grossWeight;
    /**
     * 重量单位
     */
    @ApiModelProperty("重量单位")
    private String weightUom;
    /**
     * 重量转换率 重量单位与主单位
     */
    @ApiModelProperty("重量转换率 重量单位与主单位")
    private Double weightRatio;
    /**
     * 体积
     */
    @ApiModelProperty("体积")
    private Double volume;
    /**
     * 体积单位
     */
    @ApiModelProperty("体积单位")
    private String volumeUom;
    /**
     * 基价
     */
    @ApiModelProperty("基价")
    private BigDecimal basePrice;
    /**
     * 价格类型
     */
    @ApiModelProperty("价格类型")
    private String priceType;
    /**
     * 不含税价格
     */
    @ApiModelProperty("不含税价格")
    private BigDecimal netPrice;
    /**
     * 含税单价
     */
    @ApiModelProperty("含税单价")
    private BigDecimal price;
    /**
     * 价格本价格
     */
    @ApiModelProperty("价格本价格")
    private BigDecimal pbPrice;
    /**
     * 折扣类型
     */
    @ApiModelProperty("折扣类型")
    private String discType;
    /**
     * 折扣率
     */
    @ApiModelProperty("折扣率")
    private Double discRatio;
    /**
     * 折扣额
     */
    @ApiModelProperty("折扣额")
    private BigDecimal discAmt;
    /**
     * 折扣描述
     */
    @ApiModelProperty("折扣描述")
    private String discDesc;
    /**
     * 折扣后价格
     */
    @ApiModelProperty("折扣后价格")
    private BigDecimal discedPrice;
    /**
     * 交易单价 折扣后，不含税
     */
    @ApiModelProperty("交易单价 折扣后，不含税")
    private BigDecimal transPrice;
    /**
     * 发票状态
     */
    @ApiModelProperty("发票状态")
    private String invStatus;
    /**
     * 发票日期
     */
    @ApiModelProperty("发票日期")
    private LocalDateTime invDate;
    /**
     * 供应商税类型
     */
    @ApiModelProperty("供应商税类型")
    private String suppTaxType;
    /**
     * 商品税类型
     */
    @ApiModelProperty("商品税类型")
    private String itemTaxType;
    /**
     * 税码
     */
    @ApiModelProperty("税码")
    private String taxCode;
    /**
     * 税率编号
     */
    @ApiModelProperty("税率编号")
    private String taxRateNo;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private Double taxRate;
    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /**
     * 含税金额
     */
    @ApiModelProperty("含税金额")
    private BigDecimal amt;
    /**
     * 不含税金额
     */
    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;
    /**
     * 外币含税金额
     */
    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;
    /**
     * 外币不含税金额
     */
    @ApiModelProperty("外币不含税金额")
    BigDecimal currNetAmt;
    /**
     * 本币币种
     */
    @ApiModelProperty("本币币种")
    private String homeCurr;
    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;
    /**
     * 汇率
     */
    @ApiModelProperty("汇率")
    private Double currRate;
    /**
     * 物流状态
     */
    @ApiModelProperty("物流状态")
    private String logisStatus;
    /**
     * 承诺数量
     */
    @ApiModelProperty("承诺数量")
    private Double promiseQty;
    /**
     * 通知发货数量
     */
    @ApiModelProperty("通知发货数量")
    private BigDecimal shipmentQty;
    /**
     * 已出库数量
     */
    @ApiModelProperty("已出库数量")
    private Double shippedQty;
    /**
     * 发货单位
     */
    @ApiModelProperty("发货单位")
    private String shipmentUom;
    /**
     * 已收数量
     */
    @ApiModelProperty("已收数量")
    private Double acceptQty;
    /**
     * 收货单位
     */
    @ApiModelProperty("收货单位")
    private String acceptUom;
    /**
     * 收货日期
     */
    @ApiModelProperty("收货日期")
    private LocalDateTime acceptDate;
    /**
     * 已退数量
     */
    @ApiModelProperty("已退数量")
    private Double returnedQty;
    /**
     * 差异数量
     */
    @ApiModelProperty("差异数量")
    private Double diffQty;
    /**
     * 供应商送货状态
     */
    @ApiModelProperty("供应商送货状态")
    private String suppShipmentStatus;
    /**
     * 延交状态
     */
    @ApiModelProperty("延交状态")
    private String overdueStatus;
    /**
     * 收货状态
     */
    @ApiModelProperty("收货状态")
    private String recvStatus;
    /**
     * 要求保质期比例
     */
    @ApiModelProperty("要求保质期比例")
    private Double demandFreshPercent;
    /**
     * 要求效期天数
     */
    @ApiModelProperty("要求效期天数")
    private Integer demandAapDays;
    /**
     * 原始交期
     */
    @ApiModelProperty("原始交期")
    private LocalDateTime origDate;
    /**
     * 要求交期
     */
    @ApiModelProperty("要求交期")
    private LocalDateTime demandDate;
    /**
     * 供应商承诺交期
     */
    @ApiModelProperty("供应商承诺交期")
    private LocalDateTime promiseDate;
    /**
     * 预计到货日期
     */
    @ApiModelProperty("预计到货日期")
    private LocalDateTime etaDate;
    /**
     * 供应商预约到货日期
     */
    @ApiModelProperty("供应商预约到货日期")
    private LocalDateTime scheduledArriveDate;
    /**
     * 最早收货日期
     */
    @ApiModelProperty("最早收货日期")
    private LocalDateTime firstRecvDate;
    /**
     * 最后收货日期
     */
    @ApiModelProperty("最后收货日期")
    private LocalDateTime lastRecvDate;
    /**
     * 收货允差
     */
    @ApiModelProperty("收货允差")
    private Double recvTolerance;
    /**
     * 收货允差2
     */
    @ApiModelProperty("收货允差2")
    private Double recvTolerance2;
    /**
     * 是否加急
     */
    @ApiModelProperty("是否加急")
    private Integer urgentFlag;
    /**
     * 催货说明
     */
    @ApiModelProperty("催货说明")
    private String urgeComment;
    /**
     * 供应商进度说明
     */
    @ApiModelProperty("供应商进度说明")
    private String suppComment;
    /**
     * 供方单号
     */
    @ApiModelProperty("供方单号")
    private String suppDocNo;
    /**
     * 已取消数量
     */
    @ApiModelProperty("已取消数量")
    private Double cancelQty;
    /**
     * 取消时间
     */
    @ApiModelProperty("取消时间")
    private LocalDateTime cancelTime;
    /**
     * 取消原因
     */
    @ApiModelProperty("取消原因")
    private String cancelReason;
    /**
     * 取消用户ID
     */
    @ApiModelProperty("取消用户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long cancelUserId;
    /**
     * 关闭时间
     */
    @ApiModelProperty("关闭时间")
    private LocalDateTime closeTime;
    /**
     * 关闭原因
     */
    @ApiModelProperty("关闭原因")
    private String closeReason;
    /**
     * 关闭用户ID
     */
    @ApiModelProperty("关闭用户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long closeUserId;
    /**
     * 免值标记
     */
    @ApiModelProperty("免值标记")
    private String zerovalType;
    /**
     * 促销ID
     */
    @ApiModelProperty("促销ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long promId;
    /**
     * 促销编号
     */
    @ApiModelProperty("促销编号")
    private String promNo;
    /**
     * 关联单据类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    private String relateDocCls;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    /**
     * 关联单据ID
     */
    @ApiModelProperty("关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocId;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
    /**
     * 关联单据明细ID
     */
    @ApiModelProperty("关联单据明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocDid;
    /**
     * 关联单据行号
     */
    @ApiModelProperty("关联单据行号")
    private Double relateDocLineno;
    /**
     * 关联单据2类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    private String relateDoc2Cls;
    /**
     * 关联单据2类型
     */
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    /**
     * 关联单据2ID
     */
    @ApiModelProperty("关联单据2ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc2Id;
    /**
     * 关联单据2编号
     */
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;
    /**
     * 关联单据2明细ID
     */
    @ApiModelProperty("关联单据2明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc2Did;
    /**
     * 关联单据2行号
     */
    @ApiModelProperty("关联单据2行号")
    private Double relateDoc2Lineno;
    /**
     * ES2
     */
    @ApiModelProperty("ES2")
    private String es2;
    /**
     * 租户ID
     */
    @ApiModelProperty("租户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long tenantId;
    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;
    /**
     * 记录创建者ID
     */
    @ApiModelProperty("记录创建者ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;

    @ApiModelProperty("记录创建者")
    private String creator;

    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;
    /**
     * 记录最后更新者ID
     */
    @ApiModelProperty("记录最后更新者ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long modifyUserId;

    @ApiModelProperty("记录最后更新者")
    private String updater;
    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;
    /**
     * 逻辑删除，0：未删除，1：已删除
     */
    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;
    /**
     * 版本信息，前端不用传
     */
    @ApiModelProperty("版本信息，前端不用传")
    private Integer auditDataVersion;

    @ApiModelProperty("品项Ids")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> itemIds;

    @ApiModelProperty("品牌")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<String> brands;

    @ApiModelProperty("已付数量")
    Double payedQty;

    @ApiModelProperty("已付金额")
    Double payedAmt;

    /**
     * 单据状态 [UDC]PUR:GR_STATUS
     */
    @ApiModelProperty("单据状态 [UDC]PUR:GR_STATUS")
    private List<String> docStatuss;

    @ApiModelProperty("越库标识")
    private Integer crosswhFlag;
    @ApiModelProperty("来源单据类别[UDC]COM:DOC_CLS]")
    String rootDocCls;

    @ApiModelProperty("来源单据类型")
    String rootDocType;

    @ApiModelProperty("来源单据ID")
    Long rootDocId;

    @ApiModelProperty("来源单据编号")
    String rootDocNo;

    @ApiModelProperty("来源单据明细ID")
    Long rootDocDid;
    List<Long> rootDocDids;

    @ApiModelProperty("来源单据行号")
    Integer rootDocLineNo;
    List<Integer> rootDocLineNos;
}
