package com.elitesland.yst.production.pur.dto.supp;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author liuqi
 * @date 2020/7/7
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel("地址号申请的银行账号")
public class PurAddrApplyBankAccRpcSaveVO extends CustomFieldBaseModelVo implements Serializable {

    @ApiModelProperty("账号类型:[UDC]ORG:ADDR_BANKACC_TYPE")
    String accType;

    @ApiModelProperty("是否默认：1是，0否")
    Boolean defaultFlag;

    @ApiModelProperty("银行ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long bankId;

    @ApiModelProperty("开户行名称")
    String bankName;

    @ApiModelProperty("网点名称")
    String branchName;

    @ApiModelProperty("开户行账号")
    String bankAcc;

    @ApiModelProperty("币种")
    String currCode;

    @ApiModelProperty("主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long masId;

    @ApiModelProperty("主表业务类型")
    String masDocCls;

    @ApiModelProperty("行号")
    Integer lineNo;

    /**
     * 唯一编号ID
     */
    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("数据来源")
    private String dataSource;
}
