package com.elitesland.yst.production.pur.provider;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.pur.Application;
import com.elitesland.yst.production.pur.dto.po.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author tina.he
 * @since 2021-06-07 10:01:53
 */
@FeignClient(name = Application.NAME, path = Application.PATH + PurPoDProvider.PATH)
@Validated
public interface PurPoDProvider {
    String PATH = "/purPoD";
    /**
     * 添加订单已收数
     *
     * @param purPoDUpdateParamDTO
     */
    @PostMapping("/addAcceptQty")
    void addAcceptQty(@RequestBody PurPoDUpdateParamDTO purPoDUpdateParamDTO);

    /**
     * 添加订单已发货数
     *
     * @param purPoDUpdateParamDTO
     */
    @PostMapping("/addShippedQty")
    void addShippedQty(@RequestBody PurPoDUpdateParamDTO purPoDUpdateParamDTO);

    @PutMapping("/reduceShippedQty")
    void reduceShippedQty(@RequestBody PurPoDUpdateParamDTO purPoDUpdateParamDTO);

    /**
     * 销售单处理
     */
//    List<PurPoDVO> so(PurAdvanceOrderParamVO purAdvanceOrderParamVO);

    /**
     * 根据主表ID集合，查询 明细表数据
     *
     * @param idList
     * @return
     */
    @PostMapping("/findByMasIds")
    List<PurPoDDTO> findByMasIds(@RequestBody List<Long> idList);



   // List<PurPoDDTO> dodfindMasId(List<Long> masIds);



    /**
     * 根据关键字段，返回对应的
     *
     * @param idList ID集合
     * @return 对象
     */
    @GetMapping("/findIdBatch")
    List<PurPoDDTO> findIdBatch(@RequestBody List<Long> idList);



    /**
     * 检索
     *
     * @param queryParam 分类查询、分页和排序对象
     * @return 分页结果集
     */
    @GetMapping("/search")
    PagingVO<PurPoDDTO> search(@RequestBody PurPoDParamDTO queryParam);



    /**
     * 创建
     *
     * @param list 对象集合
     */
    @PostMapping("/createBatch")
    List<Long> createBatch(@RequestBody List<PurPoDSaveDTO> list);


    /**
     * 更新删除标识
     *
     * @param id id
     */
   // void updateDeleteFlag(Long id);



    /**
     * 删除
     *
     * @param idList 对象集合
     */
    @DeleteMapping("/deleteBatch")
    void deleteBatch(@RequestBody List<Long> idList);

    /**
     * 根据项目公司采购单明细行号，明细Id查询总部采购订单详情
     *
     * @param paramVOList 对象集合
     */
    @GetMapping("/findByRootList")
    List<PurPoDDTO> findByRootList(List<PurPoDRootParamDTO> paramVOList);

    /**
     * 更新取消数量
     *
     * @param purPoDUpdateParamDTOS
     */
    @PutMapping("/updateCancelQty")
    void updateCancelQty(List<PurPoDUpdateParamDTO> purPoDUpdateParamDTOS);
}
