package com.elitesland.yst.production.pur.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.pur.Application;
import com.elitesland.yst.production.pur.dto.rns.PurRnsRgrRpcDTO;
import com.elitesland.yst.production.pur.dto.rns.PurRnsRpcDTO;
import com.elitesland.yst.production.pur.dto.rns.PurRnsSaveRpcParam;
import com.elitesland.yst.production.pur.dto.rns.PurRnsSaveRpcResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + PurRnsProvider.PATH)
public interface PurRnsProvider {
    String PATH = "/purRns";

    @PostMapping("/submitRns")
    ApiResult<PurRnsSaveRpcResult> submitRns(@RequestBody PurRnsSaveRpcParam purRnsSaveRpcParam);

    @GetMapping("/findById")
    ApiResult<PurRnsRpcDTO> findById(@RequestParam("id") Long id);

    @GetMapping("/findRgrByRns")
    ApiResult<PurRnsRgrRpcDTO> findRgrByRns(@RequestParam("id") Long id);

    /**
     * 根据退货申请单ID查询
     * @param ids
     * @return 审批中单据的ID集合
     */
    @PostMapping("/findApproving")
    ApiResult<List<Long>> findApproving(@RequestBody List<Long> ids);

    @PostMapping("/abort")
    ApiResult abort(@RequestParam("id") Long id);
}
