package com.elitesland.yst.production.pur.base;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * <pre>
 *     JPA数据实体类的基础类，用于唯一ID生成策略绑定
 *     审计字段、版本和逻辑删除标记，
 *     未来扩展租户ID信息
 * </pre>
 *
 * @author tina.he
 * @date 06/12/2021
 */
@Data
public class BaseModelParam {

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("账号唯一ID")
    private Long id;

    @ApiModelProperty(value = "租户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long tenantId;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "创建人")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;

    @ApiModelProperty(value = "审批人")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long approveUserId;

    @ApiModelProperty(value = "数据归属组织id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secBuId;

    @ApiModelProperty(value = "数据归属账号id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secUserId;

    @ApiModelProperty(value = "数据归属公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secOuId;

    @ApiModelProperty("记录创建者")
    private String creator;

    @ApiModelProperty(value = "审批时间")
    private LocalDateTime approveTime;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "修改人")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long modifyUserId;

    @ApiModelProperty("记录最后更新者")
    private String updater;

    @ApiModelProperty(value = "修改时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty(value = "逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;

    @ApiModelProperty(value = "版本")
    private Integer auditDataVersion;
    /**
     * 操作人姓名
     */
    @ApiModelProperty("操作人姓名")
    private String operUserName;
}
