package com.elitesland.yst.production.pur.dto.supp;

import com.elitescloud.boot.core.support.customfield.common.AbstractCustomFieldQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2021/06/01
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "purSuppParamDTO", description = "供应商DTO入参")
public class PurSuppParamDTO extends AbstractCustomFieldQueryParam implements Serializable {
    private static final long serialVersionUID = -9019063693977006418L;

    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> ids;

    @ApiModelProperty("供应商编号")
    private String suppCode;

    @ApiModelProperty("供应商编号")
    private List<String> suppCodes;

    @ApiModelProperty("地址号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrNo;

    @ApiModelProperty("地址号")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> addrNos;

    @ApiModelProperty("供应商类型2")
    private String suppType2;

    @ApiModelProperty("供应商类型2")
    private List<String> suppType2List;

    @ApiModelProperty("供应商状态")
    private String suppStatus;

    @ApiModelProperty("供应商状态")
    private List<String> suppStatusList;

    @ApiModelProperty("供应商类型3(标识来源)")
    private String suppType3;

    @ApiModelProperty("纳税人识别号")
    private String taxPayerId;
}
