package com.elitesland.yst.production.pur.provider;

import com.elitesland.yst.production.pur.Application;
import com.elitesland.yst.production.pur.dto.gr.PurGrDParamRpcDTO;
import com.elitesland.yst.production.pur.dto.gr.PurGrDRpcDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/01
 * @Version 1.0
 * @Content:
 */
@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + PurGrDProvider.PATH)
public interface PurGrDProvider {
    String PATH = "/purGrD";


    /**
     * 根据明细查询明细的行号等字段
     *
     * 财务 逻辑性采购入库/逻辑性采购退货出库流水生成单据 根据明细ID反查明细的行号等字段
     *
     * @param paramRpcDTO 查询入参
     * @return
     */
    @PostMapping("/findGrdByParam")
    List<PurGrDRpcDTO> findGrdByParam(@RequestBody PurGrDParamRpcDTO paramRpcDTO);

}
