package com.elitesland.yst.production.pur.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 采购价格终止入参对象
 *
 * @author chaofeng.xia
 * @date 2023/12/5 17:05
 */
@Data
@ApiModel(value = "purPriceCancelRpcDTO", description = "采购价格终止入参对象")
public class PurPriceCancelRpcDTO implements Serializable {

    private static final long serialVersionUID = 9171103398928997302L;

    @ApiModelProperty("商品id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("生效日期")
    private LocalDate validDate;

    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("商品ids")
    private List<Long> itemIds;

    @ApiModelProperty("备注 - 终止采购价格的原因")
    private String remark;

    @ApiModelProperty("价格终止时间  采购价格需要终止的时间")
    @NotNull(message = "价格终止时间不能为空")
    private LocalDateTime endTime;
}
